package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object AnnotationLiteral {
  def apply(graph: OdbGraph, id: Long) = new AnnotationLiteral(graph, id)

  val Label = "ANNOTATION_LITERAL"
  val LabelId: Int = 49

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
val InternalFlags = "INTERNAL_FLAGS" 
val Code = "CODE" 
val Name = "NAME" 
val Order = "ORDER" 
val ArgumentIndex = "ARGUMENT_INDEX" 
val ColumnNumber = "COLUMN_NUMBER" 
val LineNumber = "LINE_NUMBER" 
    val all: Set[String] = Set(DepthFirstOrder, InternalFlags, Code, Name, Order, ArgumentIndex, ColumnNumber, LineNumber)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, AnnotationLiteralDb => AnyRef] = Map(
       "DEPTH_FIRST_ORDER" -> { instance: AnnotationLiteralDb => instance.depthFirstOrder.orNull},
 "INTERNAL_FLAGS" -> { instance: AnnotationLiteralDb => instance.internalFlags.orNull},
 "CODE" -> { instance: AnnotationLiteralDb => instance.code},
 "NAME" -> { instance: AnnotationLiteralDb => instance.name},
 "ORDER" -> { instance: AnnotationLiteralDb => instance.order},
 "ARGUMENT_INDEX" -> { instance: AnnotationLiteralDb => instance.argumentIndex},
 "COLUMN_NUMBER" -> { instance: AnnotationLiteralDb => instance.columnNumber.orNull},
 "LINE_NUMBER" -> { instance: AnnotationLiteralDb => instance.lineNumber.orNull}
    )
  }

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[AnnotationLiteralDb] {
    override val forLabel = AnnotationLiteral.Label
    override val forLabelId = AnnotationLiteral.LabelId

    override def createNode(ref: NodeRef[AnnotationLiteralDb]) =
      new AnnotationLiteralDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = AnnotationLiteral(graph, id)
  }
}

trait AnnotationLiteralBase extends CpgNode with ExpressionBase with HasDepthFirstOrder with HasInternalFlags with HasCode with HasName with HasOrder with HasArgumentIndex with HasColumnNumber with HasLineNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class AnnotationLiteral(graph: OdbGraph, id: Long) extends NodeRef[AnnotationLiteralDb](graph, id)
  with AnnotationLiteralBase
  with StoredNode
  with Expression {
    override def depthFirstOrder = get().depthFirstOrder
  override def internalFlags = get().internalFlags
  override def code = get().code
  override def name = get().name
  override def order = get().order
  override def argumentIndex = get().argumentIndex
  override def columnNumber = get().columnNumber
  override def lineNumber = get().lineNumber
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = get()._annotationParameterAssignViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    AnnotationLiteral.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "name" 
case 5 => "order" 
case 6 => "argumentIndex" 
case 7 => "columnNumber" 
case 8 => "lineNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => name
case 5 => order
case 6 => argumentIndex
case 7 => columnNumber
case 8 => lineNumber
    }

  override def productPrefix = "AnnotationLiteral"
  override def productArity = 9
}

class AnnotationLiteralDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with Expression with AnnotationLiteralBase {

  override def layoutInformation: NodeLayoutInformation = AnnotationLiteral.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }
if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
  properties
}

  private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags

private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = _astIn.asScala.collect { case node: AnnotationParameterAssign => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    AnnotationLiteral.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "name" 
case 5 => "order" 
case 6 => "argumentIndex" 
case 7 => "columnNumber" 
case 8 => "lineNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => name
case 5 => order
case 6 => argumentIndex
case 7 => columnNumber
case 8 => lineNumber
    }

  override def productPrefix = "AnnotationLiteral"
  override def productArity = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationLiteralDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    AnnotationLiteral.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    AnnotationLiteral.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "INTERNAL_FLAGS") this._internalFlags = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = value.asInstanceOf[Integer] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = None 
 else  if (key == "INTERNAL_FLAGS") this._internalFlags = None 
 else  if (key == "CODE") this._code = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = null 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = None 
 else  if (key == "LINE_NUMBER") this._lineNumber = None 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

