package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object AnnotationParameterAssign {
  def apply(graph: OdbGraph, id: Long) = new AnnotationParameterAssign(graph, id)

  val Label = "ANNOTATION_PARAMETER_ASSIGN"
  val LabelId: Int = 6

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Code = "CODE" 
val Order = "ORDER" 
    val all: Set[String] = Set(Code, Order)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, AnnotationParameterAssignDb => AnyRef] = Map(
       "CODE" -> { instance: AnnotationParameterAssignDb => instance.code},
 "ORDER" -> { instance: AnnotationParameterAssignDb => instance.order}
    )
  }

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[AnnotationParameterAssignDb] {
    override val forLabel = AnnotationParameterAssign.Label
    override val forLabelId = AnnotationParameterAssign.LabelId

    override def createNode(ref: NodeRef[AnnotationParameterAssignDb]) =
      new AnnotationParameterAssignDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = AnnotationParameterAssign(graph, id)
  }
}

trait AnnotationParameterAssignBase extends CpgNode with AstNodeBase with HasCode with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class AnnotationParameterAssign(graph: OdbGraph, id: Long) extends NodeRef[AnnotationParameterAssignDb](graph, id)
  with AnnotationParameterAssignBase
  with StoredNode
  with AstNode {
    override def code = get().code
  override def order = get().order
  
  override def _astOut(): JIterator[StoredNode] = get()._astOut
def _annotationViaAstOut: Iterator[Annotation] = get()._annotationViaAstOut
def _arrayInitializerViaAstOut: Iterator[ArrayInitializer] = get()._arrayInitializerViaAstOut
def _annotationParameterViaAstOut: Iterator[AnnotationParameter] = get()._annotationParameterViaAstOut
def _annotationLiteralViaAstOut: Iterator[AnnotationLiteral] = get()._annotationLiteralViaAstOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _annotationViaAstIn: Iterator[Annotation] = get()._annotationViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    AnnotationParameterAssign.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => order
    }

  override def productPrefix = "AnnotationParameterAssign"
  override def productArity = 3
}

class AnnotationParameterAssignDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with AstNode with AnnotationParameterAssignBase {

  override def layoutInformation: NodeLayoutInformation = AnnotationParameterAssign.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

  private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order
  def _annotationParameterViaAstOut: Iterator[AnnotationParameter] = _astOut.asScala.collect { case node: AnnotationParameter => node }
def _annotationViaAstOut: Iterator[Annotation] = _astOut.asScala.collect { case node: Annotation => node }
def _annotationLiteralViaAstOut: Iterator[AnnotationLiteral] = _astOut.asScala.collect { case node: AnnotationLiteral => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _arrayInitializerViaAstOut: Iterator[ArrayInitializer] = _astOut.asScala.collect { case node: ArrayInitializer => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _annotationViaAstIn: Iterator[Annotation] = _astIn.asScala.collect { case node: Annotation => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    AnnotationParameterAssign.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => order
    }

  override def productPrefix = "AnnotationParameterAssign"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationParameterAssignDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    AnnotationParameterAssign.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    AnnotationParameterAssign.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "CODE") this._code = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

