package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Binding {
  def apply(graph: OdbGraph, id: Long) = new Binding(graph, id)

  val Label = "BINDING"
  val LabelId: Int = 146

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Binds.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Name = "NAME" 
val Signature = "SIGNATURE" 
val IsMethodNeverOverridden = "IS_METHOD_NEVER_OVERRIDDEN" 
    val all: Set[String] = Set(Name, Signature, IsMethodNeverOverridden)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, BindingDb => AnyRef] = Map(
       "NAME" -> { instance: BindingDb => instance.name},
 "SIGNATURE" -> { instance: BindingDb => instance.signature},
 "IS_METHOD_NEVER_OVERRIDDEN" -> { instance: BindingDb => instance.isMethodNeverOverridden.orNull}
    )
  }

  object Edges {
    val In: Array[String] = Array("BINDS","CONTAINS_NODE")
    val Out: Array[String] = Array("REF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[BindingDb] {
    override val forLabel = Binding.Label
    override val forLabelId = Binding.LabelId

    override def createNode(ref: NodeRef[BindingDb]) =
      new BindingDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Binding(graph, id)
  }
}

trait BindingBase extends CpgNode  with HasName with HasSignature with HasIsMethodNeverOverridden {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Binding(graph: OdbGraph, id: Long) extends NodeRef[BindingDb](graph, id)
  with BindingBase
  with StoredNode
   {
    override def name = get().name
  override def signature = get().signature
  override def isMethodNeverOverridden = get().isMethodNeverOverridden
  
  def _methodViaRefOut: Method = get()._methodViaRefOut
override def _refOut(): JIterator[StoredNode] = get()._refOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _typeDeclViaBindsIn: TypeDecl = get()._typeDeclViaBindsIn
override def _bindsIn(): JIterator[StoredNode] = get()._bindsIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Binding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "signature" 
case 3 => "isMethodNeverOverridden" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => signature
case 3 => isMethodNeverOverridden
    }

  override def productPrefix = "Binding"
  override def productArity = 4
}

class BindingDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with BindingBase {

  override def layoutInformation: NodeLayoutInformation = Binding.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (signature != null) { properties.put("SIGNATURE", signature) }
isMethodNeverOverridden.map { value => properties.put("IS_METHOD_NEVER_OVERRIDDEN", value) }
  properties
}

  private var _name: String = null
def name(): String = _name

private var _signature: String = null
def signature(): String = _signature

private var _isMethodNeverOverridden: Option[JBoolean] = None
def isMethodNeverOverridden(): Option[JBoolean] = _isMethodNeverOverridden
  def _methodViaRefOut: Method = _refOut.asScala.collect { case node: Method => node }.next
override def _refOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _typeDeclViaBindsIn: TypeDecl = _bindsIn.asScala.collect { case node: TypeDecl => node }.next
override def _bindsIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Binding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "signature" 
case 3 => "isMethodNeverOverridden" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => signature
case 3 => isMethodNeverOverridden
    }

  override def productPrefix = "Binding"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[BindingDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Binding.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Binding.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "SIGNATURE") this._signature = value.asInstanceOf[String] 
 else  if (key == "IS_METHOD_NEVER_OVERRIDDEN") this._isMethodNeverOverridden = Option(value).asInstanceOf[Option[JBoolean]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "NAME") this._name = null 
 else  if (key == "SIGNATURE") this._signature = null 
 else  if (key == "IS_METHOD_NEVER_OVERRIDDEN") this._isMethodNeverOverridden = None 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

