package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object ClosureBinding {
  def apply(graph: OdbGraph, id: Long) = new ClosureBinding(graph, id)

  val Label = "CLOSURE_BINDING"
  val LabelId: Int = 334

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ref.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Capture.layoutInformation, edges.CapturedBy.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val ClosureBindingId = "CLOSURE_BINDING_ID" 
val EvaluationStrategy = "EVALUATION_STRATEGY" 
val ClosureOriginalName = "CLOSURE_ORIGINAL_NAME" 
    val all: Set[String] = Set(ClosureBindingId, EvaluationStrategy, ClosureOriginalName)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, ClosureBindingDb => AnyRef] = Map(
       "CLOSURE_BINDING_ID" -> { instance: ClosureBindingDb => instance.closureBindingId.orNull},
 "EVALUATION_STRATEGY" -> { instance: ClosureBindingDb => instance.evaluationStrategy},
 "CLOSURE_ORIGINAL_NAME" -> { instance: ClosureBindingDb => instance.closureOriginalName.orNull}
    )
  }

  object Edges {
    val In: Array[String] = Array("CAPTURE","CAPTURED_BY","CONTAINS_NODE")
    val Out: Array[String] = Array("REF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[ClosureBindingDb] {
    override val forLabel = ClosureBinding.Label
    override val forLabelId = ClosureBinding.LabelId

    override def createNode(ref: NodeRef[ClosureBindingDb]) =
      new ClosureBindingDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = ClosureBinding(graph, id)
  }
}

trait ClosureBindingBase extends CpgNode  with HasClosureBindingId with HasEvaluationStrategy with HasClosureOriginalName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class ClosureBinding(graph: OdbGraph, id: Long) extends NodeRef[ClosureBindingDb](graph, id)
  with ClosureBindingBase
  with StoredNode
   {
    override def closureBindingId = get().closureBindingId
  override def evaluationStrategy = get().evaluationStrategy
  override def closureOriginalName = get().closureOriginalName
  
  def _localViaRefOut: Local = get()._localViaRefOut
def _methodParameterInViaRefOut: Iterator[MethodParameterIn] = get()._methodParameterInViaRefOut
override def _refOut(): JIterator[StoredNode] = get()._refOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodRefViaCaptureIn: Iterator[MethodRef] = get()._methodRefViaCaptureIn
override def _captureIn(): JIterator[StoredNode] = get()._captureIn
def _localViaCapturedByIn: Iterator[Local] = get()._localViaCapturedByIn
override def _capturedByIn(): JIterator[StoredNode] = get()._capturedByIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ClosureBinding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "closureBindingId" 
case 2 => "evaluationStrategy" 
case 3 => "closureOriginalName" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => closureBindingId
case 2 => evaluationStrategy
case 3 => closureOriginalName
    }

  override def productPrefix = "ClosureBinding"
  override def productArity = 4
}

class ClosureBindingDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with ClosureBindingBase {

  override def layoutInformation: NodeLayoutInformation = ClosureBinding.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  closureBindingId.map { value => properties.put("CLOSURE_BINDING_ID", value) }
if (evaluationStrategy != null) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
closureOriginalName.map { value => properties.put("CLOSURE_ORIGINAL_NAME", value) }
  properties
}

  private var _closureBindingId: Option[String] = None
def closureBindingId(): Option[String] = _closureBindingId

private var _evaluationStrategy: String = null
def evaluationStrategy(): String = _evaluationStrategy

private var _closureOriginalName: Option[String] = None
def closureOriginalName(): Option[String] = _closureOriginalName
  def _localViaRefOut: Local = _refOut.asScala.collect { case node: Local => node }.next
def _methodParameterInViaRefOut: Iterator[MethodParameterIn] = _refOut.asScala.collect { case node: MethodParameterIn => node }
override def _refOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodRefViaCaptureIn: Iterator[MethodRef] = _captureIn.asScala.collect { case node: MethodRef => node }
override def _captureIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _localViaCapturedByIn: Iterator[Local] = _capturedByIn.asScala.collect { case node: Local => node }
override def _capturedByIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    ClosureBinding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "closureBindingId" 
case 2 => "evaluationStrategy" 
case 3 => "closureOriginalName" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => closureBindingId
case 2 => evaluationStrategy
case 3 => closureOriginalName
    }

  override def productPrefix = "ClosureBinding"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ClosureBindingDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    ClosureBinding.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    ClosureBinding.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "CLOSURE_BINDING_ID") this._closureBindingId = Option(value).asInstanceOf[Option[String]] 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = value.asInstanceOf[String] 
 else  if (key == "CLOSURE_ORIGINAL_NAME") this._closureOriginalName = Option(value).asInstanceOf[Option[String]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "CLOSURE_BINDING_ID") this._closureBindingId = None 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = null 
 else  if (key == "CLOSURE_ORIGINAL_NAME") this._closureOriginalName = None 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

