package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Comment {
  def apply(graph: OdbGraph, id: Long) = new Comment(graph, id)

  val Label = "COMMENT"
  val LabelId: Int = 511

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val LineNumber = "LINE_NUMBER" 
val Code = "CODE" 
    val all: Set[String] = Set(LineNumber, Code)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, CommentDb => AnyRef] = Map(
       "LINE_NUMBER" -> { instance: CommentDb => instance.lineNumber.orNull},
 "CODE" -> { instance: CommentDb => instance.code}
    )
  }

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[CommentDb] {
    override val forLabel = Comment.Label
    override val forLabelId = Comment.LabelId

    override def createNode(ref: NodeRef[CommentDb]) =
      new CommentDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Comment(graph, id)
  }
}

trait CommentBase extends CpgNode  with HasLineNumber with HasCode {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Comment(graph: OdbGraph, id: Long) extends NodeRef[CommentDb](graph, id)
  with CommentBase
  with StoredNode
   {
    override def lineNumber = get().lineNumber
  override def code = get().code
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _fileViaAstIn: Iterator[File] = get()._fileViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Comment.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "lineNumber" 
case 2 => "code" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => lineNumber
case 2 => code
    }

  override def productPrefix = "Comment"
  override def productArity = 3
}

class CommentDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with CommentBase {

  override def layoutInformation: NodeLayoutInformation = Comment.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  lineNumber.map { value => properties.put("LINE_NUMBER", value) }
if (code != null) { properties.put("CODE", code) }
  properties
}

  private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _code: String = null
def code(): String = _code
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _fileViaAstIn: Iterator[File] = _astIn.asScala.collect { case node: File => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Comment.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "lineNumber" 
case 2 => "code" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => lineNumber
case 2 => code
    }

  override def productPrefix = "Comment"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[CommentDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Comment.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Comment.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "CODE") this._code = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "LINE_NUMBER") this._lineNumber = None 
 else  if (key == "CODE") this._code = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

