package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Dependency {
  def apply(graph: OdbGraph, id: Long) = new Dependency(graph, id)

  val Label = "DEPENDENCY"
  val LabelId: Int = 35

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val Version = "VERSION" 
val Name = "NAME" 
val DependencyGroupId = "DEPENDENCY_GROUP_ID" 
    val all: Set[String] = Set(Version, Name, DependencyGroupId)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, DependencyDb => AnyRef] = Map(
       "VERSION" -> { instance: DependencyDb => instance.version},
 "NAME" -> { instance: DependencyDb => instance.name},
 "DEPENDENCY_GROUP_ID" -> { instance: DependencyDb => instance.dependencyGroupId.orNull}
    )
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[DependencyDb] {
    override val forLabel = Dependency.Label
    override val forLabelId = Dependency.LabelId

    override def createNode(ref: NodeRef[DependencyDb]) =
      new DependencyDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Dependency(graph, id)
  }
}

trait DependencyBase extends CpgNode  with HasVersion with HasName with HasDependencyGroupId {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Dependency(graph: OdbGraph, id: Long) extends NodeRef[DependencyDb](graph, id)
  with DependencyBase
  with StoredNode
   {
    override def version = get().version
  override def name = get().name
  override def dependencyGroupId = get().dependencyGroupId
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Dependency.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "version" 
case 2 => "name" 
case 3 => "dependencyGroupId" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => version
case 2 => name
case 3 => dependencyGroupId
    }

  override def productPrefix = "Dependency"
  override def productArity = 4
}

class DependencyDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with DependencyBase {

  override def layoutInformation: NodeLayoutInformation = Dependency.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (version != null) { properties.put("VERSION", version) }
if (name != null) { properties.put("NAME", name) }
dependencyGroupId.map { value => properties.put("DEPENDENCY_GROUP_ID", value) }
  properties
}

  private var _version: String = null
def version(): String = _version

private var _name: String = null
def name(): String = _name

private var _dependencyGroupId: Option[String] = None
def dependencyGroupId(): Option[String] = _dependencyGroupId
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Dependency.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "version" 
case 2 => "name" 
case 3 => "dependencyGroupId" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => version
case 2 => name
case 3 => dependencyGroupId
    }

  override def productPrefix = "Dependency"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[DependencyDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Dependency.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Dependency.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "VERSION") this._version = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "DEPENDENCY_GROUP_ID") this._dependencyGroupId = Option(value).asInstanceOf[Option[String]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "VERSION") this._version = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "DEPENDENCY_GROUP_ID") this._dependencyGroupId = None 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

