package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object DetachedTrackingPoint {
  def apply(graph: OdbGraph, id: Long) = new DetachedTrackingPoint(graph, id)

  val Label = "DETACHED_TRACKING_POINT"
  val LabelId: Int = 1001

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    
    val all: Set[String] = Set()
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, DetachedTrackingPointDb => AnyRef] = Map(
      
    )
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[DetachedTrackingPointDb] {
    override val forLabel = DetachedTrackingPoint.Label
    override val forLabelId = DetachedTrackingPoint.LabelId

    override def createNode(ref: NodeRef[DetachedTrackingPointDb]) =
      new DetachedTrackingPointDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = DetachedTrackingPoint(graph, id)
  }
}

trait DetachedTrackingPointBase extends CpgNode with TrackingPointBase  {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def cfgNode: CfgNodeBase
}

class DetachedTrackingPoint(graph: OdbGraph, id: Long) extends NodeRef[DetachedTrackingPointDb](graph, id)
  with DetachedTrackingPointBase
  with StoredNode
  with TrackingPoint {
  
    def cfgNode = get().cfgNode
  def _cfgNodeViaContainsNodeOut: Iterator[CfgNode] = get()._cfgNodeViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    DetachedTrackingPoint.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "cfgNode" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => cfgNode
    }

  override def productPrefix = "DetachedTrackingPoint"
  override def productArity = 2
}

class DetachedTrackingPointDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with TrackingPoint with DetachedTrackingPointBase {

  override def layoutInformation: NodeLayoutInformation = DetachedTrackingPoint.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

  
  def _cfgNodeViaContainsNodeOut: Iterator[CfgNode] = _containsNodeOut.asScala.collect { case node: CfgNode => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    DetachedTrackingPoint.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "cfgNode" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => cfgNode
    }

  override def productPrefix = "DetachedTrackingPoint"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[DetachedTrackingPointDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    DetachedTrackingPoint.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    DetachedTrackingPoint.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
    throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type CfgNode */
def cfgNode: CfgNode =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "cfgNode").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[CfgNode])
    .head

}

