package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object DomNode {
  def apply(graph: OdbGraph, id: Long) = new DomNode(graph, id)

  val Label = "DOM_NODE"
  val LabelId: Int = 600

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.Contains.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Name = "NAME" 
    val all: Set[String] = Set(Name)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, DomNodeDb => AnyRef] = Map(
       "NAME" -> { instance: DomNodeDb => instance.name}
    )
  }

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS","CONTAINS_NODE")
    val Out: Array[String] = Array("AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[DomNodeDb] {
    override val forLabel = DomNode.Label
    override val forLabelId = DomNode.LabelId

    override def createNode(ref: NodeRef[DomNodeDb]) =
      new DomNodeDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = DomNode(graph, id)
  }
}

trait DomNodeBase extends CpgNode  with HasName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def attributes: List[DomAttributeBase]
}

class DomNode(graph: OdbGraph, id: Long) extends NodeRef[DomNodeDb](graph, id)
  with DomNodeBase
  with StoredNode
   {
    override def name = get().name
    def attributes = get().attributes
  def _domNodeViaAstOut: Iterator[DomNode] = get()._domNodeViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
def _domAttributeViaContainsNodeOut: Iterator[DomAttribute] = get()._domAttributeViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _domNodeViaAstIn: Iterator[DomNode] = get()._domNodeViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _configFileViaContainsIn: Iterator[ConfigFile] = get()._configFileViaContainsIn
override def _containsIn(): JIterator[StoredNode] = get()._containsIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    DomNode.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "attributes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => attributes
    }

  override def productPrefix = "DomNode"
  override def productArity = 3
}

class DomNodeDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with DomNodeBase {

  override def layoutInformation: NodeLayoutInformation = DomNode.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
  properties
}

  private var _name: String = null
def name(): String = _name
  def _domNodeViaAstOut: Iterator[DomNode] = _astOut.asScala.collect { case node: DomNode => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _domAttributeViaContainsNodeOut: Iterator[DomAttribute] = _containsNodeOut.asScala.collect { case node: DomAttribute => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _domNodeViaAstIn: Iterator[DomNode] = _astIn.asScala.collect { case node: DomNode => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _configFileViaContainsIn: Iterator[ConfigFile] = _containsIn.asScala.collect { case node: ConfigFile => node }
override def _containsIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    DomNode.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "attributes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => attributes
    }

  override def productPrefix = "DomNode"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[DomNodeDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    DomNode.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    DomNode.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "NAME") this._name = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "NAME") this._name = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type DomAttribute */
def attributes: List[DomAttribute] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "attributes").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[DomAttribute])
    .toList

}

