package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Finding {
  def apply(graph: OdbGraph, id: Long) = new Finding(graph, id)

  val Label = "FINDING"
  val LabelId: Int = 214

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    
    val all: Set[String] = Set()
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, FindingDb => AnyRef] = Map(
      
    )
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[FindingDb] {
    override val forLabel = Finding.Label
    override val forLabelId = Finding.LabelId

    override def createNode(ref: NodeRef[FindingDb]) =
      new FindingDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Finding(graph, id)
  }
}

trait FindingBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def evidence: List[CpgNode]
def keyValuePairs: List[KeyValuePairBase]
}

class Finding(graph: OdbGraph, id: Long) extends NodeRef[FindingDb](graph, id)
  with FindingBase
  with StoredNode
   {
  
    def evidence = get().evidence
  def keyValuePairs = get().keyValuePairs
  def _keyValuePairViaContainsNodeOut: Iterator[KeyValuePair] = get()._keyValuePairViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Finding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "evidence" 
case 2 => "keyValuePairs" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => evidence
case 2 => keyValuePairs
    }

  override def productPrefix = "Finding"
  override def productArity = 3
}

class FindingDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with FindingBase {

  override def layoutInformation: NodeLayoutInformation = Finding.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

  
  def _keyValuePairViaContainsNodeOut: Iterator[KeyValuePair] = _containsNodeOut.asScala.collect { case node: KeyValuePair => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Finding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "evidence" 
case 2 => "keyValuePairs" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => evidence
case 2 => keyValuePairs
    }

  override def productPrefix = "Finding"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FindingDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Finding.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Finding.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
    throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type CpgNode */
def evidence: List[CpgNode] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "evidence").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[CpgNode])
    .toList

/** link to 'contained' node of type KeyValuePair */
def keyValuePairs: List[KeyValuePair] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "keyValuePairs").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[KeyValuePair])
    .toList

}

