package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Flow {
  def apply(graph: OdbGraph, id: Long) = new Flow(graph, id)

  val Label = "FLOW"
  val LabelId: Int = 207

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    
    val all: Set[String] = Set()
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, FlowDb => AnyRef] = Map(
      
    )
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[FlowDb] {
    override val forLabel = Flow.Label
    override val forLabelId = Flow.LabelId

    override def createNode(ref: NodeRef[FlowDb]) =
      new FlowDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Flow(graph, id)
  }
}

trait FlowBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def points: List[ProgramPointBase]
def source: SourceBase
def sink: SinkBase
def transformations: List[TransformationBase]
def branchPoints: List[TrackingPointBase]
def cfgNodes: List[CfgNodeBase]
}

class Flow(graph: OdbGraph, id: Long) extends NodeRef[FlowDb](graph, id)
  with FlowBase
  with StoredNode
   {
  
    def points = get().points
  def source = get().source
  def sink = get().sink
  def transformations = get().transformations
  def branchPoints = get().branchPoints
  def cfgNodes = get().cfgNodes
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sinkViaContainsNodeOut: Iterator[Sink] = get()._sinkViaContainsNodeOut
def _cfgNodeViaContainsNodeOut: Iterator[CfgNode] = get()._cfgNodeViaContainsNodeOut
def _transformationViaContainsNodeOut: Iterator[Transformation] = get()._transformationViaContainsNodeOut
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = get()._trackingPointViaContainsNodeOut
def _programPointViaContainsNodeOut: Iterator[ProgramPoint] = get()._programPointViaContainsNodeOut
def _sourceViaContainsNodeOut: Iterator[Source] = get()._sourceViaContainsNodeOut
def _writeViaContainsNodeIn: Iterator[Write] = get()._writeViaContainsNodeIn
def _readViaContainsNodeIn: Iterator[Read] = get()._readViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = get()._ioflowViaContainsNodeIn
def _transformViaContainsNodeIn: Iterator[Transform] = get()._transformViaContainsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Flow.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "points" 
case 2 => "source" 
case 3 => "sink" 
case 4 => "transformations" 
case 5 => "branchPoints" 
case 6 => "cfgNodes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => points
case 2 => source
case 3 => sink
case 4 => transformations
case 5 => branchPoints
case 6 => cfgNodes
    }

  override def productPrefix = "Flow"
  override def productArity = 7
}

class FlowDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with FlowBase {

  override def layoutInformation: NodeLayoutInformation = Flow.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

  
  def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = _containsNodeOut.asScala.collect { case node: TrackingPoint => node }
def _cfgNodeViaContainsNodeOut: Iterator[CfgNode] = _containsNodeOut.asScala.collect { case node: CfgNode => node }
def _sinkViaContainsNodeOut: Iterator[Sink] = _containsNodeOut.asScala.collect { case node: Sink => node }
def _transformationViaContainsNodeOut: Iterator[Transformation] = _containsNodeOut.asScala.collect { case node: Transformation => node }
def _sourceViaContainsNodeOut: Iterator[Source] = _containsNodeOut.asScala.collect { case node: Source => node }
def _programPointViaContainsNodeOut: Iterator[ProgramPoint] = _containsNodeOut.asScala.collect { case node: ProgramPoint => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _transformViaContainsNodeIn: Iterator[Transform] = _containsNodeIn.asScala.collect { case node: Transform => node }
def _writeViaContainsNodeIn: Iterator[Write] = _containsNodeIn.asScala.collect { case node: Write => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = _containsNodeIn.asScala.collect { case node: Ioflow => node }
def _readViaContainsNodeIn: Iterator[Read] = _containsNodeIn.asScala.collect { case node: Read => node }

  override def label: String = {
    Flow.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "points" 
case 2 => "source" 
case 3 => "sink" 
case 4 => "transformations" 
case 5 => "branchPoints" 
case 6 => "cfgNodes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => points
case 2 => source
case 3 => sink
case 4 => transformations
case 5 => branchPoints
case 6 => cfgNodes
    }

  override def productPrefix = "Flow"
  override def productArity = 7

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FlowDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Flow.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Flow.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
    throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type ProgramPoint */
def points: List[ProgramPoint] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "points").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[ProgramPoint])
    .toList

/** link to 'contained' node of type Source */
def source: Source =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "source").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Source])
    .head

/** link to 'contained' node of type Sink */
def sink: Sink =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sink").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Sink])
    .head

/** link to 'contained' node of type Transformation */
def transformations: List[Transformation] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "transformations").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Transformation])
    .toList

/** link to 'contained' node of type TrackingPoint */
def branchPoints: List[TrackingPoint] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "branchPoints").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[TrackingPoint])
    .toList

/** link to 'contained' node of type CfgNode */
def cfgNodes: List[CfgNode] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "cfgNodes").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[CfgNode])
    .toList

}

