package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Framework {
  def apply(graph: OdbGraph, id: Long) = new Framework(graph, id)

  val Label = "FRAMEWORK"
  val LabelId: Int = 42

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.AttachedData.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val Name = "NAME" 
    val all: Set[String] = Set(Name)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, FrameworkDb => AnyRef] = Map(
       "NAME" -> { instance: FrameworkDb => instance.name}
    )
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("ATTACHED_DATA","CONTAINS_NODE")
  }

  val factory = new NodeFactory[FrameworkDb] {
    override val forLabel = Framework.Label
    override val forLabelId = Framework.LabelId

    override def createNode(ref: NodeRef[FrameworkDb]) =
      new FrameworkDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Framework(graph, id)
  }
}

trait FrameworkBase extends CpgNode  with HasName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Framework(graph: OdbGraph, id: Long) extends NodeRef[FrameworkDb](graph, id)
  with FrameworkBase
  with StoredNode
   {
    override def name = get().name
  
  def _frameworkDataViaAttachedDataOut: Iterator[FrameworkData] = get()._frameworkDataViaAttachedDataOut
override def _attachedDataOut(): JIterator[StoredNode] = get()._attachedDataOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Framework.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
    }

  override def productPrefix = "Framework"
  override def productArity = 2
}

class FrameworkDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with FrameworkBase {

  override def layoutInformation: NodeLayoutInformation = Framework.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
  properties
}

  private var _name: String = null
def name(): String = _name
  def _frameworkDataViaAttachedDataOut: Iterator[FrameworkData] = _attachedDataOut.asScala.collect { case node: FrameworkData => node }
override def _attachedDataOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Framework.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
    }

  override def productPrefix = "Framework"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FrameworkDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Framework.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Framework.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "NAME") this._name = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "NAME") this._name = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

