package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object FrameworkData {
  def apply(graph: OdbGraph, id: Long) = new FrameworkData(graph, id)

  val Label = "FRAMEWORK_DATA"
  val LabelId: Int = 43

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.AttachedData.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Name = "NAME" 
val Content = "CONTENT" 
    val all: Set[String] = Set(Name, Content)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, FrameworkDataDb => AnyRef] = Map(
       "NAME" -> { instance: FrameworkDataDb => instance.name},
 "CONTENT" -> { instance: FrameworkDataDb => instance.content}
    )
  }

  object Edges {
    val In: Array[String] = Array("ATTACHED_DATA","CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[FrameworkDataDb] {
    override val forLabel = FrameworkData.Label
    override val forLabelId = FrameworkData.LabelId

    override def createNode(ref: NodeRef[FrameworkDataDb]) =
      new FrameworkDataDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = FrameworkData(graph, id)
  }
}

trait FrameworkDataBase extends CpgNode  with HasName with HasContent {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class FrameworkData(graph: OdbGraph, id: Long) extends NodeRef[FrameworkDataDb](graph, id)
  with FrameworkDataBase
  with StoredNode
   {
    override def name = get().name
  override def content = get().content
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _frameworkViaAttachedDataIn: Iterator[Framework] = get()._frameworkViaAttachedDataIn
override def _attachedDataIn(): JIterator[StoredNode] = get()._attachedDataIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    FrameworkData.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "content" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => content
    }

  override def productPrefix = "FrameworkData"
  override def productArity = 3
}

class FrameworkDataDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with FrameworkDataBase {

  override def layoutInformation: NodeLayoutInformation = FrameworkData.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (content != null) { properties.put("CONTENT", content) }
  properties
}

  private var _name: String = null
def name(): String = _name

private var _content: String = null
def content(): String = _content
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _frameworkViaAttachedDataIn: Iterator[Framework] = _attachedDataIn.asScala.collect { case node: Framework => node }
override def _attachedDataIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    FrameworkData.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "content" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => content
    }

  override def productPrefix = "FrameworkData"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FrameworkDataDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    FrameworkData.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    FrameworkData.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "CONTENT") this._content = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "NAME") this._name = null 
 else  if (key == "CONTENT") this._content = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

