package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object ImplicitCall {
  def apply(graph: OdbGraph, id: Long) = new ImplicitCall(graph, id)

  val Label = "IMPLICIT_CALL"
  val LabelId: Int = 307

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
val InternalFlags = "INTERNAL_FLAGS" 
val Code = "CODE" 
val Name = "NAME" 
val Signature = "SIGNATURE" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val Order = "ORDER" 
    val all: Set[String] = Set(DepthFirstOrder, InternalFlags, Code, Name, Signature, LineNumber, ColumnNumber, Order)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, ImplicitCallDb => AnyRef] = Map(
       "DEPTH_FIRST_ORDER" -> { instance: ImplicitCallDb => instance.depthFirstOrder.orNull},
 "INTERNAL_FLAGS" -> { instance: ImplicitCallDb => instance.internalFlags.orNull},
 "CODE" -> { instance: ImplicitCallDb => instance.code},
 "NAME" -> { instance: ImplicitCallDb => instance.name},
 "SIGNATURE" -> { instance: ImplicitCallDb => instance.signature},
 "LINE_NUMBER" -> { instance: ImplicitCallDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: ImplicitCallDb => instance.columnNumber.orNull},
 "ORDER" -> { instance: ImplicitCallDb => instance.order}
    )
  }

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[ImplicitCallDb] {
    override val forLabel = ImplicitCall.Label
    override val forLabelId = ImplicitCall.LabelId

    override def createNode(ref: NodeRef[ImplicitCallDb]) =
      new ImplicitCallDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = ImplicitCall(graph, id)
  }
}

trait ImplicitCallBase extends CpgNode with CallReprBase with TrackingPointBase with HasDepthFirstOrder with HasInternalFlags with HasCode with HasName with HasSignature with HasLineNumber with HasColumnNumber with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class ImplicitCall(graph: OdbGraph, id: Long) extends NodeRef[ImplicitCallDb](graph, id)
  with ImplicitCallBase
  with StoredNode
  with CallRepr with TrackingPoint {
    override def depthFirstOrder = get().depthFirstOrder
  override def internalFlags = get().internalFlags
  override def code = get().code
  override def name = get().name
  override def signature = get().signature
  override def lineNumber = get().lineNumber
  override def columnNumber = get().columnNumber
  override def order = get().order
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodViaAstIn: Iterator[Method] = get()._methodViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ImplicitCall.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "name" 
case 5 => "signature" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
case 8 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => name
case 5 => signature
case 6 => lineNumber
case 7 => columnNumber
case 8 => order
    }

  override def productPrefix = "ImplicitCall"
  override def productArity = 9
}

class ImplicitCallDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with CallRepr with TrackingPoint with ImplicitCallBase {

  override def layoutInformation: NodeLayoutInformation = ImplicitCall.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }
if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (signature != null) { properties.put("SIGNATURE", signature) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

  private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags

private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _signature: String = null
def signature(): String = _signature

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _order: Integer = null
def order(): Integer = _order
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstIn: Iterator[Method] = _astIn.asScala.collect { case node: Method => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    ImplicitCall.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "name" 
case 5 => "signature" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
case 8 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => name
case 5 => signature
case 6 => lineNumber
case 7 => columnNumber
case 8 => order
    }

  override def productPrefix = "ImplicitCall"
  override def productArity = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ImplicitCallDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    ImplicitCall.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    ImplicitCall.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "INTERNAL_FLAGS") this._internalFlags = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "SIGNATURE") this._signature = value.asInstanceOf[String] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = None 
 else  if (key == "INTERNAL_FLAGS") this._internalFlags = None 
 else  if (key == "CODE") this._code = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "SIGNATURE") this._signature = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = None 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = None 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

