package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Ioflow {
  def apply(graph: OdbGraph, id: Long) = new Ioflow(graph, id)

  val Label = "IOFLOW"
  val LabelId: Int = 212

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Fingerprint = "FINGERPRINT" 
val LiteralsToSink = "LITERALS_TO_SINK" 
    val all: Set[String] = Set(Fingerprint, LiteralsToSink)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, IoflowDb => AnyRef] = Map(
       "FINGERPRINT" -> { instance: IoflowDb => instance.fingerprint},
 "LITERALS_TO_SINK" -> { instance: IoflowDb => instance.literalsToSink}
    )
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[IoflowDb] {
    override val forLabel = Ioflow.Label
    override val forLabelId = Ioflow.LabelId

    override def createNode(ref: NodeRef[IoflowDb]) =
      new IoflowDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Ioflow(graph, id)
  }
}

trait IoflowBase extends CpgNode  with HasFingerprint with HasLiteralsToSink {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def dataTags: List[TagBase]
def sourceDescriptorTags: List[TagBase]
def sinkDescriptorTags: List[TagBase]
def sourceTags: List[TagBase]
def dstTags: List[TagBase]
def source: SourceBase
def sink: SinkBase
def transforms: List[TransformBase]
def sourceDescriptorFlows: List[FlowBase]
def sinkDescriptorFlows: List[FlowBase]
def primaryFlow: FlowBase
def triggerMethods: List[MethodBase]
}

class Ioflow(graph: OdbGraph, id: Long) extends NodeRef[IoflowDb](graph, id)
  with IoflowBase
  with StoredNode
   {
    override def fingerprint = get().fingerprint
  override def literalsToSink = get().literalsToSink
    def dataTags = get().dataTags
  def sourceDescriptorTags = get().sourceDescriptorTags
  def sinkDescriptorTags = get().sinkDescriptorTags
  def sourceTags = get().sourceTags
  def dstTags = get().dstTags
  def source = get().source
  def sink = get().sink
  def transforms = get().transforms
  def sourceDescriptorFlows = get().sourceDescriptorFlows
  def sinkDescriptorFlows = get().sinkDescriptorFlows
  def primaryFlow = get().primaryFlow
  def triggerMethods = get().triggerMethods
  def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
def _methodViaContainsNodeOut: Iterator[Method] = get()._methodViaContainsNodeOut
def _flowViaContainsNodeOut: Iterator[Flow] = get()._flowViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _transformViaContainsNodeOut: Iterator[Transform] = get()._transformViaContainsNodeOut
def _sinkViaContainsNodeOut: Iterator[Sink] = get()._sinkViaContainsNodeOut
def _sourceViaContainsNodeOut: Iterator[Source] = get()._sourceViaContainsNodeOut
def _sensitiveReferenceViaContainsNodeIn: Iterator[SensitiveReference] = get()._sensitiveReferenceViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Ioflow.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "fingerprint" 
case 2 => "literalsToSink" 
case 3 => "dataTags" 
case 4 => "sourceDescriptorTags" 
case 5 => "sinkDescriptorTags" 
case 6 => "sourceTags" 
case 7 => "dstTags" 
case 8 => "source" 
case 9 => "sink" 
case 10 => "transforms" 
case 11 => "sourceDescriptorFlows" 
case 12 => "sinkDescriptorFlows" 
case 13 => "primaryFlow" 
case 14 => "triggerMethods" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => fingerprint
case 2 => literalsToSink
case 3 => dataTags
case 4 => sourceDescriptorTags
case 5 => sinkDescriptorTags
case 6 => sourceTags
case 7 => dstTags
case 8 => source
case 9 => sink
case 10 => transforms
case 11 => sourceDescriptorFlows
case 12 => sinkDescriptorFlows
case 13 => primaryFlow
case 14 => triggerMethods
    }

  override def productPrefix = "Ioflow"
  override def productArity = 15
}

class IoflowDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with IoflowBase {

  override def layoutInformation: NodeLayoutInformation = Ioflow.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (fingerprint != null) { properties.put("FINGERPRINT", fingerprint) }
if (literalsToSink.nonEmpty) { properties.put("LITERALS_TO_SINK", literalsToSink.asJava) }
  properties
}

  private var _fingerprint: String = null
def fingerprint(): String = _fingerprint

private var _literalsToSink: List[String] = Nil
def literalsToSink(): List[String] = _literalsToSink
  def _methodViaContainsNodeOut: Iterator[Method] = _containsNodeOut.asScala.collect { case node: Method => node }
def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
def _flowViaContainsNodeOut: Iterator[Flow] = _containsNodeOut.asScala.collect { case node: Flow => node }
def _transformViaContainsNodeOut: Iterator[Transform] = _containsNodeOut.asScala.collect { case node: Transform => node }
def _sinkViaContainsNodeOut: Iterator[Sink] = _containsNodeOut.asScala.collect { case node: Sink => node }
def _sourceViaContainsNodeOut: Iterator[Source] = _containsNodeOut.asScala.collect { case node: Source => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _sensitiveReferenceViaContainsNodeIn: Iterator[SensitiveReference] = _containsNodeIn.asScala.collect { case node: SensitiveReference => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Ioflow.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "fingerprint" 
case 2 => "literalsToSink" 
case 3 => "dataTags" 
case 4 => "sourceDescriptorTags" 
case 5 => "sinkDescriptorTags" 
case 6 => "sourceTags" 
case 7 => "dstTags" 
case 8 => "source" 
case 9 => "sink" 
case 10 => "transforms" 
case 11 => "sourceDescriptorFlows" 
case 12 => "sinkDescriptorFlows" 
case 13 => "primaryFlow" 
case 14 => "triggerMethods" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => fingerprint
case 2 => literalsToSink
case 3 => dataTags
case 4 => sourceDescriptorTags
case 5 => sinkDescriptorTags
case 6 => sourceTags
case 7 => dstTags
case 8 => source
case 9 => sink
case 10 => transforms
case 11 => sourceDescriptorFlows
case 12 => sinkDescriptorFlows
case 13 => primaryFlow
case 14 => triggerMethods
    }

  override def productPrefix = "Ioflow"
  override def productArity = 15

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[IoflowDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Ioflow.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Ioflow.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "FINGERPRINT") this._fingerprint = value.asInstanceOf[String] 
 else if (key == "LITERALS_TO_SINK") {
  if( value.isInstanceOf[List[_]]) { 
    this._literalsToSink = value.asInstanceOf[List[String]] 
  } else if (cardinality == VertexProperty.Cardinality.list) {
    if (this._literalsToSink == null) { this._literalsToSink = Nil }
    this._literalsToSink = this._literalsToSink :+ value.asInstanceOf[String]
  } else {
    this._literalsToSink = List(value.asInstanceOf[String])
  }
}

 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "FINGERPRINT") this._fingerprint = null 
 else  if (key == "LITERALS_TO_SINK") this._literalsToSink = Nil 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type Tag */
def dataTags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "dataTags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

/** link to 'contained' node of type Tag */
def sourceDescriptorTags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sourceDescriptorTags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

/** link to 'contained' node of type Tag */
def sinkDescriptorTags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sinkDescriptorTags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

/** link to 'contained' node of type Tag */
def sourceTags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sourceTags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

/** link to 'contained' node of type Tag */
def dstTags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "dstTags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

/** link to 'contained' node of type Source */
def source: Source =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "source").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Source])
    .head

/** link to 'contained' node of type Sink */
def sink: Sink =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sink").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Sink])
    .head

/** link to 'contained' node of type Transform */
def transforms: List[Transform] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "transforms").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Transform])
    .toList

/** link to 'contained' node of type Flow */
def sourceDescriptorFlows: List[Flow] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sourceDescriptorFlows").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Flow])
    .toList

/** link to 'contained' node of type Flow */
def sinkDescriptorFlows: List[Flow] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sinkDescriptorFlows").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Flow])
    .toList

/** link to 'contained' node of type Flow */
def primaryFlow: Flow =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "primaryFlow").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Flow])
    .head

/** link to 'contained' node of type Method */
def triggerMethods: List[Method] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "triggerMethods").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Method])
    .toList

}

