package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object KeyValuePair {
  def apply(graph: OdbGraph, id: Long) = new KeyValuePair(graph, id)

  val Label = "KEY_VALUE_PAIR"
  val LabelId: Int = 217

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Key = "KEY" 
val Value = "VALUE" 
    val all: Set[String] = Set(Key, Value)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, KeyValuePairDb => AnyRef] = Map(
       "KEY" -> { instance: KeyValuePairDb => instance.key},
 "VALUE" -> { instance: KeyValuePairDb => instance.value}
    )
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[KeyValuePairDb] {
    override val forLabel = KeyValuePair.Label
    override val forLabelId = KeyValuePair.LabelId

    override def createNode(ref: NodeRef[KeyValuePairDb]) =
      new KeyValuePairDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = KeyValuePair(graph, id)
  }
}

trait KeyValuePairBase extends CpgNode  with HasKey with HasValue {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class KeyValuePair(graph: OdbGraph, id: Long) extends NodeRef[KeyValuePairDb](graph, id)
  with KeyValuePairBase
  with StoredNode
   {
    override def key = get().key
  override def value = get().value
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _findingViaContainsNodeIn: Iterator[Finding] = get()._findingViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    KeyValuePair.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "key" 
case 2 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => key
case 2 => value
    }

  override def productPrefix = "KeyValuePair"
  override def productArity = 3
}

class KeyValuePairDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with KeyValuePairBase {

  override def layoutInformation: NodeLayoutInformation = KeyValuePair.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (key != null) { properties.put("KEY", key) }
if (value != null) { properties.put("VALUE", value) }
  properties
}

  private var _key: String = null
def key(): String = _key

private var _value: String = null
def value(): String = _value
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _findingViaContainsNodeIn: Iterator[Finding] = _containsNodeIn.asScala.collect { case node: Finding => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    KeyValuePair.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "key" 
case 2 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => key
case 2 => value
    }

  override def productPrefix = "KeyValuePair"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[KeyValuePairDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    KeyValuePair.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    KeyValuePair.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "KEY") this._key = value.asInstanceOf[String] 
 else  if (key == "VALUE") this._value = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "KEY") this._key = null 
 else  if (key == "VALUE") this._value = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

