package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Local {
  def apply(graph: OdbGraph, id: Long) = new Local(graph, id)

  val Label = "LOCAL"
  val LabelId: Int = 23

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.TaggedBy.layoutInformation, edges.DynamicType.layoutInformation, edges.CapturedBy.layoutInformation, edges.ContainsNode.layoutInformation, edges.EvalType.layoutInformation).asJava,
    List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.Ref.layoutInformation, edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Code = "CODE" 
val Name = "NAME" 
val ClosureBindingId = "CLOSURE_BINDING_ID" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val Order = "ORDER" 
    val all: Set[String] = Set(Code, Name, ClosureBindingId, TypeFullName, DynamicTypeHintFullName, LineNumber, ColumnNumber, Order)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, LocalDb => AnyRef] = Map(
       "CODE" -> { instance: LocalDb => instance.code},
 "NAME" -> { instance: LocalDb => instance.name},
 "CLOSURE_BINDING_ID" -> { instance: LocalDb => instance.closureBindingId.orNull},
 "TYPE_FULL_NAME" -> { instance: LocalDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: LocalDb => instance.dynamicTypeHintFullName},
 "LINE_NUMBER" -> { instance: LocalDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: LocalDb => instance.columnNumber.orNull},
 "ORDER" -> { instance: LocalDb => instance.order}
    )
  }

  object Edges {
    val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","REF","IS_SENSITIVE_DATA_DESCR_OF_REF","AST","CONTAINS_NODE")
    val Out: Array[String] = Array("TAGGED_BY","DYNAMIC_TYPE","CAPTURED_BY","CONTAINS_NODE","EVAL_TYPE")
  }

  val factory = new NodeFactory[LocalDb] {
    override val forLabel = Local.Label
    override val forLabelId = Local.LabelId

    override def createNode(ref: NodeRef[LocalDb]) =
      new LocalDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Local(graph, id)
  }
}

trait LocalBase extends CpgNode with DeclarationBase with LocalLikeBase with AstNodeBase with HasCode with HasName with HasClosureBindingId with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Local(graph: OdbGraph, id: Long) extends NodeRef[LocalDb](graph, id)
  with LocalBase
  with StoredNode
  with Declaration with LocalLike with AstNode {
    override def code = get().code
  override def name = get().name
  override def closureBindingId = get().closureBindingId
  override def typeFullName = get().typeFullName
  override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
  override def lineNumber = get().lineNumber
  override def columnNumber = get().columnNumber
  override def order = get().order
  
  def _tagViaTaggedByOut: Iterator[Tag] = get()._tagViaTaggedByOut
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut
def _methodViaDynamicTypeOut: Iterator[Method] = get()._methodViaDynamicTypeOut
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = get()._typeDeclViaDynamicTypeOut
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut
def _closureBindingViaCapturedByOut: Iterator[ClosureBinding] = get()._closureBindingViaCapturedByOut
override def _capturedByOut(): JIterator[StoredNode] = get()._capturedByOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _typeViaEvalTypeOut: Iterator[Type] = get()._typeViaEvalTypeOut
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut
def _sensitiveVariableViaIsSensitiveDataDescrOfIn: Iterator[SensitiveVariable] = get()._sensitiveVariableViaIsSensitiveDataDescrOfIn
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn
def _closureBindingViaRefIn: Iterator[ClosureBinding] = get()._closureBindingViaRefIn
def _identifierViaRefIn: Iterator[Identifier] = get()._identifierViaRefIn
override def _refIn(): JIterator[StoredNode] = get()._refIn
def _sensitiveReferenceViaIsSensitiveDataDescrOfRefIn: Iterator[SensitiveReference] = get()._sensitiveReferenceViaIsSensitiveDataDescrOfRefIn
override def _isSensitiveDataDescrOfRefIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefIn
def _unknownViaAstIn: Iterator[Unknown] = get()._unknownViaAstIn
def _controlStructureViaAstIn: Iterator[ControlStructure] = get()._controlStructureViaAstIn
def _blockViaAstIn: Iterator[Block] = get()._blockViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Local.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "closureBindingId" 
case 4 => "typeFullName" 
case 5 => "dynamicTypeHintFullName" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
case 8 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => name
case 3 => closureBindingId
case 4 => typeFullName
case 5 => dynamicTypeHintFullName
case 6 => lineNumber
case 7 => columnNumber
case 8 => order
    }

  override def productPrefix = "Local"
  override def productArity = 9
}

class LocalDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with Declaration with LocalLike with AstNode with LocalBase {

  override def layoutInformation: NodeLayoutInformation = Local.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
closureBindingId.map { value => properties.put("CLOSURE_BINDING_ID", value) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

  private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _closureBindingId: Option[String] = None
def closureBindingId(): Option[String] = _closureBindingId

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _order: Integer = null
def order(): Integer = _order
  def _tagViaTaggedByOut: Iterator[Tag] = _taggedByOut.asScala.collect { case node: Tag => node }
override def _taggedByOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _methodViaDynamicTypeOut: Iterator[Method] = _dynamicTypeOut.asScala.collect { case node: Method => node }
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = _dynamicTypeOut.asScala.collect { case node: TypeDecl => node }
override def _dynamicTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _closureBindingViaCapturedByOut: Iterator[ClosureBinding] = _capturedByOut.asScala.collect { case node: ClosureBinding => node }
override def _capturedByOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _typeViaEvalTypeOut: Iterator[Type] = _evalTypeOut.asScala.collect { case node: Type => node }
override def _evalTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _sensitiveVariableViaIsSensitiveDataDescrOfIn: Iterator[SensitiveVariable] = _isSensitiveDataDescrOfIn.asScala.collect { case node: SensitiveVariable => node }
override def _isSensitiveDataDescrOfIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _closureBindingViaRefIn: Iterator[ClosureBinding] = _refIn.asScala.collect { case node: ClosureBinding => node }
def _identifierViaRefIn: Iterator[Identifier] = _refIn.asScala.collect { case node: Identifier => node }
override def _refIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _sensitiveReferenceViaIsSensitiveDataDescrOfRefIn: Iterator[SensitiveReference] = _isSensitiveDataDescrOfRefIn.asScala.collect { case node: SensitiveReference => node }
override def _isSensitiveDataDescrOfRefIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
def _unknownViaAstIn: Iterator[Unknown] = _astIn.asScala.collect { case node: Unknown => node }
def _controlStructureViaAstIn: Iterator[ControlStructure] = _astIn.asScala.collect { case node: ControlStructure => node }
def _blockViaAstIn: Iterator[Block] = _astIn.asScala.collect { case node: Block => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Local.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "closureBindingId" 
case 4 => "typeFullName" 
case 5 => "dynamicTypeHintFullName" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
case 8 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => name
case 3 => closureBindingId
case 4 => typeFullName
case 5 => dynamicTypeHintFullName
case 6 => lineNumber
case 7 => columnNumber
case 8 => order
    }

  override def productPrefix = "Local"
  override def productArity = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[LocalDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Local.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Local.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "CLOSURE_BINDING_ID") this._closureBindingId = Option(value).asInstanceOf[Option[String]] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
  if( value.isInstanceOf[List[_]]) { 
    this._dynamicTypeHintFullName = value.asInstanceOf[List[String]] 
  } else if (cardinality == VertexProperty.Cardinality.list) {
    if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
    this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
  } else {
    this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
  }
}

 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "CODE") this._code = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "CLOSURE_BINDING_ID") this._closureBindingId = None 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = Nil 
 else  if (key == "LINE_NUMBER") this._lineNumber = None 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = None 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

