package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Location {
  def apply(graph: OdbGraph, id: Long) = new Location(graph, id)

  val Label = "LOCATION"
  val LabelId: Int = 25

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val Symbol = "SYMBOL" 
val MethodFullName = "METHOD_FULL_NAME" 
val MethodShortName = "METHOD_SHORT_NAME" 
val PackageName = "PACKAGE_NAME" 
val LineNumber = "LINE_NUMBER" 
val ClassName = "CLASS_NAME" 
val ClassShortName = "CLASS_SHORT_NAME" 
val NodeLabel = "NODE_LABEL" 
val Filename = "FILENAME" 
    val all: Set[String] = Set(Symbol, MethodFullName, MethodShortName, PackageName, LineNumber, ClassName, ClassShortName, NodeLabel, Filename)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, LocationDb => AnyRef] = Map(
       "SYMBOL" -> { instance: LocationDb => instance.symbol},
 "METHOD_FULL_NAME" -> { instance: LocationDb => instance.methodFullName},
 "METHOD_SHORT_NAME" -> { instance: LocationDb => instance.methodShortName},
 "PACKAGE_NAME" -> { instance: LocationDb => instance.packageName},
 "LINE_NUMBER" -> { instance: LocationDb => instance.lineNumber.orNull},
 "CLASS_NAME" -> { instance: LocationDb => instance.className},
 "CLASS_SHORT_NAME" -> { instance: LocationDb => instance.classShortName},
 "NODE_LABEL" -> { instance: LocationDb => instance.nodeLabel},
 "FILENAME" -> { instance: LocationDb => instance.filename}
    )
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[LocationDb] {
    override val forLabel = Location.Label
    override val forLabelId = Location.LabelId

    override def createNode(ref: NodeRef[LocationDb]) =
      new LocationDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Location(graph, id)
  }
}

trait LocationBase extends CpgNode  with HasSymbol with HasMethodFullName with HasMethodShortName with HasPackageName with HasLineNumber with HasClassName with HasClassShortName with HasNodeLabel with HasFilename {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def node: Option[CpgNode]
}

class Location(graph: OdbGraph, id: Long) extends NodeRef[LocationDb](graph, id)
  with LocationBase
  with StoredNode
   {
    override def symbol = get().symbol
  override def methodFullName = get().methodFullName
  override def methodShortName = get().methodShortName
  override def packageName = get().packageName
  override def lineNumber = get().lineNumber
  override def className = get().className
  override def classShortName = get().classShortName
  override def nodeLabel = get().nodeLabel
  override def filename = get().filename
    def node = get().node
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Location.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "symbol" 
case 2 => "methodFullName" 
case 3 => "methodShortName" 
case 4 => "packageName" 
case 5 => "lineNumber" 
case 6 => "className" 
case 7 => "classShortName" 
case 8 => "nodeLabel" 
case 9 => "filename" 
case 10 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => symbol
case 2 => methodFullName
case 3 => methodShortName
case 4 => packageName
case 5 => lineNumber
case 6 => className
case 7 => classShortName
case 8 => nodeLabel
case 9 => filename
case 10 => node
    }

  override def productPrefix = "Location"
  override def productArity = 11
}

class LocationDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with LocationBase {

  override def layoutInformation: NodeLayoutInformation = Location.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (symbol != null) { properties.put("SYMBOL", symbol) }
if (methodFullName != null) { properties.put("METHOD_FULL_NAME", methodFullName) }
if (methodShortName != null) { properties.put("METHOD_SHORT_NAME", methodShortName) }
if (packageName != null) { properties.put("PACKAGE_NAME", packageName) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
if (className != null) { properties.put("CLASS_NAME", className) }
if (classShortName != null) { properties.put("CLASS_SHORT_NAME", classShortName) }
if (nodeLabel != null) { properties.put("NODE_LABEL", nodeLabel) }
if (filename != null) { properties.put("FILENAME", filename) }
  properties
}

  private var _symbol: String = null
def symbol(): String = _symbol

private var _methodFullName: String = null
def methodFullName(): String = _methodFullName

private var _methodShortName: String = null
def methodShortName(): String = _methodShortName

private var _packageName: String = null
def packageName(): String = _packageName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _className: String = null
def className(): String = _className

private var _classShortName: String = null
def classShortName(): String = _classShortName

private var _nodeLabel: String = null
def nodeLabel(): String = _nodeLabel

private var _filename: String = null
def filename(): String = _filename
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Location.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "symbol" 
case 2 => "methodFullName" 
case 3 => "methodShortName" 
case 4 => "packageName" 
case 5 => "lineNumber" 
case 6 => "className" 
case 7 => "classShortName" 
case 8 => "nodeLabel" 
case 9 => "filename" 
case 10 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => symbol
case 2 => methodFullName
case 3 => methodShortName
case 4 => packageName
case 5 => lineNumber
case 6 => className
case 7 => classShortName
case 8 => nodeLabel
case 9 => filename
case 10 => node
    }

  override def productPrefix = "Location"
  override def productArity = 11

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[LocationDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Location.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Location.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "SYMBOL") this._symbol = value.asInstanceOf[String] 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = value.asInstanceOf[String] 
 else  if (key == "METHOD_SHORT_NAME") this._methodShortName = value.asInstanceOf[String] 
 else  if (key == "PACKAGE_NAME") this._packageName = value.asInstanceOf[String] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "CLASS_NAME") this._className = value.asInstanceOf[String] 
 else  if (key == "CLASS_SHORT_NAME") this._classShortName = value.asInstanceOf[String] 
 else  if (key == "NODE_LABEL") this._nodeLabel = value.asInstanceOf[String] 
 else  if (key == "FILENAME") this._filename = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "SYMBOL") this._symbol = null 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = null 
 else  if (key == "METHOD_SHORT_NAME") this._methodShortName = null 
 else  if (key == "PACKAGE_NAME") this._packageName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = None 
 else  if (key == "CLASS_NAME") this._className = null 
 else  if (key == "CLASS_SHORT_NAME") this._classShortName = null 
 else  if (key == "NODE_LABEL") this._nodeLabel = null 
 else  if (key == "FILENAME") this._filename = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type CpgNode */
def node: Option[CpgNode] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "node").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[CpgNode])
    .headOption

}

