package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object MatchInfo {
  def apply(graph: OdbGraph, id: Long) = new MatchInfo(graph, id)

  val Label = "MATCH_INFO"
  val LabelId: Int = 51

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Pattern = "PATTERN" 
val Category = "CATEGORY" 
    val all: Set[String] = Set(Pattern, Category)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, MatchInfoDb => AnyRef] = Map(
       "PATTERN" -> { instance: MatchInfoDb => instance.pattern},
 "CATEGORY" -> { instance: MatchInfoDb => instance.category}
    )
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[MatchInfoDb] {
    override val forLabel = MatchInfo.Label
    override val forLabelId = MatchInfo.LabelId

    override def createNode(ref: NodeRef[MatchInfoDb]) =
      new MatchInfoDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = MatchInfo(graph, id)
  }
}

trait MatchInfoBase extends CpgNode  with HasPattern with HasCategory {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MatchInfo(graph: OdbGraph, id: Long) extends NodeRef[MatchInfoDb](graph, id)
  with MatchInfoBase
  with StoredNode
   {
    override def pattern = get().pattern
  override def category = get().category
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveDataTypeViaContainsNodeIn: Iterator[SensitiveDataType] = get()._sensitiveDataTypeViaContainsNodeIn
def _sensitiveMemberViaContainsNodeIn: Iterator[SensitiveMember] = get()._sensitiveMemberViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MatchInfo.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "pattern" 
case 2 => "category" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => pattern
case 2 => category
    }

  override def productPrefix = "MatchInfo"
  override def productArity = 3
}

class MatchInfoDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with MatchInfoBase {

  override def layoutInformation: NodeLayoutInformation = MatchInfo.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (pattern != null) { properties.put("PATTERN", pattern) }
if (category != null) { properties.put("CATEGORY", category) }
  properties
}

  private var _pattern: String = null
def pattern(): String = _pattern

private var _category: String = null
def category(): String = _category
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _sensitiveDataTypeViaContainsNodeIn: Iterator[SensitiveDataType] = _containsNodeIn.asScala.collect { case node: SensitiveDataType => node }
def _sensitiveMemberViaContainsNodeIn: Iterator[SensitiveMember] = _containsNodeIn.asScala.collect { case node: SensitiveMember => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MatchInfo.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "pattern" 
case 2 => "category" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => pattern
case 2 => category
    }

  override def productPrefix = "MatchInfo"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MatchInfoDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    MatchInfo.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    MatchInfo.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "PATTERN") this._pattern = value.asInstanceOf[String] 
 else  if (key == "CATEGORY") this._category = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "PATTERN") this._pattern = null 
 else  if (key == "CATEGORY") this._category = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

