package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Member {
  def apply(graph: OdbGraph, id: Long) = new Member(graph, id)

  val Label = "MEMBER"
  val LabelId: Int = 9

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.TaggedBy.layoutInformation, edges.DynamicType.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation, edges.EvalType.layoutInformation).asJava,
    List(edges.Ref.layoutInformation, edges.Ast.layoutInformation, edges.IsSensitiveDataDescrOf.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Code = "CODE" 
val Name = "NAME" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val Order = "ORDER" 
    val all: Set[String] = Set(Code, Name, TypeFullName, DynamicTypeHintFullName, Order)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, MemberDb => AnyRef] = Map(
       "CODE" -> { instance: MemberDb => instance.code},
 "NAME" -> { instance: MemberDb => instance.name},
 "TYPE_FULL_NAME" -> { instance: MemberDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: MemberDb => instance.dynamicTypeHintFullName},
 "ORDER" -> { instance: MemberDb => instance.order}
    )
  }

  object Edges {
    val In: Array[String] = Array("REF","AST","IS_SENSITIVE_DATA_DESCR_OF","CONTAINS_NODE")
    val Out: Array[String] = Array("TAGGED_BY","DYNAMIC_TYPE","AST","CONTAINS_NODE","EVAL_TYPE")
  }

  val factory = new NodeFactory[MemberDb] {
    override val forLabel = Member.Label
    override val forLabelId = Member.LabelId

    override def createNode(ref: NodeRef[MemberDb]) =
      new MemberDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Member(graph, id)
  }
}

trait MemberBase extends CpgNode with DeclarationBase with AstNodeBase with HasCode with HasName with HasTypeFullName with HasDynamicTypeHintFullName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Member(graph: OdbGraph, id: Long) extends NodeRef[MemberDb](graph, id)
  with MemberBase
  with StoredNode
  with Declaration with AstNode {
    override def code = get().code
  override def name = get().name
  override def typeFullName = get().typeFullName
  override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
  override def order = get().order
  
  def _tagViaTaggedByOut: Iterator[Tag] = get()._tagViaTaggedByOut
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = get()._typeDeclViaDynamicTypeOut
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut
def _annotationViaAstOut: Iterator[Annotation] = get()._annotationViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _typeViaEvalTypeOut: Iterator[Type] = get()._typeViaEvalTypeOut
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut
def _callViaRefIn: Iterator[Call] = get()._callViaRefIn
override def _refIn(): JIterator[StoredNode] = get()._refIn
def _unknownViaAstIn: Iterator[Unknown] = get()._unknownViaAstIn
def _typeDeclViaAstIn: TypeDecl = get()._typeDeclViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _sensitiveMemberViaIsSensitiveDataDescrOfIn: Iterator[SensitiveMember] = get()._sensitiveMemberViaIsSensitiveDataDescrOfIn
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Member.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "typeFullName" 
case 4 => "dynamicTypeHintFullName" 
case 5 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => name
case 3 => typeFullName
case 4 => dynamicTypeHintFullName
case 5 => order
    }

  override def productPrefix = "Member"
  override def productArity = 6
}

class MemberDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with Declaration with AstNode with MemberBase {

  override def layoutInformation: NodeLayoutInformation = Member.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

  private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _order: Integer = null
def order(): Integer = _order
  def _tagViaTaggedByOut: Iterator[Tag] = _taggedByOut.asScala.collect { case node: Tag => node }
override def _taggedByOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = _dynamicTypeOut.asScala.collect { case node: TypeDecl => node }
override def _dynamicTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _annotationViaAstOut: Iterator[Annotation] = _astOut.asScala.collect { case node: Annotation => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _typeViaEvalTypeOut: Iterator[Type] = _evalTypeOut.asScala.collect { case node: Type => node }
override def _evalTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _callViaRefIn: Iterator[Call] = _refIn.asScala.collect { case node: Call => node }
override def _refIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _unknownViaAstIn: Iterator[Unknown] = _astIn.asScala.collect { case node: Unknown => node }
def _typeDeclViaAstIn: TypeDecl = _astIn.asScala.collect { case node: TypeDecl => node }.next
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _sensitiveMemberViaIsSensitiveDataDescrOfIn: Iterator[SensitiveMember] = _isSensitiveDataDescrOfIn.asScala.collect { case node: SensitiveMember => node }
override def _isSensitiveDataDescrOfIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Member.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "typeFullName" 
case 4 => "dynamicTypeHintFullName" 
case 5 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => name
case 3 => typeFullName
case 4 => dynamicTypeHintFullName
case 5 => order
    }

  override def productPrefix = "Member"
  override def productArity = 6

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MemberDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Member.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Member.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
  if( value.isInstanceOf[List[_]]) { 
    this._dynamicTypeHintFullName = value.asInstanceOf[List[String]] 
  } else if (cardinality == VertexProperty.Cardinality.list) {
    if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
    this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
  } else {
    this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
  }
}

 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "CODE") this._code = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = Nil 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

