package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object MetaData {
  def apply(graph: OdbGraph, id: Long) = new MetaData(graph, id)

  val Label = "META_DATA"
  val LabelId: Int = 39

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val Language = "LANGUAGE" 
val Version = "VERSION" 
val Overlays = "OVERLAYS" 
val PolicyDirectories = "POLICY_DIRECTORIES" 
val Spid = "SPID" 
    val all: Set[String] = Set(Language, Version, Overlays, PolicyDirectories, Spid)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, MetaDataDb => AnyRef] = Map(
       "LANGUAGE" -> { instance: MetaDataDb => instance.language},
 "VERSION" -> { instance: MetaDataDb => instance.version},
 "OVERLAYS" -> { instance: MetaDataDb => instance.overlays},
 "POLICY_DIRECTORIES" -> { instance: MetaDataDb => instance.policyDirectories},
 "SPID" -> { instance: MetaDataDb => instance.spid.orNull}
    )
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[MetaDataDb] {
    override val forLabel = MetaData.Label
    override val forLabelId = MetaData.LabelId

    override def createNode(ref: NodeRef[MetaDataDb]) =
      new MetaDataDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = MetaData(graph, id)
  }
}

trait MetaDataBase extends CpgNode  with HasLanguage with HasVersion with HasOverlays with HasPolicyDirectories with HasSpid {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MetaData(graph: OdbGraph, id: Long) extends NodeRef[MetaDataDb](graph, id)
  with MetaDataBase
  with StoredNode
   {
    override def language = get().language
  override def version = get().version
  override def overlays = get().overlays
  override def policyDirectories = get().policyDirectories
  override def spid = get().spid
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MetaData.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "language" 
case 2 => "version" 
case 3 => "overlays" 
case 4 => "policyDirectories" 
case 5 => "spid" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => language
case 2 => version
case 3 => overlays
case 4 => policyDirectories
case 5 => spid
    }

  override def productPrefix = "MetaData"
  override def productArity = 6
}

class MetaDataDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with MetaDataBase {

  override def layoutInformation: NodeLayoutInformation = MetaData.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (language != null) { properties.put("LANGUAGE", language) }
if (version != null) { properties.put("VERSION", version) }
if (overlays.nonEmpty) { properties.put("OVERLAYS", overlays.asJava) }
if (policyDirectories.nonEmpty) { properties.put("POLICY_DIRECTORIES", policyDirectories.asJava) }
spid.map { value => properties.put("SPID", value) }
  properties
}

  private var _language: String = null
def language(): String = _language

private var _version: String = null
def version(): String = _version

private var _overlays: List[String] = Nil
def overlays(): List[String] = _overlays

private var _policyDirectories: List[String] = Nil
def policyDirectories(): List[String] = _policyDirectories

private var _spid: Option[String] = None
def spid(): Option[String] = _spid
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MetaData.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "language" 
case 2 => "version" 
case 3 => "overlays" 
case 4 => "policyDirectories" 
case 5 => "spid" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => language
case 2 => version
case 3 => overlays
case 4 => policyDirectories
case 5 => spid
    }

  override def productPrefix = "MetaData"
  override def productArity = 6

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MetaDataDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    MetaData.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    MetaData.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "LANGUAGE") this._language = value.asInstanceOf[String] 
 else  if (key == "VERSION") this._version = value.asInstanceOf[String] 
 else if (key == "OVERLAYS") {
  if( value.isInstanceOf[List[_]]) { 
    this._overlays = value.asInstanceOf[List[String]] 
  } else if (cardinality == VertexProperty.Cardinality.list) {
    if (this._overlays == null) { this._overlays = Nil }
    this._overlays = this._overlays :+ value.asInstanceOf[String]
  } else {
    this._overlays = List(value.asInstanceOf[String])
  }
}

 else if (key == "POLICY_DIRECTORIES") {
  if( value.isInstanceOf[List[_]]) { 
    this._policyDirectories = value.asInstanceOf[List[String]] 
  } else if (cardinality == VertexProperty.Cardinality.list) {
    if (this._policyDirectories == null) { this._policyDirectories = Nil }
    this._policyDirectories = this._policyDirectories :+ value.asInstanceOf[String]
  } else {
    this._policyDirectories = List(value.asInstanceOf[String])
  }
}

 else  if (key == "SPID") this._spid = Option(value).asInstanceOf[Option[String]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "LANGUAGE") this._language = null 
 else  if (key == "VERSION") this._version = null 
 else  if (key == "OVERLAYS") this._overlays = Nil 
 else  if (key == "POLICY_DIRECTORIES") this._policyDirectories = Nil 
 else  if (key == "SPID") this._spid = None 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

