package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object MethodParameterIn {
  def apply(graph: OdbGraph, id: Long) = new MethodParameterIn(graph, id)

  val Label = "METHOD_PARAMETER_IN"
  val LabelId: Int = 34

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.TaggedBy.layoutInformation, edges.ReachingDef.layoutInformation, edges.DynamicType.layoutInformation, edges.Ast.layoutInformation, edges.TaintRemove.layoutInformation, edges.ContainsNode.layoutInformation, edges.Propagate.layoutInformation, edges.ParameterLink.layoutInformation, edges.EvalType.layoutInformation).asJava,
    List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.Ref.layoutInformation, edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Code = "CODE" 
val Order = "ORDER" 
val Name = "NAME" 
val EvaluationStrategy = "EVALUATION_STRATEGY" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
    val all: Set[String] = Set(Code, Order, Name, EvaluationStrategy, TypeFullName, DynamicTypeHintFullName, LineNumber, ColumnNumber)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, MethodParameterInDb => AnyRef] = Map(
       "CODE" -> { instance: MethodParameterInDb => instance.code},
 "ORDER" -> { instance: MethodParameterInDb => instance.order},
 "NAME" -> { instance: MethodParameterInDb => instance.name},
 "EVALUATION_STRATEGY" -> { instance: MethodParameterInDb => instance.evaluationStrategy},
 "TYPE_FULL_NAME" -> { instance: MethodParameterInDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: MethodParameterInDb => instance.dynamicTypeHintFullName},
 "LINE_NUMBER" -> { instance: MethodParameterInDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: MethodParameterInDb => instance.columnNumber.orNull}
    )
  }

  object Edges {
    val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","REF","IS_SENSITIVE_DATA_DESCR_OF_REF","AST","CONTAINS_NODE")
    val Out: Array[String] = Array("TAGGED_BY","REACHING_DEF","DYNAMIC_TYPE","AST","TAINT_REMOVE","CONTAINS_NODE","PROPAGATE","PARAMETER_LINK","EVAL_TYPE")
  }

  val factory = new NodeFactory[MethodParameterInDb] {
    override val forLabel = MethodParameterIn.Label
    override val forLabelId = MethodParameterIn.LabelId

    override def createNode(ref: NodeRef[MethodParameterInDb]) =
      new MethodParameterInDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = MethodParameterIn(graph, id)
  }
}

trait MethodParameterInBase extends CpgNode with DeclarationBase with LocalLikeBase with TrackingPointBase with AstNodeBase with HasCode with HasOrder with HasName with HasEvaluationStrategy with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MethodParameterIn(graph: OdbGraph, id: Long) extends NodeRef[MethodParameterInDb](graph, id)
  with MethodParameterInBase
  with StoredNode
  with Declaration with LocalLike with TrackingPoint with AstNode {
    override def code = get().code
  override def order = get().order
  override def name = get().name
  override def evaluationStrategy = get().evaluationStrategy
  override def typeFullName = get().typeFullName
  override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
  override def lineNumber = get().lineNumber
  override def columnNumber = get().columnNumber
  
  def _tagViaTaggedByOut: Iterator[Tag] = get()._tagViaTaggedByOut
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut
def _callViaReachingDefOut: Iterator[Call] = get()._callViaReachingDefOut
def _returnViaReachingDefOut: Iterator[Return] = get()._returnViaReachingDefOut
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut
def _methodViaDynamicTypeOut: Iterator[Method] = get()._methodViaDynamicTypeOut
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = get()._typeDeclViaDynamicTypeOut
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut
def _annotationViaAstOut: Iterator[Annotation] = get()._annotationViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
def _methodParameterOutViaTaintRemoveOut: Iterator[MethodParameterOut] = get()._methodParameterOutViaTaintRemoveOut
override def _taintRemoveOut(): JIterator[StoredNode] = get()._taintRemoveOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodParameterOutViaPropagateOut: Iterator[MethodParameterOut] = get()._methodParameterOutViaPropagateOut
def _methodReturnViaPropagateOut: Iterator[MethodReturn] = get()._methodReturnViaPropagateOut
override def _propagateOut(): JIterator[StoredNode] = get()._propagateOut
def _methodParameterOutViaParameterLinkOut: Iterator[MethodParameterOut] = get()._methodParameterOutViaParameterLinkOut
override def _parameterLinkOut(): JIterator[StoredNode] = get()._parameterLinkOut
def _typeViaEvalTypeOut: Type = get()._typeViaEvalTypeOut
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut
def _sensitiveVariableViaIsSensitiveDataDescrOfIn: Iterator[SensitiveVariable] = get()._sensitiveVariableViaIsSensitiveDataDescrOfIn
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn
def _closureBindingViaRefIn: Iterator[ClosureBinding] = get()._closureBindingViaRefIn
def _identifierViaRefIn: Iterator[Identifier] = get()._identifierViaRefIn
override def _refIn(): JIterator[StoredNode] = get()._refIn
def _sensitiveReferenceViaIsSensitiveDataDescrOfRefIn: Iterator[SensitiveReference] = get()._sensitiveReferenceViaIsSensitiveDataDescrOfRefIn
override def _isSensitiveDataDescrOfRefIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefIn
def _methodViaAstIn: Method = get()._methodViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
def _sinkViaContainsNodeIn: Iterator[Sink] = get()._sinkViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodParameterIn.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
case 3 => "name" 
case 4 => "evaluationStrategy" 
case 5 => "typeFullName" 
case 6 => "dynamicTypeHintFullName" 
case 7 => "lineNumber" 
case 8 => "columnNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => order
case 3 => name
case 4 => evaluationStrategy
case 5 => typeFullName
case 6 => dynamicTypeHintFullName
case 7 => lineNumber
case 8 => columnNumber
    }

  override def productPrefix = "MethodParameterIn"
  override def productArity = 9
}

class MethodParameterInDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with Declaration with LocalLike with TrackingPoint with AstNode with MethodParameterInBase {

  override def layoutInformation: NodeLayoutInformation = MethodParameterIn.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (name != null) { properties.put("NAME", name) }
if (evaluationStrategy != null) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
  properties
}

  private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _name: String = null
def name(): String = _name

private var _evaluationStrategy: String = null
def evaluationStrategy(): String = _evaluationStrategy

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber
  def _tagViaTaggedByOut: Iterator[Tag] = _taggedByOut.asScala.collect { case node: Tag => node }
override def _taggedByOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _callViaReachingDefOut: Iterator[Call] = _reachingDefOut.asScala.collect { case node: Call => node }
def _returnViaReachingDefOut: Iterator[Return] = _reachingDefOut.asScala.collect { case node: Return => node }
override def _reachingDefOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodViaDynamicTypeOut: Iterator[Method] = _dynamicTypeOut.asScala.collect { case node: Method => node }
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = _dynamicTypeOut.asScala.collect { case node: TypeDecl => node }
override def _dynamicTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _annotationViaAstOut: Iterator[Annotation] = _astOut.asScala.collect { case node: Annotation => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _methodParameterOutViaTaintRemoveOut: Iterator[MethodParameterOut] = _taintRemoveOut.asScala.collect { case node: MethodParameterOut => node }
override def _taintRemoveOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _methodParameterOutViaPropagateOut: Iterator[MethodParameterOut] = _propagateOut.asScala.collect { case node: MethodParameterOut => node }
def _methodReturnViaPropagateOut: Iterator[MethodReturn] = _propagateOut.asScala.collect { case node: MethodReturn => node }
override def _propagateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _methodParameterOutViaParameterLinkOut: Iterator[MethodParameterOut] = _parameterLinkOut.asScala.collect { case node: MethodParameterOut => node }
override def _parameterLinkOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
def _typeViaEvalTypeOut: Type = _evalTypeOut.asScala.collect { case node: Type => node }.next
override def _evalTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
def _sensitiveVariableViaIsSensitiveDataDescrOfIn: Iterator[SensitiveVariable] = _isSensitiveDataDescrOfIn.asScala.collect { case node: SensitiveVariable => node }
override def _isSensitiveDataDescrOfIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
def _closureBindingViaRefIn: Iterator[ClosureBinding] = _refIn.asScala.collect { case node: ClosureBinding => node }
def _identifierViaRefIn: Iterator[Identifier] = _refIn.asScala.collect { case node: Identifier => node }
override def _refIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
def _sensitiveReferenceViaIsSensitiveDataDescrOfRefIn: Iterator[SensitiveReference] = _isSensitiveDataDescrOfRefIn.asScala.collect { case node: SensitiveReference => node }
override def _isSensitiveDataDescrOfRefIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstIn: Method = _astIn.asScala.collect { case node: Method => node }.next
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }
def _sinkViaContainsNodeIn: Iterator[Sink] = _containsNodeIn.asScala.collect { case node: Sink => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MethodParameterIn.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
case 3 => "name" 
case 4 => "evaluationStrategy" 
case 5 => "typeFullName" 
case 6 => "dynamicTypeHintFullName" 
case 7 => "lineNumber" 
case 8 => "columnNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => order
case 3 => name
case 4 => evaluationStrategy
case 5 => typeFullName
case 6 => dynamicTypeHintFullName
case 7 => lineNumber
case 8 => columnNumber
    }

  override def productPrefix = "MethodParameterIn"
  override def productArity = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodParameterInDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    MethodParameterIn.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    MethodParameterIn.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = value.asInstanceOf[String] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
  if( value.isInstanceOf[List[_]]) { 
    this._dynamicTypeHintFullName = value.asInstanceOf[List[String]] 
  } else if (cardinality == VertexProperty.Cardinality.list) {
    if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
    this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
  } else {
    this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
  }
}

 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "CODE") this._code = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = Nil 
 else  if (key == "LINE_NUMBER") this._lineNumber = None 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = None 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

