package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object MethodParameterOut {
  def apply(graph: OdbGraph, id: Long) = new MethodParameterOut(graph, id)

  val Label = "METHOD_PARAMETER_OUT"
  val LabelId: Int = 33

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.EvalType.layoutInformation, edges.TaggedBy.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.TaintRemove.layoutInformation, edges.ContainsNode.layoutInformation, edges.Propagate.layoutInformation, edges.ParameterLink.layoutInformation).asJava)

  object PropertyNames {
    val Code = "CODE" 
val Order = "ORDER" 
val Name = "NAME" 
val EvaluationStrategy = "EVALUATION_STRATEGY" 
val TypeFullName = "TYPE_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
    val all: Set[String] = Set(Code, Order, Name, EvaluationStrategy, TypeFullName, LineNumber, ColumnNumber)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, MethodParameterOutDb => AnyRef] = Map(
       "CODE" -> { instance: MethodParameterOutDb => instance.code},
 "ORDER" -> { instance: MethodParameterOutDb => instance.order},
 "NAME" -> { instance: MethodParameterOutDb => instance.name},
 "EVALUATION_STRATEGY" -> { instance: MethodParameterOutDb => instance.evaluationStrategy},
 "TYPE_FULL_NAME" -> { instance: MethodParameterOutDb => instance.typeFullName},
 "LINE_NUMBER" -> { instance: MethodParameterOutDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: MethodParameterOutDb => instance.columnNumber.orNull}
    )
  }

  object Edges {
    val In: Array[String] = Array("AST","TAINT_REMOVE","CONTAINS_NODE","PROPAGATE","PARAMETER_LINK")
    val Out: Array[String] = Array("EVAL_TYPE","TAGGED_BY","CONTAINS_NODE")
  }

  val factory = new NodeFactory[MethodParameterOutDb] {
    override val forLabel = MethodParameterOut.Label
    override val forLabelId = MethodParameterOut.LabelId

    override def createNode(ref: NodeRef[MethodParameterOutDb]) =
      new MethodParameterOutDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = MethodParameterOut(graph, id)
  }
}

trait MethodParameterOutBase extends CpgNode with DeclarationBase with TrackingPointBase with AstNodeBase with HasCode with HasOrder with HasName with HasEvaluationStrategy with HasTypeFullName with HasLineNumber with HasColumnNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MethodParameterOut(graph: OdbGraph, id: Long) extends NodeRef[MethodParameterOutDb](graph, id)
  with MethodParameterOutBase
  with StoredNode
  with Declaration with TrackingPoint with AstNode {
    override def code = get().code
  override def order = get().order
  override def name = get().name
  override def evaluationStrategy = get().evaluationStrategy
  override def typeFullName = get().typeFullName
  override def lineNumber = get().lineNumber
  override def columnNumber = get().columnNumber
  
  def _typeViaEvalTypeOut: Iterator[Type] = get()._typeViaEvalTypeOut
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut
def _tagViaTaggedByOut: Iterator[Tag] = get()._tagViaTaggedByOut
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodViaAstIn: Iterator[Method] = get()._methodViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _methodParameterInViaTaintRemoveIn: Iterator[MethodParameterIn] = get()._methodParameterInViaTaintRemoveIn
override def _taintRemoveIn(): JIterator[StoredNode] = get()._taintRemoveIn
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _methodParameterInViaPropagateIn: Iterator[MethodParameterIn] = get()._methodParameterInViaPropagateIn
override def _propagateIn(): JIterator[StoredNode] = get()._propagateIn
def _methodParameterInViaParameterLinkIn: Iterator[MethodParameterIn] = get()._methodParameterInViaParameterLinkIn
override def _parameterLinkIn(): JIterator[StoredNode] = get()._parameterLinkIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodParameterOut.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
case 3 => "name" 
case 4 => "evaluationStrategy" 
case 5 => "typeFullName" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => order
case 3 => name
case 4 => evaluationStrategy
case 5 => typeFullName
case 6 => lineNumber
case 7 => columnNumber
    }

  override def productPrefix = "MethodParameterOut"
  override def productArity = 8
}

class MethodParameterOutDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with Declaration with TrackingPoint with AstNode with MethodParameterOutBase {

  override def layoutInformation: NodeLayoutInformation = MethodParameterOut.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (name != null) { properties.put("NAME", name) }
if (evaluationStrategy != null) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
  properties
}

  private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _name: String = null
def name(): String = _name

private var _evaluationStrategy: String = null
def evaluationStrategy(): String = _evaluationStrategy

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber
  def _typeViaEvalTypeOut: Iterator[Type] = _evalTypeOut.asScala.collect { case node: Type => node }
override def _evalTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _tagViaTaggedByOut: Iterator[Tag] = _taggedByOut.asScala.collect { case node: Tag => node }
override def _taggedByOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstIn: Iterator[Method] = _astIn.asScala.collect { case node: Method => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _methodParameterInViaTaintRemoveIn: Iterator[MethodParameterIn] = _taintRemoveIn.asScala.collect { case node: MethodParameterIn => node }
override def _taintRemoveIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _methodParameterInViaPropagateIn: Iterator[MethodParameterIn] = _propagateIn.asScala.collect { case node: MethodParameterIn => node }
override def _propagateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _methodParameterInViaParameterLinkIn: Iterator[MethodParameterIn] = _parameterLinkIn.asScala.collect { case node: MethodParameterIn => node }
override def _parameterLinkIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MethodParameterOut.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
case 3 => "name" 
case 4 => "evaluationStrategy" 
case 5 => "typeFullName" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => order
case 3 => name
case 4 => evaluationStrategy
case 5 => typeFullName
case 6 => lineNumber
case 7 => columnNumber
    }

  override def productPrefix = "MethodParameterOut"
  override def productArity = 8

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodParameterOutDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    MethodParameterOut.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    MethodParameterOut.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = value.asInstanceOf[String] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "CODE") this._code = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "NAME") this._name = null 
 else  if (key == "EVALUATION_STRATEGY") this._evaluationStrategy = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = None 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = None 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

