package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object MethodRef {
  def apply(graph: OdbGraph, id: Long) = new MethodRef(graph, id)

  val Label = "METHOD_REF"
  val LabelId: Int = 333

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Capture.layoutInformation, edges.Cdg.layoutInformation, edges.Ref.layoutInformation, edges.DynamicType.layoutInformation, edges.Cfg.layoutInformation, edges.PostDominate.layoutInformation, edges.Dominate.layoutInformation, edges.ContainsNode.layoutInformation, edges.EvalType.layoutInformation).asJava,
    List(edges.Receiver.layoutInformation, edges.Cdg.layoutInformation, edges.Argument.layoutInformation, edges.Contains.layoutInformation, edges.Condition.layoutInformation, edges.Cfg.layoutInformation, edges.PostDominate.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Code = "CODE" 
val Order = "ORDER" 
val ArgumentIndex = "ARGUMENT_INDEX" 
val TypeFullName = "TYPE_FULL_NAME" 
val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
val MethodInstFullName = "METHOD_INST_FULL_NAME" 
val MethodFullName = "METHOD_FULL_NAME" 
val LineNumber = "LINE_NUMBER" 
val ColumnNumber = "COLUMN_NUMBER" 
val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
val InternalFlags = "INTERNAL_FLAGS" 
    val all: Set[String] = Set(Code, Order, ArgumentIndex, TypeFullName, DynamicTypeHintFullName, MethodInstFullName, MethodFullName, LineNumber, ColumnNumber, DepthFirstOrder, InternalFlags)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, MethodRefDb => AnyRef] = Map(
       "CODE" -> { instance: MethodRefDb => instance.code},
 "ORDER" -> { instance: MethodRefDb => instance.order},
 "ARGUMENT_INDEX" -> { instance: MethodRefDb => instance.argumentIndex},
 "TYPE_FULL_NAME" -> { instance: MethodRefDb => instance.typeFullName},
 "DYNAMIC_TYPE_HINT_FULL_NAME" -> { instance: MethodRefDb => instance.dynamicTypeHintFullName},
 "METHOD_INST_FULL_NAME" -> { instance: MethodRefDb => instance.methodInstFullName.orNull},
 "METHOD_FULL_NAME" -> { instance: MethodRefDb => instance.methodFullName},
 "LINE_NUMBER" -> { instance: MethodRefDb => instance.lineNumber.orNull},
 "COLUMN_NUMBER" -> { instance: MethodRefDb => instance.columnNumber.orNull},
 "DEPTH_FIRST_ORDER" -> { instance: MethodRefDb => instance.depthFirstOrder.orNull},
 "INTERNAL_FLAGS" -> { instance: MethodRefDb => instance.internalFlags.orNull}
    )
  }

  object Edges {
    val In: Array[String] = Array("RECEIVER","CDG","ARGUMENT","CONTAINS","CONDITION","CFG","POST_DOMINATE","AST","DOMINATE","CONTAINS_NODE")
    val Out: Array[String] = Array("CAPTURE","CDG","REF","DYNAMIC_TYPE","CFG","POST_DOMINATE","DOMINATE","CONTAINS_NODE","EVAL_TYPE")
  }

  val factory = new NodeFactory[MethodRefDb] {
    override val forLabel = MethodRef.Label
    override val forLabelId = MethodRef.LabelId

    override def createNode(ref: NodeRef[MethodRefDb]) =
      new MethodRefDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = MethodRef(graph, id)
  }
}

trait MethodRefBase extends CpgNode with ExpressionBase with HasCode with HasOrder with HasArgumentIndex with HasTypeFullName with HasDynamicTypeHintFullName with HasMethodInstFullName with HasMethodFullName with HasLineNumber with HasColumnNumber with HasDepthFirstOrder with HasInternalFlags {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MethodRef(graph: OdbGraph, id: Long) extends NodeRef[MethodRefDb](graph, id)
  with MethodRefBase
  with StoredNode
  with Expression {
    override def code = get().code
  override def order = get().order
  override def argumentIndex = get().argumentIndex
  override def typeFullName = get().typeFullName
  override def dynamicTypeHintFullName = get().dynamicTypeHintFullName
  override def methodInstFullName = get().methodInstFullName
  override def methodFullName = get().methodFullName
  override def lineNumber = get().lineNumber
  override def columnNumber = get().columnNumber
  override def depthFirstOrder = get().depthFirstOrder
  override def internalFlags = get().internalFlags
  
  def _closureBindingViaCaptureOut: Iterator[ClosureBinding] = get()._closureBindingViaCaptureOut
override def _captureOut(): JIterator[StoredNode] = get()._captureOut
def _identifierViaCdgOut: Iterator[Identifier] = get()._identifierViaCdgOut
def _literalViaCdgOut: Iterator[Literal] = get()._literalViaCdgOut
def _blockViaCdgOut: Iterator[Block] = get()._blockViaCdgOut
def _methodReturnViaCdgOut: Iterator[MethodReturn] = get()._methodReturnViaCdgOut
def _fieldIdentifierViaCdgOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCdgOut
def _callViaCdgOut: Iterator[Call] = get()._callViaCdgOut
def _unknownViaCdgOut: Iterator[Unknown] = get()._unknownViaCdgOut
def _methodRefViaCdgOut: Iterator[MethodRef] = get()._methodRefViaCdgOut
def _returnViaCdgOut: Iterator[Return] = get()._returnViaCdgOut
def _controlStructureViaCdgOut: Iterator[ControlStructure] = get()._controlStructureViaCdgOut
override def _cdgOut(): JIterator[StoredNode] = get()._cdgOut
def _jumpTargetViaCdgOut: Iterator[JumpTarget] = get()._jumpTargetViaCdgOut
def _methodViaRefOut: Method = get()._methodViaRefOut
override def _refOut(): JIterator[StoredNode] = get()._refOut
def _methodViaDynamicTypeOut: Iterator[Method] = get()._methodViaDynamicTypeOut
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = get()._typeDeclViaDynamicTypeOut
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut
def _returnViaCfgOut: Iterator[Return] = get()._returnViaCfgOut
def _callViaCfgOut: Iterator[Call] = get()._callViaCfgOut
override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut
def _unknownViaCfgOut: Iterator[Unknown] = get()._unknownViaCfgOut
def _literalViaCfgOut: Iterator[Literal] = get()._literalViaCfgOut
def _fieldIdentifierViaCfgOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCfgOut
def _blockViaCfgOut: Iterator[Block] = get()._blockViaCfgOut
def _jumpTargetViaCfgOut: Iterator[JumpTarget] = get()._jumpTargetViaCfgOut
def _identifierViaCfgOut: Iterator[Identifier] = get()._identifierViaCfgOut
def _controlStructureViaCfgOut: Iterator[ControlStructure] = get()._controlStructureViaCfgOut
def _methodRefViaCfgOut: Iterator[MethodRef] = get()._methodRefViaCfgOut
def _methodReturnViaCfgOut: Iterator[MethodReturn] = get()._methodReturnViaCfgOut
def _identifierViaPostDominateOut: Iterator[Identifier] = get()._identifierViaPostDominateOut
def _literalViaPostDominateOut: Iterator[Literal] = get()._literalViaPostDominateOut
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut
def _jumpTargetViaPostDominateOut: Iterator[JumpTarget] = get()._jumpTargetViaPostDominateOut
def _callViaPostDominateOut: Iterator[Call] = get()._callViaPostDominateOut
def _fieldIdentifierViaPostDominateOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaPostDominateOut
def _controlStructureViaPostDominateOut: Iterator[ControlStructure] = get()._controlStructureViaPostDominateOut
def _returnViaPostDominateOut: Iterator[Return] = get()._returnViaPostDominateOut
def _methodViaPostDominateOut: Iterator[Method] = get()._methodViaPostDominateOut
def _unknownViaPostDominateOut: Iterator[Unknown] = get()._unknownViaPostDominateOut
def _methodRefViaPostDominateOut: Iterator[MethodRef] = get()._methodRefViaPostDominateOut
def _blockViaPostDominateOut: Iterator[Block] = get()._blockViaPostDominateOut
def _unknownViaDominateOut: Iterator[Unknown] = get()._unknownViaDominateOut
def _jumpTargetViaDominateOut: Iterator[JumpTarget] = get()._jumpTargetViaDominateOut
def _identifierViaDominateOut: Iterator[Identifier] = get()._identifierViaDominateOut
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut
def _controlStructureViaDominateOut: Iterator[ControlStructure] = get()._controlStructureViaDominateOut
def _fieldIdentifierViaDominateOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDominateOut
def _methodRefViaDominateOut: Iterator[MethodRef] = get()._methodRefViaDominateOut
def _methodReturnViaDominateOut: Iterator[MethodReturn] = get()._methodReturnViaDominateOut
def _literalViaDominateOut: Iterator[Literal] = get()._literalViaDominateOut
def _returnViaDominateOut: Iterator[Return] = get()._returnViaDominateOut
def _blockViaDominateOut: Iterator[Block] = get()._blockViaDominateOut
def _callViaDominateOut: Iterator[Call] = get()._callViaDominateOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _typeViaEvalTypeOut: Iterator[Type] = get()._typeViaEvalTypeOut
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut
def _callViaReceiverIn: Option[Call] = get()._callViaReceiverIn
override def _receiverIn(): JIterator[StoredNode] = get()._receiverIn
def _methodRefViaCdgIn: Iterator[MethodRef] = get()._methodRefViaCdgIn
def _callViaCdgIn: Iterator[Call] = get()._callViaCdgIn
def _unknownViaCdgIn: Iterator[Unknown] = get()._unknownViaCdgIn
def _controlStructureViaCdgIn: Iterator[ControlStructure] = get()._controlStructureViaCdgIn
def _literalViaCdgIn: Iterator[Literal] = get()._literalViaCdgIn
def _identifierViaCdgIn: Iterator[Identifier] = get()._identifierViaCdgIn
def _fieldIdentifierViaCdgIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCdgIn
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn
def _blockViaCdgIn: Iterator[Block] = get()._blockViaCdgIn
def _returnViaArgumentIn: Option[Return] = get()._returnViaArgumentIn
def _callViaArgumentIn: Option[Call] = get()._callViaArgumentIn
override def _argumentIn(): JIterator[StoredNode] = get()._argumentIn
def _methodViaContainsIn: Iterator[Method] = get()._methodViaContainsIn
override def _containsIn(): JIterator[StoredNode] = get()._containsIn
def _controlStructureViaConditionIn: Iterator[ControlStructure] = get()._controlStructureViaConditionIn
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn
def _callViaCfgIn: Iterator[Call] = get()._callViaCfgIn
def _methodViaCfgIn: Iterator[Method] = get()._methodViaCfgIn
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn
def _methodRefViaCfgIn: Iterator[MethodRef] = get()._methodRefViaCfgIn
def _unknownViaCfgIn: Iterator[Unknown] = get()._unknownViaCfgIn
def _jumpTargetViaCfgIn: Iterator[JumpTarget] = get()._jumpTargetViaCfgIn
def _blockViaCfgIn: Iterator[Block] = get()._blockViaCfgIn
def _controlStructureViaCfgIn: Iterator[ControlStructure] = get()._controlStructureViaCfgIn
def _identifierViaCfgIn: Iterator[Identifier] = get()._identifierViaCfgIn
def _fieldIdentifierViaCfgIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCfgIn
def _literalViaCfgIn: Iterator[Literal] = get()._literalViaCfgIn
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn
def _fieldIdentifierViaPostDominateIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaPostDominateIn
def _identifierViaPostDominateIn: Iterator[Identifier] = get()._identifierViaPostDominateIn
def _blockViaPostDominateIn: Iterator[Block] = get()._blockViaPostDominateIn
def _returnViaPostDominateIn: Iterator[Return] = get()._returnViaPostDominateIn
def _callViaPostDominateIn: Iterator[Call] = get()._callViaPostDominateIn
def _literalViaPostDominateIn: Iterator[Literal] = get()._literalViaPostDominateIn
def _unknownViaPostDominateIn: Iterator[Unknown] = get()._unknownViaPostDominateIn
def _methodReturnViaPostDominateIn: Iterator[MethodReturn] = get()._methodReturnViaPostDominateIn
def _controlStructureViaPostDominateIn: Iterator[ControlStructure] = get()._controlStructureViaPostDominateIn
def _methodRefViaPostDominateIn: Iterator[MethodRef] = get()._methodRefViaPostDominateIn
def _blockViaAstIn: Iterator[Block] = get()._blockViaAstIn
def _controlStructureViaAstIn: ControlStructure = get()._controlStructureViaAstIn
def _returnViaAstIn: Iterator[Return] = get()._returnViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _callViaAstIn: Iterator[Call] = get()._callViaAstIn
def _literalViaDominateIn: Iterator[Literal] = get()._literalViaDominateIn
def _fieldIdentifierViaDominateIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDominateIn
def _blockViaDominateIn: Iterator[Block] = get()._blockViaDominateIn
def _identifierViaDominateIn: Iterator[Identifier] = get()._identifierViaDominateIn
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn
def _controlStructureViaDominateIn: Iterator[ControlStructure] = get()._controlStructureViaDominateIn
def _methodRefViaDominateIn: Iterator[MethodRef] = get()._methodRefViaDominateIn
def _unknownViaDominateIn: Iterator[Unknown] = get()._unknownViaDominateIn
def _callViaDominateIn: Iterator[Call] = get()._callViaDominateIn
def _methodViaDominateIn: Iterator[Method] = get()._methodViaDominateIn
def _returnViaDominateIn: Iterator[Return] = get()._returnViaDominateIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodRef.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
case 3 => "argumentIndex" 
case 4 => "typeFullName" 
case 5 => "dynamicTypeHintFullName" 
case 6 => "methodInstFullName" 
case 7 => "methodFullName" 
case 8 => "lineNumber" 
case 9 => "columnNumber" 
case 10 => "depthFirstOrder" 
case 11 => "internalFlags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => order
case 3 => argumentIndex
case 4 => typeFullName
case 5 => dynamicTypeHintFullName
case 6 => methodInstFullName
case 7 => methodFullName
case 8 => lineNumber
case 9 => columnNumber
case 10 => depthFirstOrder
case 11 => internalFlags
    }

  override def productPrefix = "MethodRef"
  override def productArity = 12
}

class MethodRefDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with Expression with MethodRefBase {

  override def layoutInformation: NodeLayoutInformation = MethodRef.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
methodInstFullName.map { value => properties.put("METHOD_INST_FULL_NAME", value) }
if (methodFullName != null) { properties.put("METHOD_FULL_NAME", methodFullName) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }
  properties
}

  private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _methodInstFullName: Option[String] = None
def methodInstFullName(): Option[String] = _methodInstFullName

private var _methodFullName: String = null
def methodFullName(): String = _methodFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags
  def _closureBindingViaCaptureOut: Iterator[ClosureBinding] = _captureOut.asScala.collect { case node: ClosureBinding => node }
override def _captureOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _callViaCdgOut: Iterator[Call] = _cdgOut.asScala.collect { case node: Call => node }
def _blockViaCdgOut: Iterator[Block] = _cdgOut.asScala.collect { case node: Block => node }
def _fieldIdentifierViaCdgOut: Iterator[FieldIdentifier] = _cdgOut.asScala.collect { case node: FieldIdentifier => node }
def _controlStructureViaCdgOut: Iterator[ControlStructure] = _cdgOut.asScala.collect { case node: ControlStructure => node }
def _identifierViaCdgOut: Iterator[Identifier] = _cdgOut.asScala.collect { case node: Identifier => node }
def _literalViaCdgOut: Iterator[Literal] = _cdgOut.asScala.collect { case node: Literal => node }
def _returnViaCdgOut: Iterator[Return] = _cdgOut.asScala.collect { case node: Return => node }
def _methodReturnViaCdgOut: Iterator[MethodReturn] = _cdgOut.asScala.collect { case node: MethodReturn => node }
def _methodRefViaCdgOut: Iterator[MethodRef] = _cdgOut.asScala.collect { case node: MethodRef => node }
override def _cdgOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _jumpTargetViaCdgOut: Iterator[JumpTarget] = _cdgOut.asScala.collect { case node: JumpTarget => node }
def _unknownViaCdgOut: Iterator[Unknown] = _cdgOut.asScala.collect { case node: Unknown => node }
def _methodViaRefOut: Method = _refOut.asScala.collect { case node: Method => node }.next
override def _refOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _methodViaDynamicTypeOut: Iterator[Method] = _dynamicTypeOut.asScala.collect { case node: Method => node }
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = _dynamicTypeOut.asScala.collect { case node: TypeDecl => node }
override def _dynamicTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _literalViaCfgOut: Iterator[Literal] = _cfgOut.asScala.collect { case node: Literal => node }
def _unknownViaCfgOut: Iterator[Unknown] = _cfgOut.asScala.collect { case node: Unknown => node }
def _identifierViaCfgOut: Iterator[Identifier] = _cfgOut.asScala.collect { case node: Identifier => node }
def _methodRefViaCfgOut: Iterator[MethodRef] = _cfgOut.asScala.collect { case node: MethodRef => node }
def _jumpTargetViaCfgOut: Iterator[JumpTarget] = _cfgOut.asScala.collect { case node: JumpTarget => node }
def _methodReturnViaCfgOut: Iterator[MethodReturn] = _cfgOut.asScala.collect { case node: MethodReturn => node }
def _fieldIdentifierViaCfgOut: Iterator[FieldIdentifier] = _cfgOut.asScala.collect { case node: FieldIdentifier => node }
def _returnViaCfgOut: Iterator[Return] = _cfgOut.asScala.collect { case node: Return => node }
def _blockViaCfgOut: Iterator[Block] = _cfgOut.asScala.collect { case node: Block => node }
def _controlStructureViaCfgOut: Iterator[ControlStructure] = _cfgOut.asScala.collect { case node: ControlStructure => node }
override def _cfgOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _callViaCfgOut: Iterator[Call] = _cfgOut.asScala.collect { case node: Call => node }
def _jumpTargetViaPostDominateOut: Iterator[JumpTarget] = _postDominateOut.asScala.collect { case node: JumpTarget => node }
def _identifierViaPostDominateOut: Iterator[Identifier] = _postDominateOut.asScala.collect { case node: Identifier => node }
def _callViaPostDominateOut: Iterator[Call] = _postDominateOut.asScala.collect { case node: Call => node }
def _methodRefViaPostDominateOut: Iterator[MethodRef] = _postDominateOut.asScala.collect { case node: MethodRef => node }
override def _postDominateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _controlStructureViaPostDominateOut: Iterator[ControlStructure] = _postDominateOut.asScala.collect { case node: ControlStructure => node }
def _returnViaPostDominateOut: Iterator[Return] = _postDominateOut.asScala.collect { case node: Return => node }
def _literalViaPostDominateOut: Iterator[Literal] = _postDominateOut.asScala.collect { case node: Literal => node }
def _unknownViaPostDominateOut: Iterator[Unknown] = _postDominateOut.asScala.collect { case node: Unknown => node }
def _fieldIdentifierViaPostDominateOut: Iterator[FieldIdentifier] = _postDominateOut.asScala.collect { case node: FieldIdentifier => node }
def _methodViaPostDominateOut: Iterator[Method] = _postDominateOut.asScala.collect { case node: Method => node }
def _blockViaPostDominateOut: Iterator[Block] = _postDominateOut.asScala.collect { case node: Block => node }
def _literalViaDominateOut: Iterator[Literal] = _dominateOut.asScala.collect { case node: Literal => node }
def _methodReturnViaDominateOut: Iterator[MethodReturn] = _dominateOut.asScala.collect { case node: MethodReturn => node }
def _unknownViaDominateOut: Iterator[Unknown] = _dominateOut.asScala.collect { case node: Unknown => node }
def _controlStructureViaDominateOut: Iterator[ControlStructure] = _dominateOut.asScala.collect { case node: ControlStructure => node }
def _jumpTargetViaDominateOut: Iterator[JumpTarget] = _dominateOut.asScala.collect { case node: JumpTarget => node }
def _methodRefViaDominateOut: Iterator[MethodRef] = _dominateOut.asScala.collect { case node: MethodRef => node }
override def _dominateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _returnViaDominateOut: Iterator[Return] = _dominateOut.asScala.collect { case node: Return => node }
def _fieldIdentifierViaDominateOut: Iterator[FieldIdentifier] = _dominateOut.asScala.collect { case node: FieldIdentifier => node }
def _identifierViaDominateOut: Iterator[Identifier] = _dominateOut.asScala.collect { case node: Identifier => node }
def _callViaDominateOut: Iterator[Call] = _dominateOut.asScala.collect { case node: Call => node }
def _blockViaDominateOut: Iterator[Block] = _dominateOut.asScala.collect { case node: Block => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
def _typeViaEvalTypeOut: Iterator[Type] = _evalTypeOut.asScala.collect { case node: Type => node }
override def _evalTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
def _callViaReceiverIn: Option[Call] = _receiverIn.asScala.collect { case node: Call => node }.nextOption
override def _receiverIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
def _identifierViaCdgIn: Iterator[Identifier] = _cdgIn.asScala.collect { case node: Identifier => node }
def _literalViaCdgIn: Iterator[Literal] = _cdgIn.asScala.collect { case node: Literal => node }
override def _cdgIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
def _callViaCdgIn: Iterator[Call] = _cdgIn.asScala.collect { case node: Call => node }
def _controlStructureViaCdgIn: Iterator[ControlStructure] = _cdgIn.asScala.collect { case node: ControlStructure => node }
def _blockViaCdgIn: Iterator[Block] = _cdgIn.asScala.collect { case node: Block => node }
def _unknownViaCdgIn: Iterator[Unknown] = _cdgIn.asScala.collect { case node: Unknown => node }
def _methodRefViaCdgIn: Iterator[MethodRef] = _cdgIn.asScala.collect { case node: MethodRef => node }
def _fieldIdentifierViaCdgIn: Iterator[FieldIdentifier] = _cdgIn.asScala.collect { case node: FieldIdentifier => node }
def _returnViaArgumentIn: Option[Return] = _argumentIn.asScala.collect { case node: Return => node }.nextOption
def _callViaArgumentIn: Option[Call] = _argumentIn.asScala.collect { case node: Call => node }.nextOption
override def _argumentIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
def _methodViaContainsIn: Iterator[Method] = _containsIn.asScala.collect { case node: Method => node }
override def _containsIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
def _controlStructureViaConditionIn: Iterator[ControlStructure] = _conditionIn.asScala.collect { case node: ControlStructure => node }
override def _conditionIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
def _methodViaCfgIn: Iterator[Method] = _cfgIn.asScala.collect { case node: Method => node }
def _controlStructureViaCfgIn: Iterator[ControlStructure] = _cfgIn.asScala.collect { case node: ControlStructure => node }
def _fieldIdentifierViaCfgIn: Iterator[FieldIdentifier] = _cfgIn.asScala.collect { case node: FieldIdentifier => node }
def _callViaCfgIn: Iterator[Call] = _cfgIn.asScala.collect { case node: Call => node }
def _unknownViaCfgIn: Iterator[Unknown] = _cfgIn.asScala.collect { case node: Unknown => node }
def _methodRefViaCfgIn: Iterator[MethodRef] = _cfgIn.asScala.collect { case node: MethodRef => node }
def _literalViaCfgIn: Iterator[Literal] = _cfgIn.asScala.collect { case node: Literal => node }
def _jumpTargetViaCfgIn: Iterator[JumpTarget] = _cfgIn.asScala.collect { case node: JumpTarget => node }
def _identifierViaCfgIn: Iterator[Identifier] = _cfgIn.asScala.collect { case node: Identifier => node }
override def _cfgIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
def _blockViaCfgIn: Iterator[Block] = _cfgIn.asScala.collect { case node: Block => node }
def _blockViaPostDominateIn: Iterator[Block] = _postDominateIn.asScala.collect { case node: Block => node }
def _controlStructureViaPostDominateIn: Iterator[ControlStructure] = _postDominateIn.asScala.collect { case node: ControlStructure => node }
override def _postDominateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]
def _callViaPostDominateIn: Iterator[Call] = _postDominateIn.asScala.collect { case node: Call => node }
def _unknownViaPostDominateIn: Iterator[Unknown] = _postDominateIn.asScala.collect { case node: Unknown => node }
def _fieldIdentifierViaPostDominateIn: Iterator[FieldIdentifier] = _postDominateIn.asScala.collect { case node: FieldIdentifier => node }
def _identifierViaPostDominateIn: Iterator[Identifier] = _postDominateIn.asScala.collect { case node: Identifier => node }
def _literalViaPostDominateIn: Iterator[Literal] = _postDominateIn.asScala.collect { case node: Literal => node }
def _returnViaPostDominateIn: Iterator[Return] = _postDominateIn.asScala.collect { case node: Return => node }
def _methodRefViaPostDominateIn: Iterator[MethodRef] = _postDominateIn.asScala.collect { case node: MethodRef => node }
def _methodReturnViaPostDominateIn: Iterator[MethodReturn] = _postDominateIn.asScala.collect { case node: MethodReturn => node }
def _returnViaAstIn: Iterator[Return] = _astIn.asScala.collect { case node: Return => node }
def _blockViaAstIn: Iterator[Block] = _astIn.asScala.collect { case node: Block => node }
def _callViaAstIn: Iterator[Call] = _astIn.asScala.collect { case node: Call => node }
def _controlStructureViaAstIn: ControlStructure = _astIn.asScala.collect { case node: ControlStructure => node }.next
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(16).asInstanceOf[JIterator[StoredNode]]
def _unknownViaDominateIn: Iterator[Unknown] = _dominateIn.asScala.collect { case node: Unknown => node }
def _methodRefViaDominateIn: Iterator[MethodRef] = _dominateIn.asScala.collect { case node: MethodRef => node }
def _fieldIdentifierViaDominateIn: Iterator[FieldIdentifier] = _dominateIn.asScala.collect { case node: FieldIdentifier => node }
def _methodViaDominateIn: Iterator[Method] = _dominateIn.asScala.collect { case node: Method => node }
override def _dominateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(17).asInstanceOf[JIterator[StoredNode]]
def _returnViaDominateIn: Iterator[Return] = _dominateIn.asScala.collect { case node: Return => node }
def _identifierViaDominateIn: Iterator[Identifier] = _dominateIn.asScala.collect { case node: Identifier => node }
def _blockViaDominateIn: Iterator[Block] = _dominateIn.asScala.collect { case node: Block => node }
def _callViaDominateIn: Iterator[Call] = _dominateIn.asScala.collect { case node: Call => node }
def _controlStructureViaDominateIn: Iterator[ControlStructure] = _dominateIn.asScala.collect { case node: ControlStructure => node }
def _literalViaDominateIn: Iterator[Literal] = _dominateIn.asScala.collect { case node: Literal => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(18).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MethodRef.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
case 3 => "argumentIndex" 
case 4 => "typeFullName" 
case 5 => "dynamicTypeHintFullName" 
case 6 => "methodInstFullName" 
case 7 => "methodFullName" 
case 8 => "lineNumber" 
case 9 => "columnNumber" 
case 10 => "depthFirstOrder" 
case 11 => "internalFlags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => order
case 3 => argumentIndex
case 4 => typeFullName
case 5 => dynamicTypeHintFullName
case 6 => methodInstFullName
case 7 => methodFullName
case 8 => lineNumber
case 9 => columnNumber
case 10 => depthFirstOrder
case 11 => internalFlags
    }

  override def productPrefix = "MethodRef"
  override def productArity = 12

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodRefDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    MethodRef.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    MethodRef.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "CODE") this._code = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = value.asInstanceOf[Integer] 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = value.asInstanceOf[String] 
 else if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") {
  if( value.isInstanceOf[List[_]]) { 
    this._dynamicTypeHintFullName = value.asInstanceOf[List[String]] 
  } else if (cardinality == VertexProperty.Cardinality.list) {
    if (this._dynamicTypeHintFullName == null) { this._dynamicTypeHintFullName = Nil }
    this._dynamicTypeHintFullName = this._dynamicTypeHintFullName :+ value.asInstanceOf[String]
  } else {
    this._dynamicTypeHintFullName = List(value.asInstanceOf[String])
  }
}

 else  if (key == "METHOD_INST_FULL_NAME") this._methodInstFullName = Option(value).asInstanceOf[Option[String]] 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = value.asInstanceOf[String] 
 else  if (key == "LINE_NUMBER") this._lineNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = Option(value).asInstanceOf[Option[Integer]] 
 else  if (key == "INTERNAL_FLAGS") this._internalFlags = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "CODE") this._code = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "ARGUMENT_INDEX") this._argumentIndex = null 
 else  if (key == "TYPE_FULL_NAME") this._typeFullName = null 
 else  if (key == "DYNAMIC_TYPE_HINT_FULL_NAME") this._dynamicTypeHintFullName = Nil 
 else  if (key == "METHOD_INST_FULL_NAME") this._methodInstFullName = None 
 else  if (key == "METHOD_FULL_NAME") this._methodFullName = null 
 else  if (key == "LINE_NUMBER") this._lineNumber = None 
 else  if (key == "COLUMN_NUMBER") this._columnNumber = None 
 else  if (key == "DEPTH_FIRST_ORDER") this._depthFirstOrder = None 
 else  if (key == "INTERNAL_FLAGS") this._internalFlags = None 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

