package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object MethodSummary {
  def apply(graph: OdbGraph, id: Long) = new MethodSummary(graph, id)

  val Label = "METHOD_SUMMARY"
  val LabelId: Int = 199

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val IsStatic = "IS_STATIC" 
val IsExternal = "IS_EXTERNAL" 
val BinarySignature = "BINARY_SIGNATURE" 
    val all: Set[String] = Set(IsStatic, IsExternal, BinarySignature)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, MethodSummaryDb => AnyRef] = Map(
       "IS_STATIC" -> { instance: MethodSummaryDb => instance.isStatic},
 "IS_EXTERNAL" -> { instance: MethodSummaryDb => instance.isExternal},
 "BINARY_SIGNATURE" -> { instance: MethodSummaryDb => instance.binarySignature.orNull}
    )
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[MethodSummaryDb] {
    override val forLabel = MethodSummary.Label
    override val forLabelId = MethodSummary.LabelId

    override def createNode(ref: NodeRef[MethodSummaryDb]) =
      new MethodSummaryDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = MethodSummary(graph, id)
  }
}

trait MethodSummaryBase extends CpgNode  with HasIsStatic with HasIsExternal with HasBinarySignature {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def method: MethodBase
def parameters: List[MethodParameterInBase]
def outParameters: List[MethodParameterOutBase]
def returnParameter: MethodReturnBase
def paramTypes: List[TypeBase]
def returnParameterType: TypeBase
def tags: List[TagBase]
def paramTags: List[TagsBase]
def outParamTags: List[TagsBase]
def returnParamTags: List[TagBase]
def annotationParameters: List[SpAnnotationParameterBase]
def modifiers: List[ModifierBase]
def routes: List[RouteBase]
}

class MethodSummary(graph: OdbGraph, id: Long) extends NodeRef[MethodSummaryDb](graph, id)
  with MethodSummaryBase
  with StoredNode
   {
    override def isStatic = get().isStatic
  override def isExternal = get().isExternal
  override def binarySignature = get().binarySignature
    def method = get().method
  def parameters = get().parameters
  def outParameters = get().outParameters
  def returnParameter = get().returnParameter
  def paramTypes = get().paramTypes
  def returnParameterType = get().returnParameterType
  def tags = get().tags
  def paramTags = get().paramTags
  def outParamTags = get().outParamTags
  def returnParamTags = get().returnParamTags
  def annotationParameters = get().annotationParameters
  def modifiers = get().modifiers
  def routes = get().routes
  def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
def _methodReturnViaContainsNodeOut: Iterator[MethodReturn] = get()._methodReturnViaContainsNodeOut
def _methodParameterInViaContainsNodeOut: Iterator[MethodParameterIn] = get()._methodParameterInViaContainsNodeOut
def _routeViaContainsNodeOut: Iterator[Route] = get()._routeViaContainsNodeOut
def _tagsViaContainsNodeOut: Iterator[Tags] = get()._tagsViaContainsNodeOut
def _spAnnotationParameterViaContainsNodeOut: Iterator[SpAnnotationParameter] = get()._spAnnotationParameterViaContainsNodeOut
def _methodViaContainsNodeOut: Iterator[Method] = get()._methodViaContainsNodeOut
def _typeViaContainsNodeOut: Iterator[Type] = get()._typeViaContainsNodeOut
def _modifierViaContainsNodeOut: Iterator[Modifier] = get()._modifierViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodParameterOutViaContainsNodeOut: Iterator[MethodParameterOut] = get()._methodParameterOutViaContainsNodeOut
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodSummary.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "isStatic" 
case 2 => "isExternal" 
case 3 => "binarySignature" 
case 4 => "method" 
case 5 => "parameters" 
case 6 => "outParameters" 
case 7 => "returnParameter" 
case 8 => "paramTypes" 
case 9 => "returnParameterType" 
case 10 => "tags" 
case 11 => "paramTags" 
case 12 => "outParamTags" 
case 13 => "returnParamTags" 
case 14 => "annotationParameters" 
case 15 => "modifiers" 
case 16 => "routes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => isStatic
case 2 => isExternal
case 3 => binarySignature
case 4 => method
case 5 => parameters
case 6 => outParameters
case 7 => returnParameter
case 8 => paramTypes
case 9 => returnParameterType
case 10 => tags
case 11 => paramTags
case 12 => outParamTags
case 13 => returnParamTags
case 14 => annotationParameters
case 15 => modifiers
case 16 => routes
    }

  override def productPrefix = "MethodSummary"
  override def productArity = 17
}

class MethodSummaryDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with MethodSummaryBase {

  override def layoutInformation: NodeLayoutInformation = MethodSummary.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (isStatic != null) { properties.put("IS_STATIC", isStatic) }
if (isExternal != null) { properties.put("IS_EXTERNAL", isExternal) }
binarySignature.map { value => properties.put("BINARY_SIGNATURE", value) }
  properties
}

  private var _isStatic: JBoolean = null
def isStatic(): JBoolean = _isStatic

private var _isExternal: JBoolean = null
def isExternal(): JBoolean = _isExternal

private var _binarySignature: Option[String] = None
def binarySignature(): Option[String] = _binarySignature
  def _methodViaContainsNodeOut: Iterator[Method] = _containsNodeOut.asScala.collect { case node: Method => node }
def _typeViaContainsNodeOut: Iterator[Type] = _containsNodeOut.asScala.collect { case node: Type => node }
def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
def _modifierViaContainsNodeOut: Iterator[Modifier] = _containsNodeOut.asScala.collect { case node: Modifier => node }
def _spAnnotationParameterViaContainsNodeOut: Iterator[SpAnnotationParameter] = _containsNodeOut.asScala.collect { case node: SpAnnotationParameter => node }
def _methodParameterInViaContainsNodeOut: Iterator[MethodParameterIn] = _containsNodeOut.asScala.collect { case node: MethodParameterIn => node }
def _methodParameterOutViaContainsNodeOut: Iterator[MethodParameterOut] = _containsNodeOut.asScala.collect { case node: MethodParameterOut => node }
def _routeViaContainsNodeOut: Iterator[Route] = _containsNodeOut.asScala.collect { case node: Route => node }
def _methodReturnViaContainsNodeOut: Iterator[MethodReturn] = _containsNodeOut.asScala.collect { case node: MethodReturn => node }
def _tagsViaContainsNodeOut: Iterator[Tags] = _containsNodeOut.asScala.collect { case node: Tags => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MethodSummary.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "isStatic" 
case 2 => "isExternal" 
case 3 => "binarySignature" 
case 4 => "method" 
case 5 => "parameters" 
case 6 => "outParameters" 
case 7 => "returnParameter" 
case 8 => "paramTypes" 
case 9 => "returnParameterType" 
case 10 => "tags" 
case 11 => "paramTags" 
case 12 => "outParamTags" 
case 13 => "returnParamTags" 
case 14 => "annotationParameters" 
case 15 => "modifiers" 
case 16 => "routes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => isStatic
case 2 => isExternal
case 3 => binarySignature
case 4 => method
case 5 => parameters
case 6 => outParameters
case 7 => returnParameter
case 8 => paramTypes
case 9 => returnParameterType
case 10 => tags
case 11 => paramTags
case 12 => outParamTags
case 13 => returnParamTags
case 14 => annotationParameters
case 15 => modifiers
case 16 => routes
    }

  override def productPrefix = "MethodSummary"
  override def productArity = 17

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodSummaryDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    MethodSummary.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    MethodSummary.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "IS_STATIC") this._isStatic = value.asInstanceOf[JBoolean] 
 else  if (key == "IS_EXTERNAL") this._isExternal = value.asInstanceOf[JBoolean] 
 else  if (key == "BINARY_SIGNATURE") this._binarySignature = Option(value).asInstanceOf[Option[String]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "IS_STATIC") this._isStatic = null 
 else  if (key == "IS_EXTERNAL") this._isExternal = null 
 else  if (key == "BINARY_SIGNATURE") this._binarySignature = None 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type Method */
def method: Method =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "method").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Method])
    .head

/** link to 'contained' node of type MethodParameterIn */
def parameters: List[MethodParameterIn] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "parameters").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[MethodParameterIn])
    .toList

/** link to 'contained' node of type MethodParameterOut */
def outParameters: List[MethodParameterOut] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "outParameters").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[MethodParameterOut])
    .toList

/** link to 'contained' node of type MethodReturn */
def returnParameter: MethodReturn =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "returnParameter").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[MethodReturn])
    .head

/** link to 'contained' node of type Type */
def paramTypes: List[Type] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "paramTypes").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Type])
    .toList

/** link to 'contained' node of type Type */
def returnParameterType: Type =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "returnParameterType").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Type])
    .head

/** link to 'contained' node of type Tag */
def tags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "tags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

/** link to 'contained' node of type Tags */
def paramTags: List[Tags] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "paramTags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tags])
    .toList

/** link to 'contained' node of type Tags */
def outParamTags: List[Tags] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "outParamTags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tags])
    .toList

/** link to 'contained' node of type Tag */
def returnParamTags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "returnParamTags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

/** link to 'contained' node of type SpAnnotationParameter */
def annotationParameters: List[SpAnnotationParameter] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "annotationParameters").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[SpAnnotationParameter])
    .toList

/** link to 'contained' node of type Modifier */
def modifiers: List[Modifier] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "modifiers").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Modifier])
    .toList

/** link to 'contained' node of type Route */
def routes: List[Route] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "routes").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Route])
    .toList

}

