package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object NamespaceBlock {
  def apply(graph: OdbGraph, id: Long) = new NamespaceBlock(graph, id)

  val Label = "NAMESPACE_BLOCK"
  val LabelId: Int = 41

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.SourceFile.layoutInformation, edges.Ref.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Name = "NAME" 
val FullName = "FULL_NAME" 
val Order = "ORDER" 
val Filename = "FILENAME" 
    val all: Set[String] = Set(Name, FullName, Order, Filename)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, NamespaceBlockDb => AnyRef] = Map(
       "NAME" -> { instance: NamespaceBlockDb => instance.name},
 "FULL_NAME" -> { instance: NamespaceBlockDb => instance.fullName},
 "ORDER" -> { instance: NamespaceBlockDb => instance.order},
 "FILENAME" -> { instance: NamespaceBlockDb => instance.filename}
    )
  }

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("SOURCE_FILE","REF","AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[NamespaceBlockDb] {
    override val forLabel = NamespaceBlock.Label
    override val forLabelId = NamespaceBlock.LabelId

    override def createNode(ref: NodeRef[NamespaceBlockDb]) =
      new NamespaceBlockDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = NamespaceBlock(graph, id)
  }
}

trait NamespaceBlockBase extends CpgNode with AstNodeBase with HasName with HasFullName with HasOrder with HasFilename {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class NamespaceBlock(graph: OdbGraph, id: Long) extends NodeRef[NamespaceBlockDb](graph, id)
  with NamespaceBlockBase
  with StoredNode
  with AstNode {
    override def name = get().name
  override def fullName = get().fullName
  override def order = get().order
  override def filename = get().filename
  
  def _fileViaSourceFileOut: Iterator[File] = get()._fileViaSourceFileOut
override def _sourceFileOut(): JIterator[StoredNode] = get()._sourceFileOut
def _namespaceViaRefOut: Iterator[Namespace] = get()._namespaceViaRefOut
override def _refOut(): JIterator[StoredNode] = get()._refOut
def _methodViaAstOut: Iterator[Method] = get()._methodViaAstOut
def _typeDeclViaAstOut: Iterator[TypeDecl] = get()._typeDeclViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _fileViaAstIn: Option[File] = get()._fileViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    NamespaceBlock.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "fullName" 
case 3 => "order" 
case 4 => "filename" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => fullName
case 3 => order
case 4 => filename
    }

  override def productPrefix = "NamespaceBlock"
  override def productArity = 5
}

class NamespaceBlockDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with AstNode with NamespaceBlockBase {

  override def layoutInformation: NodeLayoutInformation = NamespaceBlock.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (order != null) { properties.put("ORDER", order) }
if (filename != null) { properties.put("FILENAME", filename) }
  properties
}

  private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _order: Integer = null
def order(): Integer = _order

private var _filename: String = null
def filename(): String = _filename
  def _fileViaSourceFileOut: Iterator[File] = _sourceFileOut.asScala.collect { case node: File => node }
override def _sourceFileOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _namespaceViaRefOut: Iterator[Namespace] = _refOut.asScala.collect { case node: Namespace => node }
override def _refOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstOut: Iterator[Method] = _astOut.asScala.collect { case node: Method => node }
def _typeDeclViaAstOut: Iterator[TypeDecl] = _astOut.asScala.collect { case node: TypeDecl => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _fileViaAstIn: Option[File] = _astIn.asScala.collect { case node: File => node }.nextOption
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    NamespaceBlock.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "fullName" 
case 3 => "order" 
case 4 => "filename" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => fullName
case 3 => order
case 4 => filename
    }

  override def productPrefix = "NamespaceBlock"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[NamespaceBlockDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    NamespaceBlock.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    NamespaceBlock.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "FULL_NAME") this._fullName = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "FILENAME") this._filename = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "NAME") this._name = null 
 else  if (key == "FULL_NAME") this._fullName = null 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "FILENAME") this._filename = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

