package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object PackagePrefix {
  def apply(graph: OdbGraph, id: Long) = new PackagePrefix(graph, id)

  val Label = "PACKAGE_PREFIX"
  val LabelId: Int = 36

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val Value = "VALUE" 
    val all: Set[String] = Set(Value)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, PackagePrefixDb => AnyRef] = Map(
       "VALUE" -> { instance: PackagePrefixDb => instance.value}
    )
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[PackagePrefixDb] {
    override val forLabel = PackagePrefix.Label
    override val forLabelId = PackagePrefix.LabelId

    override def createNode(ref: NodeRef[PackagePrefixDb]) =
      new PackagePrefixDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = PackagePrefix(graph, id)
  }
}

trait PackagePrefixBase extends CpgNode  with HasValue {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class PackagePrefix(graph: OdbGraph, id: Long) extends NodeRef[PackagePrefixDb](graph, id)
  with PackagePrefixBase
  with StoredNode
   {
    override def value = get().value
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    PackagePrefix.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => value
    }

  override def productPrefix = "PackagePrefix"
  override def productArity = 2
}

class PackagePrefixDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with PackagePrefixBase {

  override def layoutInformation: NodeLayoutInformation = PackagePrefix.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (value != null) { properties.put("VALUE", value) }
  properties
}

  private var _value: String = null
def value(): String = _value
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    PackagePrefix.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => value
    }

  override def productPrefix = "PackagePrefix"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[PackagePrefixDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    PackagePrefix.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    PackagePrefix.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "VALUE") this._value = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "VALUE") this._value = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

