package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object SensitiveDataType {
  def apply(graph: OdbGraph, id: Long) = new SensitiveDataType(graph, id)

  val Label = "SENSITIVE_DATA_TYPE"
  val LabelId: Int = 52

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.IsSensitiveDataOfType.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val FullName = "FULL_NAME" 
    val all: Set[String] = Set(FullName)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, SensitiveDataTypeDb => AnyRef] = Map(
       "FULL_NAME" -> { instance: SensitiveDataTypeDb => instance.fullName}
    )
  }

  object Edges {
    val In: Array[String] = Array("IS_SENSITIVE_DATA_OF_TYPE","CONTAINS_NODE")
    val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[SensitiveDataTypeDb] {
    override val forLabel = SensitiveDataType.Label
    override val forLabelId = SensitiveDataType.LabelId

    override def createNode(ref: NodeRef[SensitiveDataTypeDb]) =
      new SensitiveDataTypeDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = SensitiveDataType(graph, id)
  }
}

trait SensitiveDataTypeBase extends CpgNode  with HasFullName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def names: List[MatchInfoBase]
def members: List[SensitiveMemberBase]
}

class SensitiveDataType(graph: OdbGraph, id: Long) extends NodeRef[SensitiveDataTypeDb](graph, id)
  with SensitiveDataTypeBase
  with StoredNode
   {
    override def fullName = get().fullName
    def names = get().names
  def members = get().members
  def _typeDeclViaIsSensitiveDataDescrOfOut: Iterator[TypeDecl] = get()._typeDeclViaIsSensitiveDataDescrOfOut
override def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfOut
def _matchInfoViaContainsNodeOut: Iterator[MatchInfo] = get()._matchInfoViaContainsNodeOut
def _sensitiveMemberViaContainsNodeOut: Iterator[SensitiveMember] = get()._sensitiveMemberViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveVariableViaIsSensitiveDataOfTypeIn: Iterator[SensitiveVariable] = get()._sensitiveVariableViaIsSensitiveDataOfTypeIn
override def _isSensitiveDataOfTypeIn(): JIterator[StoredNode] = get()._isSensitiveDataOfTypeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveDataType.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "fullName" 
case 2 => "names" 
case 3 => "members" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => fullName
case 2 => names
case 3 => members
    }

  override def productPrefix = "SensitiveDataType"
  override def productArity = 4
}

class SensitiveDataTypeDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SensitiveDataTypeBase {

  override def layoutInformation: NodeLayoutInformation = SensitiveDataType.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (fullName != null) { properties.put("FULL_NAME", fullName) }
  properties
}

  private var _fullName: String = null
def fullName(): String = _fullName
  def _typeDeclViaIsSensitiveDataDescrOfOut: Iterator[TypeDecl] = _isSensitiveDataDescrOfOut.asScala.collect { case node: TypeDecl => node }
override def _isSensitiveDataDescrOfOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _matchInfoViaContainsNodeOut: Iterator[MatchInfo] = _containsNodeOut.asScala.collect { case node: MatchInfo => node }
def _sensitiveMemberViaContainsNodeOut: Iterator[SensitiveMember] = _containsNodeOut.asScala.collect { case node: SensitiveMember => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _sensitiveVariableViaIsSensitiveDataOfTypeIn: Iterator[SensitiveVariable] = _isSensitiveDataOfTypeIn.asScala.collect { case node: SensitiveVariable => node }
override def _isSensitiveDataOfTypeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SensitiveDataType.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "fullName" 
case 2 => "names" 
case 3 => "members" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => fullName
case 2 => names
case 3 => members
    }

  override def productPrefix = "SensitiveDataType"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveDataTypeDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    SensitiveDataType.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    SensitiveDataType.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "FULL_NAME") this._fullName = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "FULL_NAME") this._fullName = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type MatchInfo */
def names: List[MatchInfo] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "names").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[MatchInfo])
    .toList

/** link to 'contained' node of type SensitiveMember */
def members: List[SensitiveMember] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "members").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[SensitiveMember])
    .toList

}

