package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object SensitiveMember {
  def apply(graph: OdbGraph, id: Long) = new SensitiveMember(graph, id)

  val Label = "SENSITIVE_MEMBER"
  val LabelId: Int = 53

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Name = "NAME" 
    val all: Set[String] = Set(Name)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, SensitiveMemberDb => AnyRef] = Map(
       "NAME" -> { instance: SensitiveMemberDb => instance.name}
    )
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[SensitiveMemberDb] {
    override val forLabel = SensitiveMember.Label
    override val forLabelId = SensitiveMember.LabelId

    override def createNode(ref: NodeRef[SensitiveMemberDb]) =
      new SensitiveMemberDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = SensitiveMember(graph, id)
  }
}

trait SensitiveMemberBase extends CpgNode  with HasName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def names: List[MatchInfoBase]
}

class SensitiveMember(graph: OdbGraph, id: Long) extends NodeRef[SensitiveMemberDb](graph, id)
  with SensitiveMemberBase
  with StoredNode
   {
    override def name = get().name
    def names = get().names
  def _memberViaIsSensitiveDataDescrOfOut: Iterator[Member] = get()._memberViaIsSensitiveDataDescrOfOut
def _typeViaIsSensitiveDataDescrOfOut: Iterator[Type] = get()._typeViaIsSensitiveDataDescrOfOut
override def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfOut
def _matchInfoViaContainsNodeOut: Iterator[MatchInfo] = get()._matchInfoViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveDataTypeViaContainsNodeIn: Iterator[SensitiveDataType] = get()._sensitiveDataTypeViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveMember.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "names" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => names
    }

  override def productPrefix = "SensitiveMember"
  override def productArity = 3
}

class SensitiveMemberDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SensitiveMemberBase {

  override def layoutInformation: NodeLayoutInformation = SensitiveMember.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
  properties
}

  private var _name: String = null
def name(): String = _name
  def _memberViaIsSensitiveDataDescrOfOut: Iterator[Member] = _isSensitiveDataDescrOfOut.asScala.collect { case node: Member => node }
def _typeViaIsSensitiveDataDescrOfOut: Iterator[Type] = _isSensitiveDataDescrOfOut.asScala.collect { case node: Type => node }
override def _isSensitiveDataDescrOfOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _matchInfoViaContainsNodeOut: Iterator[MatchInfo] = _containsNodeOut.asScala.collect { case node: MatchInfo => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _sensitiveDataTypeViaContainsNodeIn: Iterator[SensitiveDataType] = _containsNodeIn.asScala.collect { case node: SensitiveDataType => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SensitiveMember.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "names" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => names
    }

  override def productPrefix = "SensitiveMember"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveMemberDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    SensitiveMember.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    SensitiveMember.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "NAME") this._name = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "NAME") this._name = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type MatchInfo */
def names: List[MatchInfo] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "names").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[MatchInfo])
    .toList

}

