package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object SensitiveReference {
  def apply(graph: OdbGraph, id: Long) = new SensitiveReference(graph, id)

  val Label = "SENSITIVE_REFERENCE"
  val LabelId: Int = 55

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    
    val all: Set[String] = Set()
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, SensitiveReferenceDb => AnyRef] = Map(
      
    )
  }

  object Edges {
    val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF_REF","CONTAINS_NODE")
    val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF_REF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[SensitiveReferenceDb] {
    override val forLabel = SensitiveReference.Label
    override val forLabelId = SensitiveReference.LabelId

    override def createNode(ref: NodeRef[SensitiveReferenceDb]) =
      new SensitiveReferenceDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = SensitiveReference(graph, id)
  }
}

trait SensitiveReferenceBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def ioflows: List[IoflowBase]
}

class SensitiveReference(graph: OdbGraph, id: Long) extends NodeRef[SensitiveReferenceDb](graph, id)
  with SensitiveReferenceBase
  with StoredNode
   {
  
    def ioflows = get().ioflows
  def _localViaIsSensitiveDataDescrOfRefOut: Iterator[Local] = get()._localViaIsSensitiveDataDescrOfRefOut
def _identifierViaIsSensitiveDataDescrOfRefOut: Iterator[Identifier] = get()._identifierViaIsSensitiveDataDescrOfRefOut
def _methodParameterInViaIsSensitiveDataDescrOfRefOut: Iterator[MethodParameterIn] = get()._methodParameterInViaIsSensitiveDataDescrOfRefOut
override def _isSensitiveDataDescrOfRefOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefOut
def _ioflowViaContainsNodeOut: Iterator[Ioflow] = get()._ioflowViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveVariableViaIsSensitiveDataDescrOfRefIn: Iterator[SensitiveVariable] = get()._sensitiveVariableViaIsSensitiveDataDescrOfRefIn
override def _isSensitiveDataDescrOfRefIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveReference.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "ioflows" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => ioflows
    }

  override def productPrefix = "SensitiveReference"
  override def productArity = 2
}

class SensitiveReferenceDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SensitiveReferenceBase {

  override def layoutInformation: NodeLayoutInformation = SensitiveReference.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

  
  def _localViaIsSensitiveDataDescrOfRefOut: Iterator[Local] = _isSensitiveDataDescrOfRefOut.asScala.collect { case node: Local => node }
def _identifierViaIsSensitiveDataDescrOfRefOut: Iterator[Identifier] = _isSensitiveDataDescrOfRefOut.asScala.collect { case node: Identifier => node }
def _methodParameterInViaIsSensitiveDataDescrOfRefOut: Iterator[MethodParameterIn] = _isSensitiveDataDescrOfRefOut.asScala.collect { case node: MethodParameterIn => node }
override def _isSensitiveDataDescrOfRefOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeOut: Iterator[Ioflow] = _containsNodeOut.asScala.collect { case node: Ioflow => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _sensitiveVariableViaIsSensitiveDataDescrOfRefIn: Iterator[SensitiveVariable] = _isSensitiveDataDescrOfRefIn.asScala.collect { case node: SensitiveVariable => node }
override def _isSensitiveDataDescrOfRefIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SensitiveReference.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "ioflows" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => ioflows
    }

  override def productPrefix = "SensitiveReference"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveReferenceDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    SensitiveReference.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    SensitiveReference.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
    throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type Ioflow */
def ioflows: List[Ioflow] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "ioflows").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Ioflow])
    .toList

}

