package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object SensitiveVariable {
  def apply(graph: OdbGraph, id: Long) = new SensitiveVariable(graph, id)

  val Label = "SENSITIVE_VARIABLE"
  val LabelId: Int = 54

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.IsSensitiveDataDescrOf.layoutInformation, edges.IsSensitiveDataOfType.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val Name = "NAME" 
val EvalType = "EVAL_TYPE" 
val Categories = "CATEGORIES" 
    val all: Set[String] = Set(Name, EvalType, Categories)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, SensitiveVariableDb => AnyRef] = Map(
       "NAME" -> { instance: SensitiveVariableDb => instance.name},
 "EVAL_TYPE" -> { instance: SensitiveVariableDb => instance.evalType},
 "CATEGORIES" -> { instance: SensitiveVariableDb => instance.categories}
    )
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF_REF","IS_SENSITIVE_DATA_DESCR_OF","IS_SENSITIVE_DATA_OF_TYPE","CONTAINS_NODE")
  }

  val factory = new NodeFactory[SensitiveVariableDb] {
    override val forLabel = SensitiveVariable.Label
    override val forLabelId = SensitiveVariable.LabelId

    override def createNode(ref: NodeRef[SensitiveVariableDb]) =
      new SensitiveVariableDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = SensitiveVariable(graph, id)
  }
}

trait SensitiveVariableBase extends CpgNode  with HasName with HasEvalType with HasCategories {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def node: LocalLikeBase
}

class SensitiveVariable(graph: OdbGraph, id: Long) extends NodeRef[SensitiveVariableDb](graph, id)
  with SensitiveVariableBase
  with StoredNode
   {
    override def name = get().name
  override def evalType = get().evalType
  override def categories = get().categories
    def node = get().node
  def _sensitiveReferenceViaIsSensitiveDataDescrOfRefOut: Iterator[SensitiveReference] = get()._sensitiveReferenceViaIsSensitiveDataDescrOfRefOut
override def _isSensitiveDataDescrOfRefOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefOut
def _localViaIsSensitiveDataDescrOfOut: Iterator[Local] = get()._localViaIsSensitiveDataDescrOfOut
def _identifierViaIsSensitiveDataDescrOfOut: Iterator[Identifier] = get()._identifierViaIsSensitiveDataDescrOfOut
def _methodParameterInViaIsSensitiveDataDescrOfOut: Iterator[MethodParameterIn] = get()._methodParameterInViaIsSensitiveDataDescrOfOut
override def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfOut
def _sensitiveDataTypeViaIsSensitiveDataOfTypeOut: Iterator[SensitiveDataType] = get()._sensitiveDataTypeViaIsSensitiveDataOfTypeOut
override def _isSensitiveDataOfTypeOut(): JIterator[StoredNode] = get()._isSensitiveDataOfTypeOut
def _localLikeViaContainsNodeOut: Iterator[LocalLike] = get()._localLikeViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveVariable.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "evalType" 
case 3 => "categories" 
case 4 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => evalType
case 3 => categories
case 4 => node
    }

  override def productPrefix = "SensitiveVariable"
  override def productArity = 5
}

class SensitiveVariableDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SensitiveVariableBase {

  override def layoutInformation: NodeLayoutInformation = SensitiveVariable.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (evalType != null) { properties.put("EVAL_TYPE", evalType) }
if (categories.nonEmpty) { properties.put("CATEGORIES", categories.asJava) }
  properties
}

  private var _name: String = null
def name(): String = _name

private var _evalType: String = null
def evalType(): String = _evalType

private var _categories: List[String] = Nil
def categories(): List[String] = _categories
  def _sensitiveReferenceViaIsSensitiveDataDescrOfRefOut: Iterator[SensitiveReference] = _isSensitiveDataDescrOfRefOut.asScala.collect { case node: SensitiveReference => node }
override def _isSensitiveDataDescrOfRefOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _localViaIsSensitiveDataDescrOfOut: Iterator[Local] = _isSensitiveDataDescrOfOut.asScala.collect { case node: Local => node }
def _identifierViaIsSensitiveDataDescrOfOut: Iterator[Identifier] = _isSensitiveDataDescrOfOut.asScala.collect { case node: Identifier => node }
def _methodParameterInViaIsSensitiveDataDescrOfOut: Iterator[MethodParameterIn] = _isSensitiveDataDescrOfOut.asScala.collect { case node: MethodParameterIn => node }
override def _isSensitiveDataDescrOfOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _sensitiveDataTypeViaIsSensitiveDataOfTypeOut: Iterator[SensitiveDataType] = _isSensitiveDataOfTypeOut.asScala.collect { case node: SensitiveDataType => node }
override def _isSensitiveDataOfTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _localLikeViaContainsNodeOut: Iterator[LocalLike] = _containsNodeOut.asScala.collect { case node: LocalLike => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SensitiveVariable.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "evalType" 
case 3 => "categories" 
case 4 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => evalType
case 3 => categories
case 4 => node
    }

  override def productPrefix = "SensitiveVariable"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveVariableDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    SensitiveVariable.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    SensitiveVariable.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "EVAL_TYPE") this._evalType = value.asInstanceOf[String] 
 else if (key == "CATEGORIES") {
  if( value.isInstanceOf[List[_]]) { 
    this._categories = value.asInstanceOf[List[String]] 
  } else if (cardinality == VertexProperty.Cardinality.list) {
    if (this._categories == null) { this._categories = Nil }
    this._categories = this._categories :+ value.asInstanceOf[String]
  } else {
    this._categories = List(value.asInstanceOf[String])
  }
}

 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "NAME") this._name = null 
 else  if (key == "EVAL_TYPE") this._evalType = null 
 else  if (key == "CATEGORIES") this._categories = Nil 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type LocalLike */
def node: LocalLike =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "node").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[LocalLike])
    .head

}

