package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Sink {
  def apply(graph: OdbGraph, id: Long) = new Sink(graph, id)

  val Label = "SINK"
  val LabelId: Int = 203

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val SinkType = "SINK_TYPE" 
    val all: Set[String] = Set(SinkType)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, SinkDb => AnyRef] = Map(
       "SINK_TYPE" -> { instance: SinkDb => instance.sinkType}
    )
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[SinkDb] {
    override val forLabel = Sink.Label
    override val forLabelId = Sink.LabelId

    override def createNode(ref: NodeRef[SinkDb]) =
      new SinkDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Sink(graph, id)
  }
}

trait SinkBase extends CpgNode  with HasSinkType {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def node: TrackingPointBase
def nodeType: TypeBase
def method: MethodBase
def methodTags: List[TagBase]
def callingMethod: Option[MethodBase]
def callsite: Option[CallBase]
def parameterIn: Option[MethodParameterInBase]
def parameterInTags: List[TagBase]
}

class Sink(graph: OdbGraph, id: Long) extends NodeRef[SinkDb](graph, id)
  with SinkBase
  with StoredNode
   {
    override def sinkType = get().sinkType
    def node = get().node
  def nodeType = get().nodeType
  def method = get().method
  def methodTags = get().methodTags
  def callingMethod = get().callingMethod
  def callsite = get().callsite
  def parameterIn = get().parameterIn
  def parameterInTags = get().parameterInTags
  def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
def _methodParameterInViaContainsNodeOut: Iterator[MethodParameterIn] = get()._methodParameterInViaContainsNodeOut
def _methodViaContainsNodeOut: Iterator[Method] = get()._methodViaContainsNodeOut
def _typeViaContainsNodeOut: Iterator[Type] = get()._typeViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _callViaContainsNodeOut: Iterator[Call] = get()._callViaContainsNodeOut
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = get()._trackingPointViaContainsNodeOut
def _writeViaContainsNodeIn: Iterator[Write] = get()._writeViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = get()._ioflowViaContainsNodeIn
def _transformViaContainsNodeIn: Iterator[Transform] = get()._transformViaContainsNodeIn
def _flowViaContainsNodeIn: Iterator[Flow] = get()._flowViaContainsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Sink.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "sinkType" 
case 2 => "node" 
case 3 => "nodeType" 
case 4 => "method" 
case 5 => "methodTags" 
case 6 => "callingMethod" 
case 7 => "callsite" 
case 8 => "parameterIn" 
case 9 => "parameterInTags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => sinkType
case 2 => node
case 3 => nodeType
case 4 => method
case 5 => methodTags
case 6 => callingMethod
case 7 => callsite
case 8 => parameterIn
case 9 => parameterInTags
    }

  override def productPrefix = "Sink"
  override def productArity = 10
}

class SinkDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SinkBase {

  override def layoutInformation: NodeLayoutInformation = Sink.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (sinkType != null) { properties.put("SINK_TYPE", sinkType) }
  properties
}

  private var _sinkType: String = null
def sinkType(): String = _sinkType
  def _methodViaContainsNodeOut: Iterator[Method] = _containsNodeOut.asScala.collect { case node: Method => node }
def _typeViaContainsNodeOut: Iterator[Type] = _containsNodeOut.asScala.collect { case node: Type => node }
def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = _containsNodeOut.asScala.collect { case node: TrackingPoint => node }
def _methodParameterInViaContainsNodeOut: Iterator[MethodParameterIn] = _containsNodeOut.asScala.collect { case node: MethodParameterIn => node }
def _callViaContainsNodeOut: Iterator[Call] = _containsNodeOut.asScala.collect { case node: Call => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _transformViaContainsNodeIn: Iterator[Transform] = _containsNodeIn.asScala.collect { case node: Transform => node }
def _writeViaContainsNodeIn: Iterator[Write] = _containsNodeIn.asScala.collect { case node: Write => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = _containsNodeIn.asScala.collect { case node: Ioflow => node }
def _flowViaContainsNodeIn: Iterator[Flow] = _containsNodeIn.asScala.collect { case node: Flow => node }

  override def label: String = {
    Sink.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "sinkType" 
case 2 => "node" 
case 3 => "nodeType" 
case 4 => "method" 
case 5 => "methodTags" 
case 6 => "callingMethod" 
case 7 => "callsite" 
case 8 => "parameterIn" 
case 9 => "parameterInTags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => sinkType
case 2 => node
case 3 => nodeType
case 4 => method
case 5 => methodTags
case 6 => callingMethod
case 7 => callsite
case 8 => parameterIn
case 9 => parameterInTags
    }

  override def productPrefix = "Sink"
  override def productArity = 10

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SinkDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Sink.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Sink.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "SINK_TYPE") this._sinkType = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "SINK_TYPE") this._sinkType = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type TrackingPoint */
def node: TrackingPoint =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "node").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[TrackingPoint])
    .head

/** link to 'contained' node of type Type */
def nodeType: Type =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "nodeType").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Type])
    .head

/** link to 'contained' node of type Method */
def method: Method =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "method").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Method])
    .head

/** link to 'contained' node of type Tag */
def methodTags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "methodTags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

/** link to 'contained' node of type Method */
def callingMethod: Option[Method] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "callingMethod").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Method])
    .headOption

/** link to 'contained' node of type Call */
def callsite: Option[Call] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "callsite").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Call])
    .headOption

/** link to 'contained' node of type MethodParameterIn */
def parameterIn: Option[MethodParameterIn] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "parameterIn").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[MethodParameterIn])
    .headOption

/** link to 'contained' node of type Tag */
def parameterInTags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "parameterInTags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

}

