package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Source {
  def apply(graph: OdbGraph, id: Long) = new Source(graph, id)

  val Label = "SOURCE"
  val LabelId: Int = 202

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val SourceType = "SOURCE_TYPE" 
    val all: Set[String] = Set(SourceType)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, SourceDb => AnyRef] = Map(
       "SOURCE_TYPE" -> { instance: SourceDb => instance.sourceType}
    )
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[SourceDb] {
    override val forLabel = Source.Label
    override val forLabelId = Source.LabelId

    override def createNode(ref: NodeRef[SourceDb]) =
      new SourceDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Source(graph, id)
  }
}

trait SourceBase extends CpgNode  with HasSourceType {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def node: TrackingPointBase
def method: MethodBase
def methodTags: List[TagBase]
def callingMethod: Option[MethodBase]
def callsite: Option[CallBase]
def tags: List[TagBase]
def nodeType: TypeBase
}

class Source(graph: OdbGraph, id: Long) extends NodeRef[SourceDb](graph, id)
  with SourceBase
  with StoredNode
   {
    override def sourceType = get().sourceType
    def node = get().node
  def method = get().method
  def methodTags = get().methodTags
  def callingMethod = get().callingMethod
  def callsite = get().callsite
  def tags = get().tags
  def nodeType = get().nodeType
  def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
def _methodViaContainsNodeOut: Iterator[Method] = get()._methodViaContainsNodeOut
def _typeViaContainsNodeOut: Iterator[Type] = get()._typeViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _callViaContainsNodeOut: Iterator[Call] = get()._callViaContainsNodeOut
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = get()._trackingPointViaContainsNodeOut
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = get()._ioflowViaContainsNodeIn
def _readViaContainsNodeIn: Iterator[Read] = get()._readViaContainsNodeIn
def _flowViaContainsNodeIn: Iterator[Flow] = get()._flowViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Source.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "sourceType" 
case 2 => "node" 
case 3 => "method" 
case 4 => "methodTags" 
case 5 => "callingMethod" 
case 6 => "callsite" 
case 7 => "tags" 
case 8 => "nodeType" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => sourceType
case 2 => node
case 3 => method
case 4 => methodTags
case 5 => callingMethod
case 6 => callsite
case 7 => tags
case 8 => nodeType
    }

  override def productPrefix = "Source"
  override def productArity = 9
}

class SourceDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SourceBase {

  override def layoutInformation: NodeLayoutInformation = Source.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (sourceType != null) { properties.put("SOURCE_TYPE", sourceType) }
  properties
}

  private var _sourceType: String = null
def sourceType(): String = _sourceType
  def _methodViaContainsNodeOut: Iterator[Method] = _containsNodeOut.asScala.collect { case node: Method => node }
def _typeViaContainsNodeOut: Iterator[Type] = _containsNodeOut.asScala.collect { case node: Type => node }
def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = _containsNodeOut.asScala.collect { case node: TrackingPoint => node }
def _callViaContainsNodeOut: Iterator[Call] = _containsNodeOut.asScala.collect { case node: Call => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = _containsNodeIn.asScala.collect { case node: Ioflow => node }
def _readViaContainsNodeIn: Iterator[Read] = _containsNodeIn.asScala.collect { case node: Read => node }
def _flowViaContainsNodeIn: Iterator[Flow] = _containsNodeIn.asScala.collect { case node: Flow => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Source.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "sourceType" 
case 2 => "node" 
case 3 => "method" 
case 4 => "methodTags" 
case 5 => "callingMethod" 
case 6 => "callsite" 
case 7 => "tags" 
case 8 => "nodeType" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => sourceType
case 2 => node
case 3 => method
case 4 => methodTags
case 5 => callingMethod
case 6 => callsite
case 7 => tags
case 8 => nodeType
    }

  override def productPrefix = "Source"
  override def productArity = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SourceDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Source.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Source.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "SOURCE_TYPE") this._sourceType = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "SOURCE_TYPE") this._sourceType = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type TrackingPoint */
def node: TrackingPoint =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "node").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[TrackingPoint])
    .head

/** link to 'contained' node of type Method */
def method: Method =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "method").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Method])
    .head

/** link to 'contained' node of type Tag */
def methodTags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "methodTags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

/** link to 'contained' node of type Method */
def callingMethod: Option[Method] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "callingMethod").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Method])
    .headOption

/** link to 'contained' node of type Call */
def callsite: Option[Call] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "callsite").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Call])
    .headOption

/** link to 'contained' node of type Tag */
def tags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "tags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

/** link to 'contained' node of type Type */
def nodeType: Type =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "nodeType").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Type])
    .head

}

