package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object SpBlacklist {
  def apply(graph: OdbGraph, id: Long) = new SpBlacklist(graph, id)

  val Label = "SP_BLACKLIST"
  val LabelId: Int = 216

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    
    val all: Set[String] = Set()
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, SpBlacklistDb => AnyRef] = Map(
      
    )
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[SpBlacklistDb] {
    override val forLabel = SpBlacklist.Label
    override val forLabelId = SpBlacklist.LabelId

    override def createNode(ref: NodeRef[SpBlacklistDb]) =
      new SpBlacklistDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = SpBlacklist(graph, id)
  }
}

trait SpBlacklistBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def tags: List[TagBase]
}

class SpBlacklist(graph: OdbGraph, id: Long) extends NodeRef[SpBlacklistDb](graph, id)
  with SpBlacklistBase
  with StoredNode
   {
  
    def tags = get().tags
  def _tagViaContainsNodeOut: Iterator[Tag] = get()._tagViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SpBlacklist.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "tags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => tags
    }

  override def productPrefix = "SpBlacklist"
  override def productArity = 2
}

class SpBlacklistDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with SpBlacklistBase {

  override def layoutInformation: NodeLayoutInformation = SpBlacklist.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

  
  def _tagViaContainsNodeOut: Iterator[Tag] = _containsNodeOut.asScala.collect { case node: Tag => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SpBlacklist.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "tags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => tags
    }

  override def productPrefix = "SpBlacklist"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SpBlacklistDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    SpBlacklist.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    SpBlacklist.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
    throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type Tag */
def tags: List[Tag] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "tags").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Tag])
    .toList

}

