package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Transform {
  def apply(graph: OdbGraph, id: Long) = new Transform(graph, id)

  val Label = "TRANSFORM"
  val LabelId: Int = 211

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    
    val all: Set[String] = Set()
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, TransformDb => AnyRef] = Map(
      
    )
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[TransformDb] {
    override val forLabel = Transform.Label
    override val forLabelId = Transform.LabelId

    override def createNode(ref: NodeRef[TransformDb]) =
      new TransformDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Transform(graph, id)
  }
}

trait TransformBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def triggerCallChains: List[CallChainBase]
def descriptorFlows: List[FlowBase]
def call: CallBase
def sink: SinkBase
}

class Transform(graph: OdbGraph, id: Long) extends NodeRef[TransformDb](graph, id)
  with TransformBase
  with StoredNode
   {
  
    def triggerCallChains = get().triggerCallChains
  def descriptorFlows = get().descriptorFlows
  def call = get().call
  def sink = get().sink
  def _flowViaContainsNodeOut: Iterator[Flow] = get()._flowViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sinkViaContainsNodeOut: Iterator[Sink] = get()._sinkViaContainsNodeOut
def _callViaContainsNodeOut: Iterator[Call] = get()._callViaContainsNodeOut
def _callChainViaContainsNodeOut: Iterator[CallChain] = get()._callChainViaContainsNodeOut
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = get()._ioflowViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Transform.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "triggerCallChains" 
case 2 => "descriptorFlows" 
case 3 => "call" 
case 4 => "sink" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => triggerCallChains
case 2 => descriptorFlows
case 3 => call
case 4 => sink
    }

  override def productPrefix = "Transform"
  override def productArity = 5
}

class TransformDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with TransformBase {

  override def layoutInformation: NodeLayoutInformation = Transform.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  
  properties
}

  
  def _flowViaContainsNodeOut: Iterator[Flow] = _containsNodeOut.asScala.collect { case node: Flow => node }
def _sinkViaContainsNodeOut: Iterator[Sink] = _containsNodeOut.asScala.collect { case node: Sink => node }
def _callChainViaContainsNodeOut: Iterator[CallChain] = _containsNodeOut.asScala.collect { case node: CallChain => node }
def _callViaContainsNodeOut: Iterator[Call] = _containsNodeOut.asScala.collect { case node: Call => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = _containsNodeIn.asScala.collect { case node: Ioflow => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Transform.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "triggerCallChains" 
case 2 => "descriptorFlows" 
case 3 => "call" 
case 4 => "sink" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => triggerCallChains
case 2 => descriptorFlows
case 3 => call
case 4 => sink
    }

  override def productPrefix = "Transform"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TransformDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Transform.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Transform.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
    throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  /** link to 'contained' node of type CallChain */
def triggerCallChains: List[CallChain] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "triggerCallChains").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[CallChain])
    .toList

/** link to 'contained' node of type Flow */
def descriptorFlows: List[Flow] =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "descriptorFlows").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Flow])
    .toList

/** link to 'contained' node of type Call */
def call: Call =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "call").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Call])
    .head

/** link to 'contained' node of type Sink */
def sink: Sink =
  edges(Direction.OUT, "CONTAINS_NODE").asScala.toList
    .filter(_.valueOption(EdgeKeys.LOCAL_NAME).map(_  == "sink").getOrElse(false))
    .sortBy(_.valueOption(EdgeKeys.INDEX))
    .map(_.inVertex.asInstanceOf[Sink])
    .head

}

