package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Type {
  def apply(graph: OdbGraph, id: Long) = new Type(graph, id)

  val Label = "TYPE"
  val LabelId: Int = 45

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ref.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.Ref.layoutInformation, edges.AliasOf.layoutInformation, edges.InheritsFrom.layoutInformation, edges.ContainsNode.layoutInformation, edges.EvalType.layoutInformation).asJava)

  object PropertyNames {
    val Name = "NAME" 
val FullName = "FULL_NAME" 
val TypeDeclFullName = "TYPE_DECL_FULL_NAME" 
    val all: Set[String] = Set(Name, FullName, TypeDeclFullName)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, TypeDb => AnyRef] = Map(
       "NAME" -> { instance: TypeDb => instance.name},
 "FULL_NAME" -> { instance: TypeDb => instance.fullName},
 "TYPE_DECL_FULL_NAME" -> { instance: TypeDb => instance.typeDeclFullName}
    )
  }

  object Edges {
    val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","REF","ALIAS_OF","INHERITS_FROM","CONTAINS_NODE","EVAL_TYPE")
    val Out: Array[String] = Array("REF","AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[TypeDb] {
    override val forLabel = Type.Label
    override val forLabelId = Type.LabelId

    override def createNode(ref: NodeRef[TypeDb]) =
      new TypeDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Type(graph, id)
  }
}

trait TypeBase extends CpgNode  with HasName with HasFullName with HasTypeDeclFullName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Type(graph: OdbGraph, id: Long) extends NodeRef[TypeDb](graph, id)
  with TypeBase
  with StoredNode
   {
    override def name = get().name
  override def fullName = get().fullName
  override def typeDeclFullName = get().typeDeclFullName
  
  def _typeDeclViaRefOut: Iterator[TypeDecl] = get()._typeDeclViaRefOut
override def _refOut(): JIterator[StoredNode] = get()._refOut
def _typeArgumentViaAstOut: Iterator[TypeArgument] = get()._typeArgumentViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveMemberViaIsSensitiveDataDescrOfIn: Iterator[SensitiveMember] = get()._sensitiveMemberViaIsSensitiveDataDescrOfIn
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn
def _typeArgumentViaRefIn: Iterator[TypeArgument] = get()._typeArgumentViaRefIn
override def _refIn(): JIterator[StoredNode] = get()._refIn
def _typeDeclViaAliasOfIn: Iterator[TypeDecl] = get()._typeDeclViaAliasOfIn
override def _aliasOfIn(): JIterator[StoredNode] = get()._aliasOfIn
def _typeDeclViaInheritsFromIn: Iterator[TypeDecl] = get()._typeDeclViaInheritsFromIn
override def _inheritsFromIn(): JIterator[StoredNode] = get()._inheritsFromIn
def _sourceViaContainsNodeIn: Iterator[Source] = get()._sourceViaContainsNodeIn
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
def _sinkViaContainsNodeIn: Iterator[Sink] = get()._sinkViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _unknownViaEvalTypeIn: Iterator[Unknown] = get()._unknownViaEvalTypeIn
def _arrayInitializerViaEvalTypeIn: Iterator[ArrayInitializer] = get()._arrayInitializerViaEvalTypeIn
def _methodParameterOutViaEvalTypeIn: Iterator[MethodParameterOut] = get()._methodParameterOutViaEvalTypeIn
override def _evalTypeIn(): JIterator[StoredNode] = get()._evalTypeIn
def _blockViaEvalTypeIn: Iterator[Block] = get()._blockViaEvalTypeIn
def _memberViaEvalTypeIn: Iterator[Member] = get()._memberViaEvalTypeIn
def _callViaEvalTypeIn: Iterator[Call] = get()._callViaEvalTypeIn
def _methodRefViaEvalTypeIn: Iterator[MethodRef] = get()._methodRefViaEvalTypeIn
def _literalViaEvalTypeIn: Iterator[Literal] = get()._literalViaEvalTypeIn
def _methodReturnViaEvalTypeIn: Iterator[MethodReturn] = get()._methodReturnViaEvalTypeIn
def _controlStructureViaEvalTypeIn: Iterator[ControlStructure] = get()._controlStructureViaEvalTypeIn
def _identifierViaEvalTypeIn: Iterator[Identifier] = get()._identifierViaEvalTypeIn
def _methodParameterInViaEvalTypeIn: Iterator[MethodParameterIn] = get()._methodParameterInViaEvalTypeIn
def _localViaEvalTypeIn: Iterator[Local] = get()._localViaEvalTypeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Type.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "fullName" 
case 3 => "typeDeclFullName" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => fullName
case 3 => typeDeclFullName
    }

  override def productPrefix = "Type"
  override def productArity = 4
}

class TypeDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with TypeBase {

  override def layoutInformation: NodeLayoutInformation = Type.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (typeDeclFullName != null) { properties.put("TYPE_DECL_FULL_NAME", typeDeclFullName) }
  properties
}

  private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _typeDeclFullName: String = null
def typeDeclFullName(): String = _typeDeclFullName
  def _typeDeclViaRefOut: Iterator[TypeDecl] = _refOut.asScala.collect { case node: TypeDecl => node }
override def _refOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _typeArgumentViaAstOut: Iterator[TypeArgument] = _astOut.asScala.collect { case node: TypeArgument => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _sensitiveMemberViaIsSensitiveDataDescrOfIn: Iterator[SensitiveMember] = _isSensitiveDataDescrOfIn.asScala.collect { case node: SensitiveMember => node }
override def _isSensitiveDataDescrOfIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _typeArgumentViaRefIn: Iterator[TypeArgument] = _refIn.asScala.collect { case node: TypeArgument => node }
override def _refIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _typeDeclViaAliasOfIn: Iterator[TypeDecl] = _aliasOfIn.asScala.collect { case node: TypeDecl => node }
override def _aliasOfIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _typeDeclViaInheritsFromIn: Iterator[TypeDecl] = _inheritsFromIn.asScala.collect { case node: TypeDecl => node }
override def _inheritsFromIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _sourceViaContainsNodeIn: Iterator[Source] = _containsNodeIn.asScala.collect { case node: Source => node }
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }
def _sinkViaContainsNodeIn: Iterator[Sink] = _containsNodeIn.asScala.collect { case node: Sink => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
def _memberViaEvalTypeIn: Iterator[Member] = _evalTypeIn.asScala.collect { case node: Member => node }
def _methodRefViaEvalTypeIn: Iterator[MethodRef] = _evalTypeIn.asScala.collect { case node: MethodRef => node }
def _controlStructureViaEvalTypeIn: Iterator[ControlStructure] = _evalTypeIn.asScala.collect { case node: ControlStructure => node }
def _methodParameterInViaEvalTypeIn: Iterator[MethodParameterIn] = _evalTypeIn.asScala.collect { case node: MethodParameterIn => node }
def _literalViaEvalTypeIn: Iterator[Literal] = _evalTypeIn.asScala.collect { case node: Literal => node }
def _methodReturnViaEvalTypeIn: Iterator[MethodReturn] = _evalTypeIn.asScala.collect { case node: MethodReturn => node }
def _callViaEvalTypeIn: Iterator[Call] = _evalTypeIn.asScala.collect { case node: Call => node }
override def _evalTypeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
def _arrayInitializerViaEvalTypeIn: Iterator[ArrayInitializer] = _evalTypeIn.asScala.collect { case node: ArrayInitializer => node }
def _unknownViaEvalTypeIn: Iterator[Unknown] = _evalTypeIn.asScala.collect { case node: Unknown => node }
def _localViaEvalTypeIn: Iterator[Local] = _evalTypeIn.asScala.collect { case node: Local => node }
def _blockViaEvalTypeIn: Iterator[Block] = _evalTypeIn.asScala.collect { case node: Block => node }
def _identifierViaEvalTypeIn: Iterator[Identifier] = _evalTypeIn.asScala.collect { case node: Identifier => node }
def _methodParameterOutViaEvalTypeIn: Iterator[MethodParameterOut] = _evalTypeIn.asScala.collect { case node: MethodParameterOut => node }

  override def label: String = {
    Type.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "fullName" 
case 3 => "typeDeclFullName" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => fullName
case 3 => typeDeclFullName
    }

  override def productPrefix = "Type"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TypeDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    Type.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    Type.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "FULL_NAME") this._fullName = value.asInstanceOf[String] 
 else  if (key == "TYPE_DECL_FULL_NAME") this._typeDeclFullName = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "NAME") this._name = null 
 else  if (key == "FULL_NAME") this._fullName = null 
 else  if (key == "TYPE_DECL_FULL_NAME") this._typeDeclFullName = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

