package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object TypeDecl {
  def apply(graph: OdbGraph, id: Long) = new TypeDecl(graph, id)

  val Label = "TYPE_DECL"
  val LabelId: Int = 46

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Vtable.layoutInformation, edges.SourceFile.layoutInformation, edges.Contains.layoutInformation, edges.Binds.layoutInformation, edges.AliasOf.layoutInformation, edges.InheritsFrom.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.Ref.layoutInformation, edges.Contains.layoutInformation, edges.DynamicType.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Name = "NAME" 
val FullName = "FULL_NAME" 
val IsExternal = "IS_EXTERNAL" 
val InheritsFromTypeFullName = "INHERITS_FROM_TYPE_FULL_NAME" 
val AstParentType = "AST_PARENT_TYPE" 
val AstParentFullName = "AST_PARENT_FULL_NAME" 
val AliasTypeFullName = "ALIAS_TYPE_FULL_NAME" 
val Order = "ORDER" 
val Filename = "FILENAME" 
    val all: Set[String] = Set(Name, FullName, IsExternal, InheritsFromTypeFullName, AstParentType, AstParentFullName, AliasTypeFullName, Order, Filename)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, TypeDeclDb => AnyRef] = Map(
       "NAME" -> { instance: TypeDeclDb => instance.name},
 "FULL_NAME" -> { instance: TypeDeclDb => instance.fullName},
 "IS_EXTERNAL" -> { instance: TypeDeclDb => instance.isExternal},
 "INHERITS_FROM_TYPE_FULL_NAME" -> { instance: TypeDeclDb => instance.inheritsFromTypeFullName},
 "AST_PARENT_TYPE" -> { instance: TypeDeclDb => instance.astParentType},
 "AST_PARENT_FULL_NAME" -> { instance: TypeDeclDb => instance.astParentFullName},
 "ALIAS_TYPE_FULL_NAME" -> { instance: TypeDeclDb => instance.aliasTypeFullName.orNull},
 "ORDER" -> { instance: TypeDeclDb => instance.order},
 "FILENAME" -> { instance: TypeDeclDb => instance.filename}
    )
  }

  object Edges {
    val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","REF","CONTAINS","DYNAMIC_TYPE","AST","CONTAINS_NODE")
    val Out: Array[String] = Array("VTABLE","SOURCE_FILE","CONTAINS","BINDS","ALIAS_OF","INHERITS_FROM","AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[TypeDeclDb] {
    override val forLabel = TypeDecl.Label
    override val forLabelId = TypeDecl.LabelId

    override def createNode(ref: NodeRef[TypeDeclDb]) =
      new TypeDeclDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = TypeDecl(graph, id)
  }
}

trait TypeDeclBase extends CpgNode with AstNodeBase with HasName with HasFullName with HasIsExternal with HasInheritsFromTypeFullName with HasAstParentType with HasAstParentFullName with HasAliasTypeFullName with HasOrder with HasFilename {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class TypeDecl(graph: OdbGraph, id: Long) extends NodeRef[TypeDeclDb](graph, id)
  with TypeDeclBase
  with StoredNode
  with AstNode {
    override def name = get().name
  override def fullName = get().fullName
  override def isExternal = get().isExternal
  override def inheritsFromTypeFullName = get().inheritsFromTypeFullName
  override def astParentType = get().astParentType
  override def astParentFullName = get().astParentFullName
  override def aliasTypeFullName = get().aliasTypeFullName
  override def order = get().order
  override def filename = get().filename
  
  def _methodViaVtableOut: Iterator[Method] = get()._methodViaVtableOut
override def _vtableOut(): JIterator[StoredNode] = get()._vtableOut
def _fileViaSourceFileOut: Iterator[File] = get()._fileViaSourceFileOut
override def _sourceFileOut(): JIterator[StoredNode] = get()._sourceFileOut
def _methodViaContainsOut: Iterator[Method] = get()._methodViaContainsOut
override def _containsOut(): JIterator[StoredNode] = get()._containsOut
def _bindingViaBindsOut: Iterator[Binding] = get()._bindingViaBindsOut
override def _bindsOut(): JIterator[StoredNode] = get()._bindsOut
def _typeViaAliasOfOut: Iterator[Type] = get()._typeViaAliasOfOut
override def _aliasOfOut(): JIterator[StoredNode] = get()._aliasOfOut
def _typeViaInheritsFromOut: Iterator[Type] = get()._typeViaInheritsFromOut
override def _inheritsFromOut(): JIterator[StoredNode] = get()._inheritsFromOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
def _typeDeclViaAstOut: Iterator[TypeDecl] = get()._typeDeclViaAstOut
def _annotationViaAstOut: Iterator[Annotation] = get()._annotationViaAstOut
def _memberViaAstOut: Iterator[Member] = get()._memberViaAstOut
def _methodViaAstOut: Iterator[Method] = get()._methodViaAstOut
def _typeParameterViaAstOut: Iterator[TypeParameter] = get()._typeParameterViaAstOut
def _modifierViaAstOut: Iterator[Modifier] = get()._modifierViaAstOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveDataTypeViaIsSensitiveDataDescrOfIn: Iterator[SensitiveDataType] = get()._sensitiveDataTypeViaIsSensitiveDataDescrOfIn
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn
def _typeViaRefIn: Iterator[Type] = get()._typeViaRefIn
override def _refIn(): JIterator[StoredNode] = get()._refIn
def _fileViaContainsIn: Iterator[File] = get()._fileViaContainsIn
override def _containsIn(): JIterator[StoredNode] = get()._containsIn
def _methodParameterInViaDynamicTypeIn: Iterator[MethodParameterIn] = get()._methodParameterInViaDynamicTypeIn
def _localViaDynamicTypeIn: Iterator[Local] = get()._localViaDynamicTypeIn
override def _dynamicTypeIn(): JIterator[StoredNode] = get()._dynamicTypeIn
def _unknownViaDynamicTypeIn: Iterator[Unknown] = get()._unknownViaDynamicTypeIn
def _fieldIdentifierViaDynamicTypeIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDynamicTypeIn
def _identifierViaDynamicTypeIn: Iterator[Identifier] = get()._identifierViaDynamicTypeIn
def _literalViaDynamicTypeIn: Iterator[Literal] = get()._literalViaDynamicTypeIn
def _callViaDynamicTypeIn: Iterator[Call] = get()._callViaDynamicTypeIn
def _memberViaDynamicTypeIn: Iterator[Member] = get()._memberViaDynamicTypeIn
def _methodReturnViaDynamicTypeIn: Iterator[MethodReturn] = get()._methodReturnViaDynamicTypeIn
def _controlStructureViaDynamicTypeIn: Iterator[ControlStructure] = get()._controlStructureViaDynamicTypeIn
def _blockViaDynamicTypeIn: Iterator[Block] = get()._blockViaDynamicTypeIn
def _methodRefViaDynamicTypeIn: Iterator[MethodRef] = get()._methodRefViaDynamicTypeIn
def _methodViaAstIn: Option[Method] = get()._methodViaAstIn
def _namespaceBlockViaAstIn: Option[NamespaceBlock] = get()._namespaceBlockViaAstIn
def _typeDeclViaAstIn: Option[TypeDecl] = get()._typeDeclViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    TypeDecl.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "fullName" 
case 3 => "isExternal" 
case 4 => "inheritsFromTypeFullName" 
case 5 => "astParentType" 
case 6 => "astParentFullName" 
case 7 => "aliasTypeFullName" 
case 8 => "order" 
case 9 => "filename" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => fullName
case 3 => isExternal
case 4 => inheritsFromTypeFullName
case 5 => astParentType
case 6 => astParentFullName
case 7 => aliasTypeFullName
case 8 => order
case 9 => filename
    }

  override def productPrefix = "TypeDecl"
  override def productArity = 10
}

class TypeDeclDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with AstNode with TypeDeclBase {

  override def layoutInformation: NodeLayoutInformation = TypeDecl.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (isExternal != null) { properties.put("IS_EXTERNAL", isExternal) }
if (inheritsFromTypeFullName.nonEmpty) { properties.put("INHERITS_FROM_TYPE_FULL_NAME", inheritsFromTypeFullName.asJava) }
if (astParentType != null) { properties.put("AST_PARENT_TYPE", astParentType) }
if (astParentFullName != null) { properties.put("AST_PARENT_FULL_NAME", astParentFullName) }
aliasTypeFullName.map { value => properties.put("ALIAS_TYPE_FULL_NAME", value) }
if (order != null) { properties.put("ORDER", order) }
if (filename != null) { properties.put("FILENAME", filename) }
  properties
}

  private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _isExternal: JBoolean = null
def isExternal(): JBoolean = _isExternal

private var _inheritsFromTypeFullName: List[String] = Nil
def inheritsFromTypeFullName(): List[String] = _inheritsFromTypeFullName

private var _astParentType: String = null
def astParentType(): String = _astParentType

private var _astParentFullName: String = null
def astParentFullName(): String = _astParentFullName

private var _aliasTypeFullName: Option[String] = None
def aliasTypeFullName(): Option[String] = _aliasTypeFullName

private var _order: Integer = null
def order(): Integer = _order

private var _filename: String = null
def filename(): String = _filename
  def _methodViaVtableOut: Iterator[Method] = _vtableOut.asScala.collect { case node: Method => node }
override def _vtableOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _fileViaSourceFileOut: Iterator[File] = _sourceFileOut.asScala.collect { case node: File => node }
override def _sourceFileOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodViaContainsOut: Iterator[Method] = _containsOut.asScala.collect { case node: Method => node }
override def _containsOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _bindingViaBindsOut: Iterator[Binding] = _bindsOut.asScala.collect { case node: Binding => node }
override def _bindsOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _typeViaAliasOfOut: Iterator[Type] = _aliasOfOut.asScala.collect { case node: Type => node }
override def _aliasOfOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _typeViaInheritsFromOut: Iterator[Type] = _inheritsFromOut.asScala.collect { case node: Type => node }
override def _inheritsFromOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _memberViaAstOut: Iterator[Member] = _astOut.asScala.collect { case node: Member => node }
def _typeDeclViaAstOut: Iterator[TypeDecl] = _astOut.asScala.collect { case node: TypeDecl => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstOut: Iterator[Method] = _astOut.asScala.collect { case node: Method => node }
def _annotationViaAstOut: Iterator[Annotation] = _astOut.asScala.collect { case node: Annotation => node }
def _typeParameterViaAstOut: Iterator[TypeParameter] = _astOut.asScala.collect { case node: TypeParameter => node }
def _modifierViaAstOut: Iterator[Modifier] = _astOut.asScala.collect { case node: Modifier => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
def _sensitiveDataTypeViaIsSensitiveDataDescrOfIn: Iterator[SensitiveDataType] = _isSensitiveDataDescrOfIn.asScala.collect { case node: SensitiveDataType => node }
override def _isSensitiveDataDescrOfIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
def _typeViaRefIn: Iterator[Type] = _refIn.asScala.collect { case node: Type => node }
override def _refIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
def _fileViaContainsIn: Iterator[File] = _containsIn.asScala.collect { case node: File => node }
override def _containsIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
def _blockViaDynamicTypeIn: Iterator[Block] = _dynamicTypeIn.asScala.collect { case node: Block => node }
override def _dynamicTypeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
def _identifierViaDynamicTypeIn: Iterator[Identifier] = _dynamicTypeIn.asScala.collect { case node: Identifier => node }
def _controlStructureViaDynamicTypeIn: Iterator[ControlStructure] = _dynamicTypeIn.asScala.collect { case node: ControlStructure => node }
def _methodRefViaDynamicTypeIn: Iterator[MethodRef] = _dynamicTypeIn.asScala.collect { case node: MethodRef => node }
def _literalViaDynamicTypeIn: Iterator[Literal] = _dynamicTypeIn.asScala.collect { case node: Literal => node }
def _fieldIdentifierViaDynamicTypeIn: Iterator[FieldIdentifier] = _dynamicTypeIn.asScala.collect { case node: FieldIdentifier => node }
def _methodReturnViaDynamicTypeIn: Iterator[MethodReturn] = _dynamicTypeIn.asScala.collect { case node: MethodReturn => node }
def _memberViaDynamicTypeIn: Iterator[Member] = _dynamicTypeIn.asScala.collect { case node: Member => node }
def _callViaDynamicTypeIn: Iterator[Call] = _dynamicTypeIn.asScala.collect { case node: Call => node }
def _methodParameterInViaDynamicTypeIn: Iterator[MethodParameterIn] = _dynamicTypeIn.asScala.collect { case node: MethodParameterIn => node }
def _localViaDynamicTypeIn: Iterator[Local] = _dynamicTypeIn.asScala.collect { case node: Local => node }
def _unknownViaDynamicTypeIn: Iterator[Unknown] = _dynamicTypeIn.asScala.collect { case node: Unknown => node }
def _methodViaAstIn: Option[Method] = _astIn.asScala.collect { case node: Method => node }.nextOption
def _namespaceBlockViaAstIn: Option[NamespaceBlock] = _astIn.asScala.collect { case node: NamespaceBlock => node }.nextOption
def _typeDeclViaAstIn: Option[TypeDecl] = _astIn.asScala.collect { case node: TypeDecl => node }.nextOption
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    TypeDecl.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "fullName" 
case 3 => "isExternal" 
case 4 => "inheritsFromTypeFullName" 
case 5 => "astParentType" 
case 6 => "astParentFullName" 
case 7 => "aliasTypeFullName" 
case 8 => "order" 
case 9 => "filename" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => fullName
case 3 => isExternal
case 4 => inheritsFromTypeFullName
case 5 => astParentType
case 6 => astParentFullName
case 7 => aliasTypeFullName
case 8 => order
case 9 => filename
    }

  override def productPrefix = "TypeDecl"
  override def productArity = 10

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TypeDeclDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    TypeDecl.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    TypeDecl.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "FULL_NAME") this._fullName = value.asInstanceOf[String] 
 else  if (key == "IS_EXTERNAL") this._isExternal = value.asInstanceOf[JBoolean] 
 else if (key == "INHERITS_FROM_TYPE_FULL_NAME") {
  if( value.isInstanceOf[List[_]]) { 
    this._inheritsFromTypeFullName = value.asInstanceOf[List[String]] 
  } else if (cardinality == VertexProperty.Cardinality.list) {
    if (this._inheritsFromTypeFullName == null) { this._inheritsFromTypeFullName = Nil }
    this._inheritsFromTypeFullName = this._inheritsFromTypeFullName :+ value.asInstanceOf[String]
  } else {
    this._inheritsFromTypeFullName = List(value.asInstanceOf[String])
  }
}

 else  if (key == "AST_PARENT_TYPE") this._astParentType = value.asInstanceOf[String] 
 else  if (key == "AST_PARENT_FULL_NAME") this._astParentFullName = value.asInstanceOf[String] 
 else  if (key == "ALIAS_TYPE_FULL_NAME") this._aliasTypeFullName = Option(value).asInstanceOf[Option[String]] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else  if (key == "FILENAME") this._filename = value.asInstanceOf[String] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "NAME") this._name = null 
 else  if (key == "FULL_NAME") this._fullName = null 
 else  if (key == "IS_EXTERNAL") this._isExternal = null 
 else  if (key == "INHERITS_FROM_TYPE_FULL_NAME") this._inheritsFromTypeFullName = Nil 
 else  if (key == "AST_PARENT_TYPE") this._astParentType = null 
 else  if (key == "AST_PARENT_FULL_NAME") this._astParentFullName = null 
 else  if (key == "ALIAS_TYPE_FULL_NAME") this._aliasTypeFullName = None 
 else  if (key == "ORDER") this._order = null 
 else  if (key == "FILENAME") this._filename = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

