package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object TypeParameter {
  def apply(graph: OdbGraph, id: Long) = new TypeParameter(graph, id)

  val Label = "TYPE_PARAMETER"
  val LabelId: Int = 47

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.BindsTo.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val Name = "NAME" 
val Order = "ORDER" 
    val all: Set[String] = Set(Name, Order)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, TypeParameterDb => AnyRef] = Map(
       "NAME" -> { instance: TypeParameterDb => instance.name},
 "ORDER" -> { instance: TypeParameterDb => instance.order}
    )
  }

  object Edges {
    val In: Array[String] = Array("BINDS_TO","AST","CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[TypeParameterDb] {
    override val forLabel = TypeParameter.Label
    override val forLabelId = TypeParameter.LabelId

    override def createNode(ref: NodeRef[TypeParameterDb]) =
      new TypeParameterDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = TypeParameter(graph, id)
  }
}

trait TypeParameterBase extends CpgNode with AstNodeBase with HasName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class TypeParameter(graph: OdbGraph, id: Long) extends NodeRef[TypeParameterDb](graph, id)
  with TypeParameterBase
  with StoredNode
  with AstNode {
    override def name = get().name
  override def order = get().order
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _typeArgumentViaBindsToIn: Iterator[TypeArgument] = get()._typeArgumentViaBindsToIn
override def _bindsToIn(): JIterator[StoredNode] = get()._bindsToIn
def _methodViaAstIn: Method = get()._methodViaAstIn
def _typeDeclViaAstIn: Iterator[TypeDecl] = get()._typeDeclViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    TypeParameter.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => order
    }

  override def productPrefix = "TypeParameter"
  override def productArity = 3
}

class TypeParameterDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with AstNode with TypeParameterBase {

  override def layoutInformation: NodeLayoutInformation = TypeParameter.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }
  properties
}

  private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _typeArgumentViaBindsToIn: Iterator[TypeArgument] = _bindsToIn.asScala.collect { case node: TypeArgument => node }
override def _bindsToIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstIn: Method = _astIn.asScala.collect { case node: Method => node }.next
def _typeDeclViaAstIn: Iterator[TypeDecl] = _astIn.asScala.collect { case node: TypeDecl => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    TypeParameter.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => order
    }

  override def productPrefix = "TypeParameter"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TypeParameterDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    TypeParameter.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    TypeParameter.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "NAME") this._name = value.asInstanceOf[String] 
 else  if (key == "ORDER") this._order = value.asInstanceOf[Integer] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "NAME") this._name = null 
 else  if (key == "ORDER") this._order = null 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

