package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object VariableInfo {
  def apply(graph: OdbGraph, id: Long) = new VariableInfo(graph, id)

  val Label = "VARIABLE_INFO"
  val LabelId: Int = 206

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val VarType = "VAR_TYPE" 
val EvaluationType = "EVALUATION_TYPE" 
val ParameterIndex = "PARAMETER_INDEX" 
    val all: Set[String] = Set(VarType, EvaluationType, ParameterIndex)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, VariableInfoDb => AnyRef] = Map(
       "VAR_TYPE" -> { instance: VariableInfoDb => instance.varType},
 "EVALUATION_TYPE" -> { instance: VariableInfoDb => instance.evaluationType},
 "PARAMETER_INDEX" -> { instance: VariableInfoDb => instance.parameterIndex.orNull}
    )
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[VariableInfoDb] {
    override val forLabel = VariableInfo.Label
    override val forLabelId = VariableInfo.LabelId

    override def createNode(ref: NodeRef[VariableInfoDb]) =
      new VariableInfoDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = VariableInfo(graph, id)
  }
}

trait VariableInfoBase extends CpgNode  with HasVarType with HasEvaluationType with HasParameterIndex {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class VariableInfo(graph: OdbGraph, id: Long) extends NodeRef[VariableInfoDb](graph, id)
  with VariableInfoBase
  with StoredNode
   {
    override def varType = get().varType
  override def evaluationType = get().evaluationType
  override def parameterIndex = get().parameterIndex
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    VariableInfo.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "varType" 
case 2 => "evaluationType" 
case 3 => "parameterIndex" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => varType
case 2 => evaluationType
case 3 => parameterIndex
    }

  override def productPrefix = "VariableInfo"
  override def productArity = 4
}

class VariableInfoDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with VariableInfoBase {

  override def layoutInformation: NodeLayoutInformation = VariableInfo.layoutInformation

  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
  if (varType != null) { properties.put("VAR_TYPE", varType) }
if (evaluationType != null) { properties.put("EVALUATION_TYPE", evaluationType) }
parameterIndex.map { value => properties.put("PARAMETER_INDEX", value) }
  properties
}

  private var _varType: String = null
def varType(): String = _varType

private var _evaluationType: String = null
def evaluationType(): String = _evaluationType

private var _parameterIndex: Option[Integer] = None
def parameterIndex(): Option[Integer] = _parameterIndex
  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    VariableInfo.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "varType" 
case 2 => "evaluationType" 
case 3 => "parameterIndex" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => varType
case 2 => evaluationType
case 3 => parameterIndex
    }

  override def productPrefix = "VariableInfo"
  override def productArity = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[VariableInfoDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
  override protected def specificProperty[A](key: String): VertexProperty[A] = {
    VariableInfo.Properties.keyToValue.get(key) match {
      case None => VertexProperty.empty[A]
      case Some(fieldAccess) =>
        fieldAccess(this) match {
          case null | None => VertexProperty.empty[A]
          case values: List[_] => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
          case Some(value) => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
          case value => new OdbNodeProperty(-1, this, key, value.asInstanceOf[A])
        }
    }
  }

  override protected def specificProperty2(key: String): AnyRef = {
    VariableInfo.Properties.keyToValue.get(key).map(fieldAccess => fieldAccess(this)).orNull
  }

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
     if (key == "VAR_TYPE") this._varType = value.asInstanceOf[String] 
 else  if (key == "EVALUATION_TYPE") this._evaluationType = value.asInstanceOf[String] 
 else  if (key == "PARAMETER_INDEX") this._parameterIndex = Option(value).asInstanceOf[Option[Integer]] 
 else PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    new OdbNodeProperty(-1, this, key, value)
  }

  override protected def removeSpecificProperty(key: String): Unit =
     if (key == "VAR_TYPE") this._varType = null 
 else  if (key == "EVALUATION_TYPE") this._evaluationType = null 
 else  if (key == "PARAMETER_INDEX") this._parameterIndex = None 
 else throw new RuntimeException("property with key=" + key + " not (yet) supported by " + this.getClass.getName + ". You may want to add it to the schema...")

  
}

