package io.shiftleft.codepropertygraph.generated.edges

import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Set => JSet}
import java.util.{List => JList}
import org.apache.tinkerpop.gremlin.structure.Property
import org.apache.tinkerpop.gremlin.structure.{Vertex, VertexProperty}
import overflowdb.{EdgeLayoutInformation, EdgeFactory, NodeFactory, OdbEdge, OdbNode, OdbGraph, NodeRef}
import scala.jdk.CollectionConverters._

object ContainsNode {
  val Label = "CONTAINS_NODE"

  object PropertyNames {
    val all: Set[String] = Set("LOCAL_NAME", "INDEX")
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val keyToValue: Map[String, ContainsNode => AnyRef] = Map(
       "LOCAL_NAME" -> { instance: ContainsNode => instance.localName()},
 "INDEX" -> { instance: ContainsNode => instance.index()}
    )
  }

  val layoutInformation = new EdgeLayoutInformation(Label, PropertyNames.allAsJava)

  val factory = new EdgeFactory[ContainsNode] {
    override val forLabel = ContainsNode.Label

    override def createEdge(graph: OdbGraph, outNode: NodeRef[OdbNode], inNode: NodeRef[OdbNode]) =
      new ContainsNode(graph, outNode, inNode)
  }
}

class ContainsNode(_graph: OdbGraph, _outNode: NodeRef[OdbNode], _inNode: NodeRef[OdbNode])
extends OdbEdge(_graph, ContainsNode.Label, _outNode, _inNode, ContainsNode.PropertyNames.allAsJava) {
def localName(): Option[String] = {
  val tp = property("LOCAL_NAME")
  if (tp.isPresent) Option(tp.value.asInstanceOf[String])
  else None
}

def index(): Option[Integer] = {
  val tp = property("INDEX")
  if (tp.isPresent) Option(tp.value.asInstanceOf[Integer])
  else None
}
}

