package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Annotation {
  def apply(graph: OdbGraph, id: Long) = new Annotation(graph, id)

  val Label = "ANNOTATION"
  val LabelId: Int = 5

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("CODE", "NAME", "FULL_NAME", "ORDER")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[AnnotationDb] {
    override val forLabel = Annotation.Label
    override val forLabelId = Annotation.LabelId

    override def createNode(ref: NodeRef[AnnotationDb]) =
      new AnnotationDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Annotation(graph, id)
  }
}

trait AnnotationBase extends CpgNode with AstNodeBase with HasCode with HasName with HasFullName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Annotation(graph: OdbGraph, id: Long) extends NodeRef[AnnotationDb](graph, id)
  with AnnotationBase
  with StoredNode
  with AstNode {
    override def code: String = get().code
  override def name: String = get().name
  override def fullName: String = get().fullName
  override def order: Integer = get().order
  
  def _annotationParameterAssignViaAstOut: Iterator[AnnotationParameterAssign] = get()._annotationParameterAssignViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = get()._annotationParameterAssignViaAstIn
def _methodParameterInViaAstIn: Iterator[MethodParameterIn] = get()._methodParameterInViaAstIn
def _memberViaAstIn: Iterator[Member] = get()._memberViaAstIn
def _methodViaAstIn: Iterator[Method] = get()._methodViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _typeDeclViaAstIn: Iterator[TypeDecl] = get()._typeDeclViaAstIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Annotation.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "fullName" 
case 4 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => name
case 3 => fullName
case 4 => order
    }

  override def productPrefix = "Annotation"
  override def productArity = 5
}

class AnnotationDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with AstNode with AnnotationBase {

  override def layoutInformation: NodeLayoutInformation = Annotation.layoutInformation

private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _order: Integer = null
def order(): Integer = _order


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (order != null) { properties.put("ORDER", order) }

  properties
}

  def _annotationParameterAssignViaAstOut: Iterator[AnnotationParameterAssign] = _astOut.asScala.collect { case node: AnnotationParameterAssign => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _memberViaAstIn: Iterator[Member] = _astIn.asScala.collect { case node: Member => node }
def _typeDeclViaAstIn: Iterator[TypeDecl] = _astIn.asScala.collect { case node: TypeDecl => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstIn: Iterator[Method] = _astIn.asScala.collect { case node: Method => node }
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = _astIn.asScala.collect { case node: AnnotationParameterAssign => node }
def _methodParameterInViaAstIn: Iterator[MethodParameterIn] = _astIn.asScala.collect { case node: MethodParameterIn => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Annotation.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "fullName" 
case 4 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => name
case 3 => fullName
case 4 => order
    }

  override def productPrefix = "Annotation"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "CODE" => if(this._code == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._code.asInstanceOf[A])
  case "NAME" => if(this._name == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._name.asInstanceOf[A])
  case "FULL_NAME" => if(this._fullName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._fullName.asInstanceOf[A])
  case "ORDER" => if(this._order == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._order.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "CODE" => this._code
  case "NAME" => this._name
  case "FULL_NAME" => this._fullName
  case "ORDER" => this._order

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "CODE" => this._code = value.asInstanceOf[String]
  case "NAME" => this._name = value.asInstanceOf[String]
  case "FULL_NAME" => this._fullName = value.asInstanceOf[String]
  case "ORDER" => this._order = value.asInstanceOf[Integer]

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewAnnotation]
   this._code = other.code
   this._name = other.name
   this._fullName = other.fullName
   this._order = other.order

  graph2().indexManager.putIfIndexed("FULL_NAME", other.fullName, this.ref)
}

}
