package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object ArrayInitializer {
  def apply(graph: OdbGraph, id: Long) = new ArrayInitializer(graph, id)

  val Label = "ARRAY_INITIALIZER"
  val LabelId: Int = 14

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.EvalType.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Condition.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("DEPTH_FIRST_ORDER", "INTERNAL_FLAGS", "CODE", "ORDER", "ARGUMENT_INDEX", "COLUMN_NUMBER", "LINE_NUMBER")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("CONDITION","AST","CONTAINS_NODE")
    val Out: Array[String] = Array("EVAL_TYPE","AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[ArrayInitializerDb] {
    override val forLabel = ArrayInitializer.Label
    override val forLabelId = ArrayInitializer.LabelId

    override def createNode(ref: NodeRef[ArrayInitializerDb]) =
      new ArrayInitializerDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = ArrayInitializer(graph, id)
  }
}

trait ArrayInitializerBase extends CpgNode with AstNodeBase with ExpressionBase with HasDepthFirstOrder with HasInternalFlags with HasCode with HasOrder with HasArgumentIndex with HasColumnNumber with HasLineNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class ArrayInitializer(graph: OdbGraph, id: Long) extends NodeRef[ArrayInitializerDb](graph, id)
  with ArrayInitializerBase
  with StoredNode
  with AstNode with Expression {
    override def depthFirstOrder: Option[Integer] = get().depthFirstOrder
  override def internalFlags: Option[Integer] = get().internalFlags
  override def code: String = get().code
  override def order: Integer = get().order
  override def argumentIndex: Integer = get().argumentIndex
  override def columnNumber: Option[Integer] = get().columnNumber
  override def lineNumber: Option[Integer] = get().lineNumber
  
  def _typeViaEvalTypeOut: Iterator[Type] = get()._typeViaEvalTypeOut
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut
def _literalViaAstOut: Iterator[Literal] = get()._literalViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _controlStructureViaConditionIn: Iterator[ControlStructure] = get()._controlStructureViaConditionIn
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn
def _unknownViaAstIn: Iterator[Unknown] = get()._unknownViaAstIn
def _controlStructureViaAstIn: Iterator[ControlStructure] = get()._controlStructureViaAstIn
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = get()._annotationParameterAssignViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ArrayInitializer.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "order" 
case 5 => "argumentIndex" 
case 6 => "columnNumber" 
case 7 => "lineNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => order
case 5 => argumentIndex
case 6 => columnNumber
case 7 => lineNumber
    }

  override def productPrefix = "ArrayInitializer"
  override def productArity = 8
}

class ArrayInitializerDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with AstNode with Expression with ArrayInitializerBase {

  override def layoutInformation: NodeLayoutInformation = ArrayInitializer.layoutInformation

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags

private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }
if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }

  properties
}

  def _typeViaEvalTypeOut: Iterator[Type] = _evalTypeOut.asScala.collect { case node: Type => node }
override def _evalTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _literalViaAstOut: Iterator[Literal] = _astOut.asScala.collect { case node: Literal => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _controlStructureViaConditionIn: Iterator[ControlStructure] = _conditionIn.asScala.collect { case node: ControlStructure => node }
override def _conditionIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _unknownViaAstIn: Iterator[Unknown] = _astIn.asScala.collect { case node: Unknown => node }
def _controlStructureViaAstIn: Iterator[ControlStructure] = _astIn.asScala.collect { case node: ControlStructure => node }
def _annotationParameterAssignViaAstIn: Iterator[AnnotationParameterAssign] = _astIn.asScala.collect { case node: AnnotationParameterAssign => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    ArrayInitializer.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "order" 
case 5 => "argumentIndex" 
case 6 => "columnNumber" 
case 7 => "lineNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => order
case 5 => argumentIndex
case 6 => columnNumber
case 7 => lineNumber
    }

  override def productPrefix = "ArrayInitializer"
  override def productArity = 8

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ArrayInitializerDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "DEPTH_FIRST_ORDER" => if(this._depthFirstOrder.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._depthFirstOrder.get.asInstanceOf[A])
  case "INTERNAL_FLAGS" => if(this._internalFlags.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._internalFlags.get.asInstanceOf[A])
  case "CODE" => if(this._code == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._code.asInstanceOf[A])
  case "ORDER" => if(this._order == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._order.asInstanceOf[A])
  case "ARGUMENT_INDEX" => if(this._argumentIndex == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._argumentIndex.asInstanceOf[A])
  case "COLUMN_NUMBER" => if(this._columnNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._columnNumber.get.asInstanceOf[A])
  case "LINE_NUMBER" => if(this._lineNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._lineNumber.get.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder.orNull
  case "INTERNAL_FLAGS" => this._internalFlags.orNull
  case "CODE" => this._code
  case "ORDER" => this._order
  case "ARGUMENT_INDEX" => this._argumentIndex
  case "COLUMN_NUMBER" => this._columnNumber.orNull
  case "LINE_NUMBER" => this._lineNumber.orNull

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "INTERNAL_FLAGS" => this._internalFlags = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "CODE" => this._code = value.asInstanceOf[String]
  case "ORDER" => this._order = value.asInstanceOf[Integer]
  case "ARGUMENT_INDEX" => this._argumentIndex = value.asInstanceOf[Integer]
  case "COLUMN_NUMBER" => this._columnNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "LINE_NUMBER" => this._lineNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewArrayInitializer]
   this._depthFirstOrder = other.depthFirstOrder
   this._internalFlags = other.internalFlags
   this._code = other.code
   this._order = other.order
   this._argumentIndex = other.argumentIndex
   this._columnNumber = other.columnNumber
   this._lineNumber = other.lineNumber


}

}
