package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Call {
  def apply(graph: OdbGraph, id: Long) = new Call(graph, id)

  val Label = "CALL"
  val LabelId: Int = 15

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Receiver.layoutInformation, edges.Cdg.layoutInformation, edges.Argument.layoutInformation, edges.Ref.layoutInformation, edges.TaggedBy.layoutInformation, edges.ReachingDef.layoutInformation, edges.Call.layoutInformation, edges.DynamicType.layoutInformation, edges.Cfg.layoutInformation, edges.PostDominate.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.ContainsNode.layoutInformation, edges.EvalType.layoutInformation).asJava,
    List(edges.Receiver.layoutInformation, edges.Cdg.layoutInformation, edges.Argument.layoutInformation, edges.Contains.layoutInformation, edges.ReachingDef.layoutInformation, edges.Condition.layoutInformation, edges.Cfg.layoutInformation, edges.PostDominate.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("CODE", "NAME", "ORDER", "METHOD_INST_FULL_NAME", "METHOD_FULL_NAME", "ARGUMENT_INDEX", "DISPATCH_TYPE", "SIGNATURE", "TYPE_FULL_NAME", "DYNAMIC_TYPE_HINT_FULL_NAME", "LINE_NUMBER", "COLUMN_NUMBER", "RESOLVED", "DEPTH_FIRST_ORDER", "INTERNAL_FLAGS")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("RECEIVER","CDG","ARGUMENT","CONTAINS","REACHING_DEF","CONDITION","CFG","POST_DOMINATE","AST","DOMINATE","CONTAINS_NODE")
    val Out: Array[String] = Array("RECEIVER","CDG","ARGUMENT","REF","TAGGED_BY","REACHING_DEF","CALL","DYNAMIC_TYPE","CFG","POST_DOMINATE","AST","DOMINATE","CONTAINS_NODE","EVAL_TYPE")
  }

  val factory = new NodeFactory[CallDb] {
    override val forLabel = Call.Label
    override val forLabelId = Call.LabelId

    override def createNode(ref: NodeRef[CallDb]) =
      new CallDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Call(graph, id)
  }
}

trait CallBase extends CpgNode with ExpressionBase with CallReprBase with HasCode with HasName with HasOrder with HasMethodInstFullName with HasMethodFullName with HasArgumentIndex with HasDispatchType with HasSignature with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber with HasResolved with HasDepthFirstOrder with HasInternalFlags {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Call(graph: OdbGraph, id: Long) extends NodeRef[CallDb](graph, id)
  with CallBase
  with StoredNode
  with Expression with CallRepr {
    override def code: String = get().code
  override def name: String = get().name
  override def order: Integer = get().order
  override def methodInstFullName: Option[String] = get().methodInstFullName
  override def methodFullName: String = get().methodFullName
  override def argumentIndex: Integer = get().argumentIndex
  override def dispatchType: String = get().dispatchType
  override def signature: String = get().signature
  override def typeFullName: String = get().typeFullName
  override def dynamicTypeHintFullName: List[String] = get().dynamicTypeHintFullName
  override def lineNumber: Option[Integer] = get().lineNumber
  override def columnNumber: Option[Integer] = get().columnNumber
  override def resolved: Option[JBoolean] = get().resolved
  override def depthFirstOrder: Option[Integer] = get().depthFirstOrder
  override def internalFlags: Option[Integer] = get().internalFlags
  
  override def _receiverOut(): JIterator[StoredNode] = get()._receiverOut
def _identifierViaReceiverOut: Option[Identifier] = get()._identifierViaReceiverOut
def _literalViaReceiverOut: Option[Literal] = get()._literalViaReceiverOut
def _callViaReceiverOut: Option[Call] = get()._callViaReceiverOut
def _methodRefViaReceiverOut: Option[MethodRef] = get()._methodRefViaReceiverOut
def _unknownViaReceiverOut: Iterator[Unknown] = get()._unknownViaReceiverOut
def _blockViaReceiverOut: Option[Block] = get()._blockViaReceiverOut
def _jumpTargetViaReceiverOut: Iterator[JumpTarget] = get()._jumpTargetViaReceiverOut
def _controlStructureViaReceiverOut: Iterator[ControlStructure] = get()._controlStructureViaReceiverOut
def _identifierViaCdgOut: Iterator[Identifier] = get()._identifierViaCdgOut
def _literalViaCdgOut: Iterator[Literal] = get()._literalViaCdgOut
def _blockViaCdgOut: Iterator[Block] = get()._blockViaCdgOut
def _methodReturnViaCdgOut: Iterator[MethodReturn] = get()._methodReturnViaCdgOut
def _fieldIdentifierViaCdgOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCdgOut
def _callViaCdgOut: Iterator[Call] = get()._callViaCdgOut
def _unknownViaCdgOut: Iterator[Unknown] = get()._unknownViaCdgOut
def _methodRefViaCdgOut: Iterator[MethodRef] = get()._methodRefViaCdgOut
def _returnViaCdgOut: Iterator[Return] = get()._returnViaCdgOut
def _controlStructureViaCdgOut: Iterator[ControlStructure] = get()._controlStructureViaCdgOut
override def _cdgOut(): JIterator[StoredNode] = get()._cdgOut
def _jumpTargetViaCdgOut: Iterator[JumpTarget] = get()._jumpTargetViaCdgOut
def _callViaArgumentOut: Iterator[Call] = get()._callViaArgumentOut
def _unknownViaArgumentOut: Iterator[Unknown] = get()._unknownViaArgumentOut
def _methodRefViaArgumentOut: Iterator[MethodRef] = get()._methodRefViaArgumentOut
def _jumpTargetViaArgumentOut: Iterator[JumpTarget] = get()._jumpTargetViaArgumentOut
override def _argumentOut(): JIterator[StoredNode] = get()._argumentOut
def _fieldIdentifierViaArgumentOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaArgumentOut
def _literalViaArgumentOut: Iterator[Literal] = get()._literalViaArgumentOut
def _blockViaArgumentOut: Iterator[Block] = get()._blockViaArgumentOut
def _controlStructureViaArgumentOut: Iterator[ControlStructure] = get()._controlStructureViaArgumentOut
def _identifierViaArgumentOut: Iterator[Identifier] = get()._identifierViaArgumentOut
def _memberViaRefOut: Iterator[Member] = get()._memberViaRefOut
override def _refOut(): JIterator[StoredNode] = get()._refOut
def _tagViaTaggedByOut: Iterator[Tag] = get()._tagViaTaggedByOut
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut
def _callViaReachingDefOut: Iterator[Call] = get()._callViaReachingDefOut
def _returnViaReachingDefOut: Iterator[Return] = get()._returnViaReachingDefOut
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut
def _methodViaCallOut: Iterator[Method] = get()._methodViaCallOut
override def _callOut(): JIterator[StoredNode] = get()._callOut
def _methodViaDynamicTypeOut: Iterator[Method] = get()._methodViaDynamicTypeOut
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = get()._typeDeclViaDynamicTypeOut
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut
def _returnViaCfgOut: Iterator[Return] = get()._returnViaCfgOut
def _callViaCfgOut: Iterator[Call] = get()._callViaCfgOut
override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut
def _unknownViaCfgOut: Iterator[Unknown] = get()._unknownViaCfgOut
def _literalViaCfgOut: Iterator[Literal] = get()._literalViaCfgOut
def _fieldIdentifierViaCfgOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCfgOut
def _blockViaCfgOut: Iterator[Block] = get()._blockViaCfgOut
def _jumpTargetViaCfgOut: Iterator[JumpTarget] = get()._jumpTargetViaCfgOut
def _identifierViaCfgOut: Iterator[Identifier] = get()._identifierViaCfgOut
def _controlStructureViaCfgOut: Iterator[ControlStructure] = get()._controlStructureViaCfgOut
def _methodRefViaCfgOut: Iterator[MethodRef] = get()._methodRefViaCfgOut
def _identifierViaPostDominateOut: Iterator[Identifier] = get()._identifierViaPostDominateOut
def _literalViaPostDominateOut: Iterator[Literal] = get()._literalViaPostDominateOut
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut
def _jumpTargetViaPostDominateOut: Iterator[JumpTarget] = get()._jumpTargetViaPostDominateOut
def _callViaPostDominateOut: Iterator[Call] = get()._callViaPostDominateOut
def _fieldIdentifierViaPostDominateOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaPostDominateOut
def _controlStructureViaPostDominateOut: Iterator[ControlStructure] = get()._controlStructureViaPostDominateOut
def _returnViaPostDominateOut: Iterator[Return] = get()._returnViaPostDominateOut
def _methodViaPostDominateOut: Iterator[Method] = get()._methodViaPostDominateOut
def _unknownViaPostDominateOut: Iterator[Unknown] = get()._unknownViaPostDominateOut
def _methodRefViaPostDominateOut: Iterator[MethodRef] = get()._methodRefViaPostDominateOut
def _blockViaPostDominateOut: Iterator[Block] = get()._blockViaPostDominateOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
def _identifierViaAstOut: Iterator[Identifier] = get()._identifierViaAstOut
def _methodRefViaAstOut: Iterator[MethodRef] = get()._methodRefViaAstOut
def _blockViaAstOut: Iterator[Block] = get()._blockViaAstOut
def _literalViaAstOut: Iterator[Literal] = get()._literalViaAstOut
def _controlStructureViaAstOut: Iterator[ControlStructure] = get()._controlStructureViaAstOut
def _returnViaAstOut: Iterator[Return] = get()._returnViaAstOut
def _fieldIdentifierViaAstOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaAstOut
def _callViaAstOut: Iterator[Call] = get()._callViaAstOut
def _unknownViaDominateOut: Iterator[Unknown] = get()._unknownViaDominateOut
def _jumpTargetViaDominateOut: Iterator[JumpTarget] = get()._jumpTargetViaDominateOut
def _identifierViaDominateOut: Iterator[Identifier] = get()._identifierViaDominateOut
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut
def _controlStructureViaDominateOut: Iterator[ControlStructure] = get()._controlStructureViaDominateOut
def _fieldIdentifierViaDominateOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDominateOut
def _methodRefViaDominateOut: Iterator[MethodRef] = get()._methodRefViaDominateOut
def _methodReturnViaDominateOut: Iterator[MethodReturn] = get()._methodReturnViaDominateOut
def _literalViaDominateOut: Iterator[Literal] = get()._literalViaDominateOut
def _returnViaDominateOut: Iterator[Return] = get()._returnViaDominateOut
def _blockViaDominateOut: Iterator[Block] = get()._blockViaDominateOut
def _callViaDominateOut: Iterator[Call] = get()._callViaDominateOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _typeViaEvalTypeOut: Iterator[Type] = get()._typeViaEvalTypeOut
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut
def _callViaReceiverIn: Option[Call] = get()._callViaReceiverIn
override def _receiverIn(): JIterator[StoredNode] = get()._receiverIn
def _methodRefViaCdgIn: Iterator[MethodRef] = get()._methodRefViaCdgIn
def _callViaCdgIn: Iterator[Call] = get()._callViaCdgIn
def _jumpTargetViaCdgIn: Iterator[JumpTarget] = get()._jumpTargetViaCdgIn
def _unknownViaCdgIn: Iterator[Unknown] = get()._unknownViaCdgIn
def _controlStructureViaCdgIn: Iterator[ControlStructure] = get()._controlStructureViaCdgIn
def _literalViaCdgIn: Iterator[Literal] = get()._literalViaCdgIn
def _identifierViaCdgIn: Iterator[Identifier] = get()._identifierViaCdgIn
def _fieldIdentifierViaCdgIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCdgIn
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn
def _blockViaCdgIn: Iterator[Block] = get()._blockViaCdgIn
def _returnViaArgumentIn: Option[Return] = get()._returnViaArgumentIn
def _callViaArgumentIn: Option[Call] = get()._callViaArgumentIn
override def _argumentIn(): JIterator[StoredNode] = get()._argumentIn
def _methodViaContainsIn: Iterator[Method] = get()._methodViaContainsIn
override def _containsIn(): JIterator[StoredNode] = get()._containsIn
def _controlStructureViaReachingDefIn: Iterator[ControlStructure] = get()._controlStructureViaReachingDefIn
def _blockViaReachingDefIn: Iterator[Block] = get()._blockViaReachingDefIn
def _unknownViaReachingDefIn: Iterator[Unknown] = get()._unknownViaReachingDefIn
def _callViaReachingDefIn: Iterator[Call] = get()._callViaReachingDefIn
def _methodParameterInViaReachingDefIn: Iterator[MethodParameterIn] = get()._methodParameterInViaReachingDefIn
override def _reachingDefIn(): JIterator[StoredNode] = get()._reachingDefIn
def _methodViaReachingDefIn: Iterator[Method] = get()._methodViaReachingDefIn
def _controlStructureViaConditionIn: Iterator[ControlStructure] = get()._controlStructureViaConditionIn
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn
def _callViaCfgIn: Iterator[Call] = get()._callViaCfgIn
def _methodViaCfgIn: Iterator[Method] = get()._methodViaCfgIn
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn
def _methodRefViaCfgIn: Iterator[MethodRef] = get()._methodRefViaCfgIn
def _fieldIdentifierViaCfgIn: Option[FieldIdentifier] = get()._fieldIdentifierViaCfgIn
def _unknownViaCfgIn: Iterator[Unknown] = get()._unknownViaCfgIn
def _jumpTargetViaCfgIn: Iterator[JumpTarget] = get()._jumpTargetViaCfgIn
def _blockViaCfgIn: Iterator[Block] = get()._blockViaCfgIn
def _controlStructureViaCfgIn: Iterator[ControlStructure] = get()._controlStructureViaCfgIn
def _identifierViaCfgIn: Iterator[Identifier] = get()._identifierViaCfgIn
def _literalViaCfgIn: Iterator[Literal] = get()._literalViaCfgIn
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn
def _fieldIdentifierViaPostDominateIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaPostDominateIn
def _identifierViaPostDominateIn: Iterator[Identifier] = get()._identifierViaPostDominateIn
def _blockViaPostDominateIn: Iterator[Block] = get()._blockViaPostDominateIn
def _returnViaPostDominateIn: Iterator[Return] = get()._returnViaPostDominateIn
def _callViaPostDominateIn: Iterator[Call] = get()._callViaPostDominateIn
def _literalViaPostDominateIn: Iterator[Literal] = get()._literalViaPostDominateIn
def _unknownViaPostDominateIn: Iterator[Unknown] = get()._unknownViaPostDominateIn
def _methodReturnViaPostDominateIn: Iterator[MethodReturn] = get()._methodReturnViaPostDominateIn
def _jumpTargetViaPostDominateIn: Iterator[JumpTarget] = get()._jumpTargetViaPostDominateIn
def _controlStructureViaPostDominateIn: Iterator[ControlStructure] = get()._controlStructureViaPostDominateIn
def _methodRefViaPostDominateIn: Iterator[MethodRef] = get()._methodRefViaPostDominateIn
def _unknownViaAstIn: Iterator[Unknown] = get()._unknownViaAstIn
def _blockViaAstIn: Iterator[Block] = get()._blockViaAstIn
def _controlStructureViaAstIn: ControlStructure = get()._controlStructureViaAstIn
def _returnViaAstIn: Iterator[Return] = get()._returnViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _callViaAstIn: Iterator[Call] = get()._callViaAstIn
def _literalViaDominateIn: Iterator[Literal] = get()._literalViaDominateIn
def _fieldIdentifierViaDominateIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDominateIn
def _blockViaDominateIn: Iterator[Block] = get()._blockViaDominateIn
def _identifierViaDominateIn: Iterator[Identifier] = get()._identifierViaDominateIn
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn
def _controlStructureViaDominateIn: Iterator[ControlStructure] = get()._controlStructureViaDominateIn
def _methodRefViaDominateIn: Iterator[MethodRef] = get()._methodRefViaDominateIn
def _unknownViaDominateIn: Iterator[Unknown] = get()._unknownViaDominateIn
def _callViaDominateIn: Iterator[Call] = get()._callViaDominateIn
def _methodViaDominateIn: Iterator[Method] = get()._methodViaDominateIn
def _returnViaDominateIn: Iterator[Return] = get()._returnViaDominateIn
def _jumpTargetViaDominateIn: Iterator[JumpTarget] = get()._jumpTargetViaDominateIn
def _sourceViaContainsNodeIn: Iterator[Source] = get()._sourceViaContainsNodeIn
def _callSiteViaContainsNodeIn: Iterator[CallSite] = get()._callSiteViaContainsNodeIn
def _sinkViaContainsNodeIn: Iterator[Sink] = get()._sinkViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _transformViaContainsNodeIn: Iterator[Transform] = get()._transformViaContainsNodeIn
def _callChainViaContainsNodeIn: Iterator[CallChain] = get()._callChainViaContainsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Call.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "order" 
case 4 => "methodInstFullName" 
case 5 => "methodFullName" 
case 6 => "argumentIndex" 
case 7 => "dispatchType" 
case 8 => "signature" 
case 9 => "typeFullName" 
case 10 => "dynamicTypeHintFullName" 
case 11 => "lineNumber" 
case 12 => "columnNumber" 
case 13 => "resolved" 
case 14 => "depthFirstOrder" 
case 15 => "internalFlags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => name
case 3 => order
case 4 => methodInstFullName
case 5 => methodFullName
case 6 => argumentIndex
case 7 => dispatchType
case 8 => signature
case 9 => typeFullName
case 10 => dynamicTypeHintFullName
case 11 => lineNumber
case 12 => columnNumber
case 13 => resolved
case 14 => depthFirstOrder
case 15 => internalFlags
    }

  override def productPrefix = "Call"
  override def productArity = 16
}

class CallDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with Expression with CallRepr with CallBase {

  override def layoutInformation: NodeLayoutInformation = Call.layoutInformation

private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order

private var _methodInstFullName: Option[String] = None
def methodInstFullName(): Option[String] = _methodInstFullName

private var _methodFullName: String = null
def methodFullName(): String = _methodFullName

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _dispatchType: String = null
def dispatchType(): String = _dispatchType

private var _signature: String = null
def signature(): String = _signature

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _resolved: Option[JBoolean] = None
def resolved(): Option[JBoolean] = _resolved

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }
methodInstFullName.map { value => properties.put("METHOD_INST_FULL_NAME", value) }
if (methodFullName != null) { properties.put("METHOD_FULL_NAME", methodFullName) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
if (dispatchType != null) { properties.put("DISPATCH_TYPE", dispatchType) }
if (signature != null) { properties.put("SIGNATURE", signature) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
resolved.map { value => properties.put("RESOLVED", value) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }

  properties
}

  def _blockViaReceiverOut: Option[Block] = _receiverOut.asScala.collect { case node: Block => node }.nextOption
override def _receiverOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _callViaReceiverOut: Option[Call] = _receiverOut.asScala.collect { case node: Call => node }.nextOption
def _jumpTargetViaReceiverOut: Iterator[JumpTarget] = _receiverOut.asScala.collect { case node: JumpTarget => node }
def _identifierViaReceiverOut: Option[Identifier] = _receiverOut.asScala.collect { case node: Identifier => node }.nextOption
def _methodRefViaReceiverOut: Option[MethodRef] = _receiverOut.asScala.collect { case node: MethodRef => node }.nextOption
def _literalViaReceiverOut: Option[Literal] = _receiverOut.asScala.collect { case node: Literal => node }.nextOption
def _controlStructureViaReceiverOut: Iterator[ControlStructure] = _receiverOut.asScala.collect { case node: ControlStructure => node }
def _unknownViaReceiverOut: Iterator[Unknown] = _receiverOut.asScala.collect { case node: Unknown => node }
def _callViaCdgOut: Iterator[Call] = _cdgOut.asScala.collect { case node: Call => node }
def _blockViaCdgOut: Iterator[Block] = _cdgOut.asScala.collect { case node: Block => node }
def _fieldIdentifierViaCdgOut: Iterator[FieldIdentifier] = _cdgOut.asScala.collect { case node: FieldIdentifier => node }
def _controlStructureViaCdgOut: Iterator[ControlStructure] = _cdgOut.asScala.collect { case node: ControlStructure => node }
def _identifierViaCdgOut: Iterator[Identifier] = _cdgOut.asScala.collect { case node: Identifier => node }
def _literalViaCdgOut: Iterator[Literal] = _cdgOut.asScala.collect { case node: Literal => node }
def _returnViaCdgOut: Iterator[Return] = _cdgOut.asScala.collect { case node: Return => node }
def _methodReturnViaCdgOut: Iterator[MethodReturn] = _cdgOut.asScala.collect { case node: MethodReturn => node }
def _methodRefViaCdgOut: Iterator[MethodRef] = _cdgOut.asScala.collect { case node: MethodRef => node }
override def _cdgOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _jumpTargetViaCdgOut: Iterator[JumpTarget] = _cdgOut.asScala.collect { case node: JumpTarget => node }
def _unknownViaCdgOut: Iterator[Unknown] = _cdgOut.asScala.collect { case node: Unknown => node }
def _identifierViaArgumentOut: Iterator[Identifier] = _argumentOut.asScala.collect { case node: Identifier => node }
def _blockViaArgumentOut: Iterator[Block] = _argumentOut.asScala.collect { case node: Block => node }
def _jumpTargetViaArgumentOut: Iterator[JumpTarget] = _argumentOut.asScala.collect { case node: JumpTarget => node }
def _controlStructureViaArgumentOut: Iterator[ControlStructure] = _argumentOut.asScala.collect { case node: ControlStructure => node }
def _fieldIdentifierViaArgumentOut: Iterator[FieldIdentifier] = _argumentOut.asScala.collect { case node: FieldIdentifier => node }
def _unknownViaArgumentOut: Iterator[Unknown] = _argumentOut.asScala.collect { case node: Unknown => node }
override def _argumentOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _methodRefViaArgumentOut: Iterator[MethodRef] = _argumentOut.asScala.collect { case node: MethodRef => node }
def _literalViaArgumentOut: Iterator[Literal] = _argumentOut.asScala.collect { case node: Literal => node }
def _callViaArgumentOut: Iterator[Call] = _argumentOut.asScala.collect { case node: Call => node }
def _memberViaRefOut: Iterator[Member] = _refOut.asScala.collect { case node: Member => node }
override def _refOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _tagViaTaggedByOut: Iterator[Tag] = _taggedByOut.asScala.collect { case node: Tag => node }
override def _taggedByOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _callViaReachingDefOut: Iterator[Call] = _reachingDefOut.asScala.collect { case node: Call => node }
def _returnViaReachingDefOut: Iterator[Return] = _reachingDefOut.asScala.collect { case node: Return => node }
override def _reachingDefOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _methodViaCallOut: Iterator[Method] = _callOut.asScala.collect { case node: Method => node }
override def _callOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _methodViaDynamicTypeOut: Iterator[Method] = _dynamicTypeOut.asScala.collect { case node: Method => node }
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = _dynamicTypeOut.asScala.collect { case node: TypeDecl => node }
override def _dynamicTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
def _literalViaCfgOut: Iterator[Literal] = _cfgOut.asScala.collect { case node: Literal => node }
def _unknownViaCfgOut: Iterator[Unknown] = _cfgOut.asScala.collect { case node: Unknown => node }
override def _cfgOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
def _identifierViaCfgOut: Iterator[Identifier] = _cfgOut.asScala.collect { case node: Identifier => node }
def _methodRefViaCfgOut: Iterator[MethodRef] = _cfgOut.asScala.collect { case node: MethodRef => node }
def _jumpTargetViaCfgOut: Iterator[JumpTarget] = _cfgOut.asScala.collect { case node: JumpTarget => node }
def _fieldIdentifierViaCfgOut: Iterator[FieldIdentifier] = _cfgOut.asScala.collect { case node: FieldIdentifier => node }
def _returnViaCfgOut: Iterator[Return] = _cfgOut.asScala.collect { case node: Return => node }
def _blockViaCfgOut: Iterator[Block] = _cfgOut.asScala.collect { case node: Block => node }
def _controlStructureViaCfgOut: Iterator[ControlStructure] = _cfgOut.asScala.collect { case node: ControlStructure => node }
def _callViaCfgOut: Iterator[Call] = _cfgOut.asScala.collect { case node: Call => node }
def _jumpTargetViaPostDominateOut: Iterator[JumpTarget] = _postDominateOut.asScala.collect { case node: JumpTarget => node }
def _identifierViaPostDominateOut: Iterator[Identifier] = _postDominateOut.asScala.collect { case node: Identifier => node }
override def _postDominateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
def _callViaPostDominateOut: Iterator[Call] = _postDominateOut.asScala.collect { case node: Call => node }
def _methodRefViaPostDominateOut: Iterator[MethodRef] = _postDominateOut.asScala.collect { case node: MethodRef => node }
def _controlStructureViaPostDominateOut: Iterator[ControlStructure] = _postDominateOut.asScala.collect { case node: ControlStructure => node }
def _returnViaPostDominateOut: Iterator[Return] = _postDominateOut.asScala.collect { case node: Return => node }
def _literalViaPostDominateOut: Iterator[Literal] = _postDominateOut.asScala.collect { case node: Literal => node }
def _unknownViaPostDominateOut: Iterator[Unknown] = _postDominateOut.asScala.collect { case node: Unknown => node }
def _fieldIdentifierViaPostDominateOut: Iterator[FieldIdentifier] = _postDominateOut.asScala.collect { case node: FieldIdentifier => node }
def _methodViaPostDominateOut: Iterator[Method] = _postDominateOut.asScala.collect { case node: Method => node }
def _blockViaPostDominateOut: Iterator[Block] = _postDominateOut.asScala.collect { case node: Block => node }
def _methodRefViaAstOut: Iterator[MethodRef] = _astOut.asScala.collect { case node: MethodRef => node }
def _literalViaAstOut: Iterator[Literal] = _astOut.asScala.collect { case node: Literal => node }
def _fieldIdentifierViaAstOut: Iterator[FieldIdentifier] = _astOut.asScala.collect { case node: FieldIdentifier => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
def _blockViaAstOut: Iterator[Block] = _astOut.asScala.collect { case node: Block => node }
def _identifierViaAstOut: Iterator[Identifier] = _astOut.asScala.collect { case node: Identifier => node }
def _controlStructureViaAstOut: Iterator[ControlStructure] = _astOut.asScala.collect { case node: ControlStructure => node }
def _callViaAstOut: Iterator[Call] = _astOut.asScala.collect { case node: Call => node }
def _returnViaAstOut: Iterator[Return] = _astOut.asScala.collect { case node: Return => node }
def _literalViaDominateOut: Iterator[Literal] = _dominateOut.asScala.collect { case node: Literal => node }
def _methodReturnViaDominateOut: Iterator[MethodReturn] = _dominateOut.asScala.collect { case node: MethodReturn => node }
def _unknownViaDominateOut: Iterator[Unknown] = _dominateOut.asScala.collect { case node: Unknown => node }
def _controlStructureViaDominateOut: Iterator[ControlStructure] = _dominateOut.asScala.collect { case node: ControlStructure => node }
def _jumpTargetViaDominateOut: Iterator[JumpTarget] = _dominateOut.asScala.collect { case node: JumpTarget => node }
def _methodRefViaDominateOut: Iterator[MethodRef] = _dominateOut.asScala.collect { case node: MethodRef => node }
override def _dominateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
def _returnViaDominateOut: Iterator[Return] = _dominateOut.asScala.collect { case node: Return => node }
def _fieldIdentifierViaDominateOut: Iterator[FieldIdentifier] = _dominateOut.asScala.collect { case node: FieldIdentifier => node }
def _identifierViaDominateOut: Iterator[Identifier] = _dominateOut.asScala.collect { case node: Identifier => node }
def _callViaDominateOut: Iterator[Call] = _dominateOut.asScala.collect { case node: Call => node }
def _blockViaDominateOut: Iterator[Block] = _dominateOut.asScala.collect { case node: Block => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
def _typeViaEvalTypeOut: Iterator[Type] = _evalTypeOut.asScala.collect { case node: Type => node }
override def _evalTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
def _callViaReceiverIn: Option[Call] = _receiverIn.asScala.collect { case node: Call => node }.nextOption
override def _receiverIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
def _identifierViaCdgIn: Iterator[Identifier] = _cdgIn.asScala.collect { case node: Identifier => node }
def _literalViaCdgIn: Iterator[Literal] = _cdgIn.asScala.collect { case node: Literal => node }
def _callViaCdgIn: Iterator[Call] = _cdgIn.asScala.collect { case node: Call => node }
def _jumpTargetViaCdgIn: Iterator[JumpTarget] = _cdgIn.asScala.collect { case node: JumpTarget => node }
override def _cdgIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]
def _controlStructureViaCdgIn: Iterator[ControlStructure] = _cdgIn.asScala.collect { case node: ControlStructure => node }
def _blockViaCdgIn: Iterator[Block] = _cdgIn.asScala.collect { case node: Block => node }
def _unknownViaCdgIn: Iterator[Unknown] = _cdgIn.asScala.collect { case node: Unknown => node }
def _methodRefViaCdgIn: Iterator[MethodRef] = _cdgIn.asScala.collect { case node: MethodRef => node }
def _fieldIdentifierViaCdgIn: Iterator[FieldIdentifier] = _cdgIn.asScala.collect { case node: FieldIdentifier => node }
def _returnViaArgumentIn: Option[Return] = _argumentIn.asScala.collect { case node: Return => node }.nextOption
def _callViaArgumentIn: Option[Call] = _argumentIn.asScala.collect { case node: Call => node }.nextOption
override def _argumentIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(16).asInstanceOf[JIterator[StoredNode]]
def _methodViaContainsIn: Iterator[Method] = _containsIn.asScala.collect { case node: Method => node }
override def _containsIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(17).asInstanceOf[JIterator[StoredNode]]
def _unknownViaReachingDefIn: Iterator[Unknown] = _reachingDefIn.asScala.collect { case node: Unknown => node }
def _methodViaReachingDefIn: Iterator[Method] = _reachingDefIn.asScala.collect { case node: Method => node }
def _controlStructureViaReachingDefIn: Iterator[ControlStructure] = _reachingDefIn.asScala.collect { case node: ControlStructure => node }
def _methodParameterInViaReachingDefIn: Iterator[MethodParameterIn] = _reachingDefIn.asScala.collect { case node: MethodParameterIn => node }
def _callViaReachingDefIn: Iterator[Call] = _reachingDefIn.asScala.collect { case node: Call => node }
override def _reachingDefIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(18).asInstanceOf[JIterator[StoredNode]]
def _blockViaReachingDefIn: Iterator[Block] = _reachingDefIn.asScala.collect { case node: Block => node }
def _controlStructureViaConditionIn: Iterator[ControlStructure] = _conditionIn.asScala.collect { case node: ControlStructure => node }
override def _conditionIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(19).asInstanceOf[JIterator[StoredNode]]
def _methodViaCfgIn: Iterator[Method] = _cfgIn.asScala.collect { case node: Method => node }
def _controlStructureViaCfgIn: Iterator[ControlStructure] = _cfgIn.asScala.collect { case node: ControlStructure => node }
override def _cfgIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(20).asInstanceOf[JIterator[StoredNode]]
def _callViaCfgIn: Iterator[Call] = _cfgIn.asScala.collect { case node: Call => node }
def _unknownViaCfgIn: Iterator[Unknown] = _cfgIn.asScala.collect { case node: Unknown => node }
def _fieldIdentifierViaCfgIn: Option[FieldIdentifier] = _cfgIn.asScala.collect { case node: FieldIdentifier => node }.nextOption
def _methodRefViaCfgIn: Iterator[MethodRef] = _cfgIn.asScala.collect { case node: MethodRef => node }
def _literalViaCfgIn: Iterator[Literal] = _cfgIn.asScala.collect { case node: Literal => node }
def _jumpTargetViaCfgIn: Iterator[JumpTarget] = _cfgIn.asScala.collect { case node: JumpTarget => node }
def _identifierViaCfgIn: Iterator[Identifier] = _cfgIn.asScala.collect { case node: Identifier => node }
def _blockViaCfgIn: Iterator[Block] = _cfgIn.asScala.collect { case node: Block => node }
def _blockViaPostDominateIn: Iterator[Block] = _postDominateIn.asScala.collect { case node: Block => node }
def _controlStructureViaPostDominateIn: Iterator[ControlStructure] = _postDominateIn.asScala.collect { case node: ControlStructure => node }
def _callViaPostDominateIn: Iterator[Call] = _postDominateIn.asScala.collect { case node: Call => node }
def _unknownViaPostDominateIn: Iterator[Unknown] = _postDominateIn.asScala.collect { case node: Unknown => node }
override def _postDominateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(21).asInstanceOf[JIterator[StoredNode]]
def _fieldIdentifierViaPostDominateIn: Iterator[FieldIdentifier] = _postDominateIn.asScala.collect { case node: FieldIdentifier => node }
def _identifierViaPostDominateIn: Iterator[Identifier] = _postDominateIn.asScala.collect { case node: Identifier => node }
def _literalViaPostDominateIn: Iterator[Literal] = _postDominateIn.asScala.collect { case node: Literal => node }
def _returnViaPostDominateIn: Iterator[Return] = _postDominateIn.asScala.collect { case node: Return => node }
def _methodRefViaPostDominateIn: Iterator[MethodRef] = _postDominateIn.asScala.collect { case node: MethodRef => node }
def _methodReturnViaPostDominateIn: Iterator[MethodReturn] = _postDominateIn.asScala.collect { case node: MethodReturn => node }
def _jumpTargetViaPostDominateIn: Iterator[JumpTarget] = _postDominateIn.asScala.collect { case node: JumpTarget => node }
def _returnViaAstIn: Iterator[Return] = _astIn.asScala.collect { case node: Return => node }
def _blockViaAstIn: Iterator[Block] = _astIn.asScala.collect { case node: Block => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(22).asInstanceOf[JIterator[StoredNode]]
def _callViaAstIn: Iterator[Call] = _astIn.asScala.collect { case node: Call => node }
def _unknownViaAstIn: Iterator[Unknown] = _astIn.asScala.collect { case node: Unknown => node }
def _controlStructureViaAstIn: ControlStructure = _astIn.asScala.collect { case node: ControlStructure => node }.next
override def _dominateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(23).asInstanceOf[JIterator[StoredNode]]
def _unknownViaDominateIn: Iterator[Unknown] = _dominateIn.asScala.collect { case node: Unknown => node }
def _jumpTargetViaDominateIn: Iterator[JumpTarget] = _dominateIn.asScala.collect { case node: JumpTarget => node }
def _methodRefViaDominateIn: Iterator[MethodRef] = _dominateIn.asScala.collect { case node: MethodRef => node }
def _fieldIdentifierViaDominateIn: Iterator[FieldIdentifier] = _dominateIn.asScala.collect { case node: FieldIdentifier => node }
def _methodViaDominateIn: Iterator[Method] = _dominateIn.asScala.collect { case node: Method => node }
def _returnViaDominateIn: Iterator[Return] = _dominateIn.asScala.collect { case node: Return => node }
def _identifierViaDominateIn: Iterator[Identifier] = _dominateIn.asScala.collect { case node: Identifier => node }
def _blockViaDominateIn: Iterator[Block] = _dominateIn.asScala.collect { case node: Block => node }
def _callViaDominateIn: Iterator[Call] = _dominateIn.asScala.collect { case node: Call => node }
def _controlStructureViaDominateIn: Iterator[ControlStructure] = _dominateIn.asScala.collect { case node: ControlStructure => node }
def _literalViaDominateIn: Iterator[Literal] = _dominateIn.asScala.collect { case node: Literal => node }
def _sourceViaContainsNodeIn: Iterator[Source] = _containsNodeIn.asScala.collect { case node: Source => node }
def _transformViaContainsNodeIn: Iterator[Transform] = _containsNodeIn.asScala.collect { case node: Transform => node }
def _callChainViaContainsNodeIn: Iterator[CallChain] = _containsNodeIn.asScala.collect { case node: CallChain => node }
def _sinkViaContainsNodeIn: Iterator[Sink] = _containsNodeIn.asScala.collect { case node: Sink => node }
def _callSiteViaContainsNodeIn: Iterator[CallSite] = _containsNodeIn.asScala.collect { case node: CallSite => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(24).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Call.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "name" 
case 3 => "order" 
case 4 => "methodInstFullName" 
case 5 => "methodFullName" 
case 6 => "argumentIndex" 
case 7 => "dispatchType" 
case 8 => "signature" 
case 9 => "typeFullName" 
case 10 => "dynamicTypeHintFullName" 
case 11 => "lineNumber" 
case 12 => "columnNumber" 
case 13 => "resolved" 
case 14 => "depthFirstOrder" 
case 15 => "internalFlags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => code
case 2 => name
case 3 => order
case 4 => methodInstFullName
case 5 => methodFullName
case 6 => argumentIndex
case 7 => dispatchType
case 8 => signature
case 9 => typeFullName
case 10 => dynamicTypeHintFullName
case 11 => lineNumber
case 12 => columnNumber
case 13 => resolved
case 14 => depthFirstOrder
case 15 => internalFlags
    }

  override def productPrefix = "Call"
  override def productArity = 16

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[CallDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "CODE" => if(this._code == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._code.asInstanceOf[A])
  case "NAME" => if(this._name == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._name.asInstanceOf[A])
  case "ORDER" => if(this._order == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._order.asInstanceOf[A])
  case "METHOD_INST_FULL_NAME" => if(this._methodInstFullName.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._methodInstFullName.get.asInstanceOf[A])
  case "METHOD_FULL_NAME" => if(this._methodFullName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._methodFullName.asInstanceOf[A])
  case "ARGUMENT_INDEX" => if(this._argumentIndex == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._argumentIndex.asInstanceOf[A])
  case "DISPATCH_TYPE" => if(this._dispatchType == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._dispatchType.asInstanceOf[A])
  case "SIGNATURE" => if(this._signature == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._signature.asInstanceOf[A])
  case "TYPE_FULL_NAME" => if(this._typeFullName == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._typeFullName.asInstanceOf[A])
  case "DYNAMIC_TYPE_HINT_FULL_NAME" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "LINE_NUMBER" => if(this._lineNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._lineNumber.get.asInstanceOf[A])
  case "COLUMN_NUMBER" => if(this._columnNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._columnNumber.get.asInstanceOf[A])
  case "RESOLVED" => if(this._resolved.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._resolved.get.asInstanceOf[A])
  case "DEPTH_FIRST_ORDER" => if(this._depthFirstOrder.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._depthFirstOrder.get.asInstanceOf[A])
  case "INTERNAL_FLAGS" => if(this._internalFlags.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._internalFlags.get.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "CODE" => this._code
  case "NAME" => this._name
  case "ORDER" => this._order
  case "METHOD_INST_FULL_NAME" => this._methodInstFullName.orNull
  case "METHOD_FULL_NAME" => this._methodFullName
  case "ARGUMENT_INDEX" => this._argumentIndex
  case "DISPATCH_TYPE" => this._dispatchType
  case "SIGNATURE" => this._signature
  case "TYPE_FULL_NAME" => this._typeFullName
  case "DYNAMIC_TYPE_HINT_FULL_NAME" => this._dynamicTypeHintFullName
  case "LINE_NUMBER" => this._lineNumber.orNull
  case "COLUMN_NUMBER" => this._columnNumber.orNull
  case "RESOLVED" => this._resolved.orNull
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder.orNull
  case "INTERNAL_FLAGS" => this._internalFlags.orNull

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "CODE" => this._code = value.asInstanceOf[String]
  case "NAME" => this._name = value.asInstanceOf[String]
  case "ORDER" => this._order = value.asInstanceOf[Integer]
  case "METHOD_INST_FULL_NAME" => this._methodInstFullName = value match {
    case null | None => None
    case someVal:String => Some(someVal)
  }
  case "METHOD_FULL_NAME" => this._methodFullName = value.asInstanceOf[String]
  case "ARGUMENT_INDEX" => this._argumentIndex = value.asInstanceOf[Integer]
  case "DISPATCH_TYPE" => this._dispatchType = value.asInstanceOf[String]
  case "SIGNATURE" => this._signature = value.asInstanceOf[String]
  case "TYPE_FULL_NAME" => this._typeFullName = value.asInstanceOf[String]
  case "DYNAMIC_TYPE_HINT_FULL_NAME" => this._dynamicTypeHintFullName = value match {
    case null | None => Nil
    case someVal:String => this._dynamicTypeHintFullName :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[String]]
  }
  case "LINE_NUMBER" => this._lineNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "COLUMN_NUMBER" => this._columnNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "RESOLVED" => this._resolved = value match {
    case null | None => None
    case someVal:JBoolean => Some(someVal)
  }
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "INTERNAL_FLAGS" => this._internalFlags = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewCall]
   this._code = other.code
   this._name = other.name
   this._order = other.order
   this._methodInstFullName = other.methodInstFullName
   this._methodFullName = other.methodFullName
   this._argumentIndex = other.argumentIndex
   this._dispatchType = other.dispatchType
   this._signature = other.signature
   this._typeFullName = other.typeFullName
   this._dynamicTypeHintFullName = other.dynamicTypeHintFullName
   this._lineNumber = other.lineNumber
   this._columnNumber = other.columnNumber
   this._resolved = other.resolved
   this._depthFirstOrder = other.depthFirstOrder
   this._internalFlags = other.internalFlags


}

}
