package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object CallChain {
  def apply(graph: OdbGraph, id: Long) = new CallChain(graph, id)

  val Label = "CALL_CHAIN"
  val LabelId: Int = 204

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("methods", "calls")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[CallChainDb] {
    override val forLabel = CallChain.Label
    override val forLabelId = CallChain.LabelId

    override def createNode(ref: NodeRef[CallChainDb]) =
      new CallChainDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = CallChain(graph, id)
  }
}

trait CallChainBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def methods: List[MethodBase]
def calls: List[CallBase]
}

class CallChain(graph: OdbGraph, id: Long) extends NodeRef[CallChainDb](graph, id)
  with CallChainBase
  with StoredNode
   {
  
    def methods = get().methods
  def calls = get().calls
  def _callViaContainsNodeOut: Iterator[Call] = get()._callViaContainsNodeOut
def _methodViaContainsNodeOut: Iterator[Method] = get()._methodViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _transformViaContainsNodeIn: Iterator[Transform] = get()._transformViaContainsNodeIn
def _readViaContainsNodeIn: Iterator[Read] = get()._readViaContainsNodeIn
def _writeViaContainsNodeIn: Iterator[Write] = get()._writeViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    CallChain.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "methods" 
case 2 => "calls" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => methods
case 2 => calls
    }

  override def productPrefix = "CallChain"
  override def productArity = 3
}

class CallChainDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with CallChainBase {

  override def layoutInformation: NodeLayoutInformation = CallChain.layoutInformation



private var _methods: List[Method] = Nil
def methods: List[Method] = this._methods


private var _calls: List[Call] = Nil
def calls: List[Call] = this._calls


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

  if (this._methods.nonEmpty) { properties.put("methods", this._methods.asJava) }
  if (this._calls.nonEmpty) { properties.put("calls", this._calls.asJava) }
  properties
}

  def _callViaContainsNodeOut: Iterator[Call] = _containsNodeOut.asScala.collect { case node: Call => node }
def _methodViaContainsNodeOut: Iterator[Method] = _containsNodeOut.asScala.collect { case node: Method => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _transformViaContainsNodeIn: Iterator[Transform] = _containsNodeIn.asScala.collect { case node: Transform => node }
def _readViaContainsNodeIn: Iterator[Read] = _containsNodeIn.asScala.collect { case node: Read => node }
def _writeViaContainsNodeIn: Iterator[Write] = _containsNodeIn.asScala.collect { case node: Write => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    CallChain.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "methods" 
case 2 => "calls" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => methods
case 2 => calls
    }

  override def productPrefix = "CallChain"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[CallChainDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {

  case "methods" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "calls" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {

  case "methods" => this._methods
  case "calls" => this._calls
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {

  case "methods" => this._methods = value match {
    case null | None => Nil
    case someVal:Method => this._methods :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Method]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Method]]
  }
  case "calls" => this._calls = value match {
    case null | None => Nil
    case someVal:Call => this._calls :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Call]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Call]]
  }
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewCallChain]

  this._methods = if(other.methods == null) Nil else other.methods.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Method]
    case oldNode:StoredNode => oldNode.asInstanceOf[Method]
    case _ => throw new MatchError("unreachable")
  }}
  this._calls = if(other.calls == null) Nil else other.calls.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Call]
    case oldNode:StoredNode => oldNode.asInstanceOf[Call]
    case _ => throw new MatchError("unreachable")
  }}

}

}
