package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object ConfigFile {
  def apply(graph: OdbGraph, id: Long) = new ConfigFile(graph, id)

  val Label = "CONFIG_FILE"
  val LabelId: Int = 50

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Contains.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val all: Set[String] = Set("NAME", "CONTENT")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS","CONTAINS_NODE")
  }

  val factory = new NodeFactory[ConfigFileDb] {
    override val forLabel = ConfigFile.Label
    override val forLabelId = ConfigFile.LabelId

    override def createNode(ref: NodeRef[ConfigFileDb]) =
      new ConfigFileDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = ConfigFile(graph, id)
  }
}

trait ConfigFileBase extends CpgNode  with HasName with HasContent {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class ConfigFile(graph: OdbGraph, id: Long) extends NodeRef[ConfigFileDb](graph, id)
  with ConfigFileBase
  with StoredNode
   {
    override def name: String = get().name
  override def content: String = get().content
  
  def _domNodeViaContainsOut: Iterator[DomNode] = get()._domNodeViaContainsOut
override def _containsOut(): JIterator[StoredNode] = get()._containsOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ConfigFile.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "content" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => content
    }

  override def productPrefix = "ConfigFile"
  override def productArity = 3
}

class ConfigFileDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with ConfigFileBase {

  override def layoutInformation: NodeLayoutInformation = ConfigFile.layoutInformation

private var _name: String = null
def name(): String = _name

private var _content: String = null
def content(): String = _content


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
if (content != null) { properties.put("CONTENT", content) }

  properties
}

  def _domNodeViaContainsOut: Iterator[DomNode] = _containsOut.asScala.collect { case node: DomNode => node }
override def _containsOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    ConfigFile.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "content" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => content
    }

  override def productPrefix = "ConfigFile"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ConfigFileDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "NAME" => if(this._name == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._name.asInstanceOf[A])
  case "CONTENT" => if(this._content == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._content.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "NAME" => this._name
  case "CONTENT" => this._content

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "NAME" => this._name = value.asInstanceOf[String]
  case "CONTENT" => this._content = value.asInstanceOf[String]

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewConfigFile]
   this._name = other.name
   this._content = other.content


}

}
