package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object DomNode {
  def apply(graph: OdbGraph, id: Long) = new DomNode(graph, id)

  val Label = "DOM_NODE"
  val LabelId: Int = 600

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.Contains.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("NAME", "attributes")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS","CONTAINS_NODE")
    val Out: Array[String] = Array("AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[DomNodeDb] {
    override val forLabel = DomNode.Label
    override val forLabelId = DomNode.LabelId

    override def createNode(ref: NodeRef[DomNodeDb]) =
      new DomNodeDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = DomNode(graph, id)
  }
}

trait DomNodeBase extends CpgNode  with HasName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def attributes: List[DomAttributeBase]
}

class DomNode(graph: OdbGraph, id: Long) extends NodeRef[DomNodeDb](graph, id)
  with DomNodeBase
  with StoredNode
   {
    override def name: String = get().name
    def attributes = get().attributes
  def _domNodeViaAstOut: Iterator[DomNode] = get()._domNodeViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
def _domAttributeViaContainsNodeOut: Iterator[DomAttribute] = get()._domAttributeViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _domNodeViaAstIn: Iterator[DomNode] = get()._domNodeViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _configFileViaContainsIn: Iterator[ConfigFile] = get()._configFileViaContainsIn
override def _containsIn(): JIterator[StoredNode] = get()._containsIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    DomNode.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "attributes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => attributes
    }

  override def productPrefix = "DomNode"
  override def productArity = 3
}

class DomNodeDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with DomNodeBase {

  override def layoutInformation: NodeLayoutInformation = DomNode.layoutInformation

private var _name: String = null
def name(): String = _name

private var _attributes: List[DomAttribute] = Nil
def attributes: List[DomAttribute] = this._attributes


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
  if (this._attributes.nonEmpty) { properties.put("attributes", this._attributes.asJava) }
  properties
}

  def _domNodeViaAstOut: Iterator[DomNode] = _astOut.asScala.collect { case node: DomNode => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _domAttributeViaContainsNodeOut: Iterator[DomAttribute] = _containsNodeOut.asScala.collect { case node: DomAttribute => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _domNodeViaAstIn: Iterator[DomNode] = _astIn.asScala.collect { case node: DomNode => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _configFileViaContainsIn: Iterator[ConfigFile] = _containsIn.asScala.collect { case node: ConfigFile => node }
override def _containsIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    DomNode.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "attributes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => attributes
    }

  override def productPrefix = "DomNode"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[DomNodeDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "NAME" => if(this._name == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._name.asInstanceOf[A])
  case "attributes" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "NAME" => this._name
  case "attributes" => this._attributes
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "NAME" => this._name = value.asInstanceOf[String]
  case "attributes" => this._attributes = value match {
    case null | None => Nil
    case someVal:DomAttribute => this._attributes :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[DomAttribute]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[DomAttribute]]
  }
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewDomNode]
   this._name = other.name
  this._attributes = if(other.attributes == null) Nil else other.attributes.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[DomAttribute]
    case oldNode:StoredNode => oldNode.asInstanceOf[DomAttribute]
    case _ => throw new MatchError("unreachable")
  }}

}

}
