package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object File {
  def apply(graph: OdbGraph, id: Long) = new File(graph, id)

  val Label = "FILE"
  val LabelId: Int = 38

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ast.layoutInformation, edges.TaggedBy.layoutInformation, edges.Contains.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.SourceFile.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("NAME", "ORDER")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("SOURCE_FILE","CONTAINS_NODE")
    val Out: Array[String] = Array("AST","TAGGED_BY","CONTAINS","CONTAINS_NODE")
  }

  val factory = new NodeFactory[FileDb] {
    override val forLabel = File.Label
    override val forLabelId = File.LabelId

    override def createNode(ref: NodeRef[FileDb]) =
      new FileDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = File(graph, id)
  }
}

trait FileBase extends CpgNode with AstNodeBase with HasName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class File(graph: OdbGraph, id: Long) extends NodeRef[FileDb](graph, id)
  with FileBase
  with StoredNode
  with AstNode {
    override def name: String = get().name
  override def order: Integer = get().order
  
  def _commentViaAstOut: Iterator[Comment] = get()._commentViaAstOut
def _namespaceBlockViaAstOut: Iterator[NamespaceBlock] = get()._namespaceBlockViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
def _tagViaTaggedByOut: Iterator[Tag] = get()._tagViaTaggedByOut
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut
def _methodViaContainsOut: Iterator[Method] = get()._methodViaContainsOut
def _typeDeclViaContainsOut: Iterator[TypeDecl] = get()._typeDeclViaContainsOut
override def _containsOut(): JIterator[StoredNode] = get()._containsOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodViaSourceFileIn: Iterator[Method] = get()._methodViaSourceFileIn
def _namespaceBlockViaSourceFileIn: Iterator[NamespaceBlock] = get()._namespaceBlockViaSourceFileIn
def _typeDeclViaSourceFileIn: Iterator[TypeDecl] = get()._typeDeclViaSourceFileIn
override def _sourceFileIn(): JIterator[StoredNode] = get()._sourceFileIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    File.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => order
    }

  override def productPrefix = "File"
  override def productArity = 3
}

class FileDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with AstNode with FileBase {

  override def layoutInformation: NodeLayoutInformation = File.layoutInformation

private var _name: String = null
def name(): String = _name

private var _order: Integer = null
def order(): Integer = _order


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
if (order != null) { properties.put("ORDER", order) }

  properties
}

  def _commentViaAstOut: Iterator[Comment] = _astOut.asScala.collect { case node: Comment => node }
def _namespaceBlockViaAstOut: Iterator[NamespaceBlock] = _astOut.asScala.collect { case node: NamespaceBlock => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _tagViaTaggedByOut: Iterator[Tag] = _taggedByOut.asScala.collect { case node: Tag => node }
override def _taggedByOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodViaContainsOut: Iterator[Method] = _containsOut.asScala.collect { case node: Method => node }
def _typeDeclViaContainsOut: Iterator[TypeDecl] = _containsOut.asScala.collect { case node: TypeDecl => node }
override def _containsOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _methodViaSourceFileIn: Iterator[Method] = _sourceFileIn.asScala.collect { case node: Method => node }
def _namespaceBlockViaSourceFileIn: Iterator[NamespaceBlock] = _sourceFileIn.asScala.collect { case node: NamespaceBlock => node }
def _typeDeclViaSourceFileIn: Iterator[TypeDecl] = _sourceFileIn.asScala.collect { case node: TypeDecl => node }
override def _sourceFileIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    File.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
case 2 => order
    }

  override def productPrefix = "File"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FileDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "NAME" => if(this._name == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._name.asInstanceOf[A])
  case "ORDER" => if(this._order == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._order.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "NAME" => this._name
  case "ORDER" => this._order

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "NAME" => this._name = value.asInstanceOf[String]
  case "ORDER" => this._order = value.asInstanceOf[Integer]

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewFile]
   this._name = other.name
   this._order = other.order


}

}
