package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Finding {
  def apply(graph: OdbGraph, id: Long) = new Finding(graph, id)

  val Label = "FINDING"
  val LabelId: Int = 214

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val all: Set[String] = Set("evidence", "keyValuePairs")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[FindingDb] {
    override val forLabel = Finding.Label
    override val forLabelId = Finding.LabelId

    override def createNode(ref: NodeRef[FindingDb]) =
      new FindingDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Finding(graph, id)
  }
}

trait FindingBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def evidence: List[CpgNode]
def keyValuePairs: List[KeyValuePairBase]
}

class Finding(graph: OdbGraph, id: Long) extends NodeRef[FindingDb](graph, id)
  with FindingBase
  with StoredNode
   {
  
    def evidence = get().evidence
  def keyValuePairs = get().keyValuePairs
  def _keyValuePairViaContainsNodeOut: Iterator[KeyValuePair] = get()._keyValuePairViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Finding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "evidence" 
case 2 => "keyValuePairs" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => evidence
case 2 => keyValuePairs
    }

  override def productPrefix = "Finding"
  override def productArity = 3
}

class FindingDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with FindingBase {

  override def layoutInformation: NodeLayoutInformation = Finding.layoutInformation



private var _evidence: List[CpgNode] = Nil
def evidence: List[CpgNode] = this._evidence


private var _keyValuePairs: List[KeyValuePair] = Nil
def keyValuePairs: List[KeyValuePair] = this._keyValuePairs


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

  if (this._evidence.nonEmpty) { properties.put("evidence", this._evidence.asJava) }
  if (this._keyValuePairs.nonEmpty) { properties.put("keyValuePairs", this._keyValuePairs.asJava) }
  properties
}

  def _keyValuePairViaContainsNodeOut: Iterator[KeyValuePair] = _containsNodeOut.asScala.collect { case node: KeyValuePair => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Finding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "evidence" 
case 2 => "keyValuePairs" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => evidence
case 2 => keyValuePairs
    }

  override def productPrefix = "Finding"
  override def productArity = 3

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FindingDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {

  case "evidence" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "keyValuePairs" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {

  case "evidence" => this._evidence
  case "keyValuePairs" => this._keyValuePairs
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {

  case "evidence" => this._evidence = value match {
    case null | None => Nil
    case someVal:CpgNode => this._evidence :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[CpgNode]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[CpgNode]]
  }
  case "keyValuePairs" => this._keyValuePairs = value match {
    case null | None => Nil
    case someVal:KeyValuePair => this._keyValuePairs :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[KeyValuePair]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[KeyValuePair]]
  }
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewFinding]

  this._evidence = if(other.evidence == null) Nil else other.evidence.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[CpgNode]
    case oldNode:StoredNode => oldNode.asInstanceOf[CpgNode]
    case _ => throw new MatchError("unreachable")
  }}
  this._keyValuePairs = if(other.keyValuePairs == null) Nil else other.keyValuePairs.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[KeyValuePair]
    case oldNode:StoredNode => oldNode.asInstanceOf[KeyValuePair]
    case _ => throw new MatchError("unreachable")
  }}

}

}
