package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Flow {
  def apply(graph: OdbGraph, id: Long) = new Flow(graph, id)

  val Label = "FLOW"
  val LabelId: Int = 207

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("points", "source", "sink", "transformations", "branchPoints", "cfgNodes")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[FlowDb] {
    override val forLabel = Flow.Label
    override val forLabelId = Flow.LabelId

    override def createNode(ref: NodeRef[FlowDb]) =
      new FlowDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Flow(graph, id)
  }
}

trait FlowBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def points: List[ProgramPointBase]
def source: SourceBase
def sink: SinkBase
def transformations: List[TransformationBase]
def branchPoints: List[TrackingPointBase]
def cfgNodes: List[CfgNodeBase]
}

class Flow(graph: OdbGraph, id: Long) extends NodeRef[FlowDb](graph, id)
  with FlowBase
  with StoredNode
   {
  
    def points = get().points
  def source = get().source
  def sink = get().sink
  def transformations = get().transformations
  def branchPoints = get().branchPoints
  def cfgNodes = get().cfgNodes
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sinkViaContainsNodeOut: Iterator[Sink] = get()._sinkViaContainsNodeOut
def _cfgNodeViaContainsNodeOut: Iterator[CfgNode] = get()._cfgNodeViaContainsNodeOut
def _transformationViaContainsNodeOut: Iterator[Transformation] = get()._transformationViaContainsNodeOut
def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = get()._trackingPointViaContainsNodeOut
def _programPointViaContainsNodeOut: Iterator[ProgramPoint] = get()._programPointViaContainsNodeOut
def _sourceViaContainsNodeOut: Iterator[Source] = get()._sourceViaContainsNodeOut
def _writeViaContainsNodeIn: Iterator[Write] = get()._writeViaContainsNodeIn
def _readViaContainsNodeIn: Iterator[Read] = get()._readViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = get()._ioflowViaContainsNodeIn
def _transformViaContainsNodeIn: Iterator[Transform] = get()._transformViaContainsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Flow.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "points" 
case 2 => "source" 
case 3 => "sink" 
case 4 => "transformations" 
case 5 => "branchPoints" 
case 6 => "cfgNodes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => points
case 2 => source
case 3 => sink
case 4 => transformations
case 5 => branchPoints
case 6 => cfgNodes
    }

  override def productPrefix = "Flow"
  override def productArity = 7
}

class FlowDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with FlowBase {

  override def layoutInformation: NodeLayoutInformation = Flow.layoutInformation



private var _points: List[ProgramPoint] = Nil
def points: List[ProgramPoint] = this._points


private var _source: Source = null
def source: Source = this._source


private var _sink: Sink = null
def sink: Sink = this._sink


private var _transformations: List[Transformation] = Nil
def transformations: List[Transformation] = this._transformations


private var _branchPoints: List[TrackingPoint] = Nil
def branchPoints: List[TrackingPoint] = this._branchPoints


private var _cfgNodes: List[CfgNode] = Nil
def cfgNodes: List[CfgNode] = this._cfgNodes


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

  if (this._points.nonEmpty) { properties.put("points", this._points.asJava) }
   if (this._source != null) { properties.put("source", this._source) }
   if (this._sink != null) { properties.put("sink", this._sink) }
  if (this._transformations.nonEmpty) { properties.put("transformations", this._transformations.asJava) }
  if (this._branchPoints.nonEmpty) { properties.put("branchPoints", this._branchPoints.asJava) }
  if (this._cfgNodes.nonEmpty) { properties.put("cfgNodes", this._cfgNodes.asJava) }
  properties
}

  def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = _containsNodeOut.asScala.collect { case node: TrackingPoint => node }
def _cfgNodeViaContainsNodeOut: Iterator[CfgNode] = _containsNodeOut.asScala.collect { case node: CfgNode => node }
def _sinkViaContainsNodeOut: Iterator[Sink] = _containsNodeOut.asScala.collect { case node: Sink => node }
def _transformationViaContainsNodeOut: Iterator[Transformation] = _containsNodeOut.asScala.collect { case node: Transformation => node }
def _sourceViaContainsNodeOut: Iterator[Source] = _containsNodeOut.asScala.collect { case node: Source => node }
def _programPointViaContainsNodeOut: Iterator[ProgramPoint] = _containsNodeOut.asScala.collect { case node: ProgramPoint => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _transformViaContainsNodeIn: Iterator[Transform] = _containsNodeIn.asScala.collect { case node: Transform => node }
def _writeViaContainsNodeIn: Iterator[Write] = _containsNodeIn.asScala.collect { case node: Write => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeIn: Iterator[Ioflow] = _containsNodeIn.asScala.collect { case node: Ioflow => node }
def _readViaContainsNodeIn: Iterator[Read] = _containsNodeIn.asScala.collect { case node: Read => node }

  override def label: String = {
    Flow.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "points" 
case 2 => "source" 
case 3 => "sink" 
case 4 => "transformations" 
case 5 => "branchPoints" 
case 6 => "cfgNodes" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => points
case 2 => source
case 3 => sink
case 4 => transformations
case 5 => branchPoints
case 6 => cfgNodes
    }

  override def productPrefix = "Flow"
  override def productArity = 7

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FlowDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {

  case "points" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "source" => if(this._source == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._source.asInstanceOf[A])
  case "sink" => if(this._sink == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._sink.asInstanceOf[A])
  case "transformations" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "branchPoints" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case "cfgNodes" => throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey(key)
  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {

  case "points" => this._points
  case "source" => this._source
  case "sink" => this._sink
  case "transformations" => this._transformations
  case "branchPoints" => this._branchPoints
  case "cfgNodes" => this._cfgNodes
  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {

  case "points" => this._points = value match {
    case null | None => Nil
    case someVal:ProgramPoint => this._points :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[ProgramPoint]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[ProgramPoint]]
  }
  case "source" => this._source =     value.asInstanceOf[Source]
  case "sink" => this._sink =     value.asInstanceOf[Sink]
  case "transformations" => this._transformations = value match {
    case null | None => Nil
    case someVal:Transformation => this._transformations :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Transformation]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[Transformation]]
  }
  case "branchPoints" => this._branchPoints = value match {
    case null | None => Nil
    case someVal:TrackingPoint => this._branchPoints :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[TrackingPoint]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[TrackingPoint]]
  }
  case "cfgNodes" => this._cfgNodes = value match {
    case null | None => Nil
    case someVal:CfgNode => this._cfgNodes :+ someVal // todo: deprecate
    case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[CfgNode]].iterator.asScala.toList
    case lst: List[_] => value.asInstanceOf[List[CfgNode]]
  }
  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewFlow]

  this._points = if(other.points == null) Nil else other.points.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[ProgramPoint]
    case oldNode:StoredNode => oldNode.asInstanceOf[ProgramPoint]
    case _ => throw new MatchError("unreachable")
  }}
  this._source = other.source match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Source]
    case oldNode: StoredNode => oldNode.asInstanceOf[Source]
    case _ => throw new MatchError("unreachable")
  }
  this._sink = other.sink match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[Sink]
    case oldNode: StoredNode => oldNode.asInstanceOf[Sink]
    case _ => throw new MatchError("unreachable")
  }
  this._transformations = if(other.transformations == null) Nil else other.transformations.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Transformation]
    case oldNode:StoredNode => oldNode.asInstanceOf[Transformation]
    case _ => throw new MatchError("unreachable")
  }}
  this._branchPoints = if(other.branchPoints == null) Nil else other.branchPoints.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[TrackingPoint]
    case oldNode:StoredNode => oldNode.asInstanceOf[TrackingPoint]
    case _ => throw new MatchError("unreachable")
  }}
  this._cfgNodes = if(other.cfgNodes == null) Nil else other.cfgNodes.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[CfgNode]
    case oldNode:StoredNode => oldNode.asInstanceOf[CfgNode]
    case _ => throw new MatchError("unreachable")
  }}

}

}
