package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object Framework {
  def apply(graph: OdbGraph, id: Long) = new Framework(graph, id)

  val Label = "FRAMEWORK"
  val LabelId: Int = 42

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.AttachedData.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object PropertyNames {
    val all: Set[String] = Set("NAME")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("ATTACHED_DATA","CONTAINS_NODE")
  }

  val factory = new NodeFactory[FrameworkDb] {
    override val forLabel = Framework.Label
    override val forLabelId = Framework.LabelId

    override def createNode(ref: NodeRef[FrameworkDb]) =
      new FrameworkDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = Framework(graph, id)
  }
}

trait FrameworkBase extends CpgNode  with HasName {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Framework(graph: OdbGraph, id: Long) extends NodeRef[FrameworkDb](graph, id)
  with FrameworkBase
  with StoredNode
   {
    override def name: String = get().name
  
  def _frameworkDataViaAttachedDataOut: Iterator[FrameworkData] = get()._frameworkDataViaAttachedDataOut
override def _attachedDataOut(): JIterator[StoredNode] = get()._attachedDataOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Framework.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
    }

  override def productPrefix = "Framework"
  override def productArity = 2
}

class FrameworkDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
   with FrameworkBase {

  override def layoutInformation: NodeLayoutInformation = Framework.layoutInformation

private var _name: String = null
def name(): String = _name


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }

  properties
}

  def _frameworkDataViaAttachedDataOut: Iterator[FrameworkData] = _attachedDataOut.asScala.collect { case node: FrameworkData => node }
override def _attachedDataOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Framework.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => name
    }

  override def productPrefix = "Framework"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[FrameworkDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "NAME" => if(this._name == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._name.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "NAME" => this._name

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "NAME" => this._name = value.asInstanceOf[String]

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewFramework]
   this._name = other.name


}

}
