package io.shiftleft.codepropertygraph.generated.nodes

import gremlin.scala._
import io.shiftleft.codepropertygraph.generated.EdgeKeys
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import org.apache.tinkerpop.gremlin.structure.{Direction, Vertex, VertexProperty}
import overflowdb.{EdgeFactory, NodeFactory, NodeLayoutInformation, OdbElement, OdbNode, OdbGraph, OdbNodeProperty, NodeRef, PropertyKey}
import overflowdb.traversal.Traversal
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils
import scala.jdk.CollectionConverters._

object ImplicitCall {
  def apply(graph: OdbGraph, id: Long) = new ImplicitCall(graph, id)

  val Label = "IMPLICIT_CALL"
  val LabelId: Int = 307

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object PropertyNames {
    val all: Set[String] = Set("DEPTH_FIRST_ORDER", "INTERNAL_FLAGS", "CODE", "NAME", "SIGNATURE", "LINE_NUMBER", "COLUMN_NUMBER", "ORDER")
    val allAsJava: JSet[String] = all.asJava
  }

  object Edges {
    val In: Array[String] = Array("AST","CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[ImplicitCallDb] {
    override val forLabel = ImplicitCall.Label
    override val forLabelId = ImplicitCall.LabelId

    override def createNode(ref: NodeRef[ImplicitCallDb]) =
      new ImplicitCallDb(ref.asInstanceOf[NodeRef[OdbNode]])

    override def createNodeRef(graph: OdbGraph, id: Long) = ImplicitCall(graph, id)
  }
}

trait ImplicitCallBase extends CpgNode with CallReprBase with TrackingPointBase with HasDepthFirstOrder with HasInternalFlags with HasCode with HasName with HasSignature with HasLineNumber with HasColumnNumber with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class ImplicitCall(graph: OdbGraph, id: Long) extends NodeRef[ImplicitCallDb](graph, id)
  with ImplicitCallBase
  with StoredNode
  with CallRepr with TrackingPoint {
    override def depthFirstOrder: Option[Integer] = get().depthFirstOrder
  override def internalFlags: Option[Integer] = get().internalFlags
  override def code: String = get().code
  override def name: String = get().name
  override def signature: String = get().signature
  override def lineNumber: Option[Integer] = get().lineNumber
  override def columnNumber: Option[Integer] = get().columnNumber
  override def order: Integer = get().order
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodViaAstIn: Iterator[Method] = get()._methodViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    ImplicitCall.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "name" 
case 5 => "signature" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
case 8 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => name
case 5 => signature
case 6 => lineNumber
case 7 => columnNumber
case 8 => order
    }

  override def productPrefix = "ImplicitCall"
  override def productArity = 9
}

class ImplicitCallDb(ref: NodeRef[OdbNode]) extends OdbNode(ref) with StoredNode
  with CallRepr with TrackingPoint with ImplicitCallBase {

  override def layoutInformation: NodeLayoutInformation = ImplicitCall.layoutInformation

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags

private var _code: String = null
def code(): String = _code

private var _name: String = null
def name(): String = _name

private var _signature: String = null
def signature(): String = _signature

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _order: Integer = null
def order(): Integer = _order


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }
if (code != null) { properties.put("CODE", code) }
if (name != null) { properties.put("NAME", name) }
if (signature != null) { properties.put("SIGNATURE", signature) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstIn: Iterator[Method] = _astIn.asScala.collect { case node: Method => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    ImplicitCall.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "depthFirstOrder" 
case 2 => "internalFlags" 
case 3 => "code" 
case 4 => "name" 
case 5 => "signature" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
case 8 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id2
case 1 => depthFirstOrder
case 2 => internalFlags
case 3 => code
case 4 => name
case 5 => signature
case 6 => lineNumber
case 7 => columnNumber
case 8 => order
    }

  override def productPrefix = "ImplicitCall"
  override def productArity = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ImplicitCallDb]

  /* performance optimisation to save instantiating an iterator for each property lookup */
override protected def specificProperty[A](key: String): VertexProperty[A] = {
  key match {
  case "DEPTH_FIRST_ORDER" => if(this._depthFirstOrder.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._depthFirstOrder.get.asInstanceOf[A])
  case "INTERNAL_FLAGS" => if(this._internalFlags.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._internalFlags.get.asInstanceOf[A])
  case "CODE" => if(this._code == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._code.asInstanceOf[A])
  case "NAME" => if(this._name == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._name.asInstanceOf[A])
  case "SIGNATURE" => if(this._signature == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._signature.asInstanceOf[A])
  case "LINE_NUMBER" => if(this._lineNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._lineNumber.get.asInstanceOf[A])
  case "COLUMN_NUMBER" => if(this._columnNumber.isEmpty) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._columnNumber.get.asInstanceOf[A])
  case "ORDER" => if(this._order == null) VertexProperty.empty[A]
      else new OdbNodeProperty(-1, this, key, this._order.asInstanceOf[A])

  case _ => VertexProperty.empty[A]
  }
}

  override protected def updateSpecificProperty[A](cardinality: VertexProperty.Cardinality, key: String, value: A): VertexProperty[A] = {
    this.internalSetProperty(key, value)
    new OdbNodeProperty(-1, this, key, value)
  }
override def specificProperty2(key:String): AnyRef = {
  key match {
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder.orNull
  case "INTERNAL_FLAGS" => this._internalFlags.orNull
  case "CODE" => this._code
  case "NAME" => this._name
  case "SIGNATURE" => this._signature
  case "LINE_NUMBER" => this._lineNumber.orNull
  case "COLUMN_NUMBER" => this._columnNumber.orNull
  case "ORDER" => this._order

  case _ => null
  }
}

private def internalSetProperty[A](key:String, value: A):Unit = {
  key match {
  case "DEPTH_FIRST_ORDER" => this._depthFirstOrder = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "INTERNAL_FLAGS" => this._internalFlags = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "CODE" => this._code = value.asInstanceOf[String]
  case "NAME" => this._name = value.asInstanceOf[String]
  case "SIGNATURE" => this._signature = value.asInstanceOf[String]
  case "LINE_NUMBER" => this._lineNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "COLUMN_NUMBER" => this._columnNumber = value match {
    case null | None => None
    case someVal:Integer => Some(someVal)
  }
  case "ORDER" => this._order = value.asInstanceOf[Integer]

  case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
  }
}

override def removeSpecificProperty(key: String): Unit = this.internalSetProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewImplicitCall]
   this._depthFirstOrder = other.depthFirstOrder
   this._internalFlags = other.internalFlags
   this._code = other.code
   this._name = other.name
   this._signature = other.signature
   this._lineNumber = other.lineNumber
   this._columnNumber = other.columnNumber
   this._order = other.order


}

}
